! Additional_Exogenous_Criteria_for_Real_Trajs.F90

! This code is included from the find_longest_candidate_trajectory.f90 if the parameter 
! This code places pass/fail criteria on candidate trajectories.  If a candidate traj passes the parameter "candidate_passes" is set to 1; otherwise 0
! This code is executed after all candidate trajectories have been found for a specific pair of a progenitor and first descendant centroid
! The longest candidate trajectory is selected as the "real trajectory"
! Just before this selection occurs, candidate trajectories can be thrown out (excluded from consideration) using criteria that are selected based on the characteristics of a certain flow field
! E.g., for flow fields in the center of a riser, we know all trajectories are moving upward, so candidate trajectories going downward can be removed from consideration!--------->  Keep code spaced over so I can paste it back into 
          real_trajectory_passed = 1
          ! Apply pass/fail test to each centroid pair along each candidate trajectory
          do tc = 1 , ( candidate_trajectory_total_length(longest_candidate_trajectory_no) -1 )  ! scan of length of a candidate trajectory, except last centroid
            ! Specify the centroid pair as having centroid numbers "icc" and "icc_next"
            icc =      candidate_trajectory_centroid(longest_candidate_trajectory_no,tc  )  
            icc_next = candidate_trajectory_centroid(longest_candidate_trajectory_no,tc+1) 
             
            ! Place calculations based on centroid pairs here
            delt_y = y(icc_next) - y(icc); delt_x = x(icc_next) - x(icc); !delt_r = sqrt(delt_x**2 + delt_y**2)
            degree_traj = atan2(delt_y,delt_x) * 57.295779  ! atan is in radians, so convert to degrees degrees
            length = (delt_x**2 + delt_y**2)**0.5
             ! ************* criterion_1 ***********************
            if ( length .gt. 15 ) then
               real_trajectory_passed = 0;
               write(925,9258) length, longest_candidate_trajectory_no, real_trajectory_no+1;
               9258 format("length=",f10.1,"  cand traj ",i5," failed criteria for real traj",i5);
            end if
          end do
             ! ************* end criterion_1 *******************            
          !________________ End of pass/fail criteria  _____________________ 

