﻿! declarations_section_for_Trajectory_Identification.f90

program test
IMPLICIT NONE
integer i,j,k
integer, parameter :: TOTAL_NUMBER_OF_CENTROIDS = 1150000000
integer, parameter :: TOTAL_NUMBER_OF_FRAMES = 500000
integer, parameter :: TOTAL_NUMBER_OF_REAL_TRAJECTORIES = 1000000
integer, parameter :: MAXIMUM_TRAJECTORY_LENGTH = 300
integer, parameter :: MAXIMUM_CANDIDATE_TRAJECTORIES = 20000

! Need to set location_in_candidate trajectory >= max_length_real_traj !
! And candidate_trajectory_no should reset to zero for each next 1st descendant, so it should be the max no cand_traj that can occur in a frame
integer, allocatable :: candidate_trajectory_total_length(:) ! argument=candidate_trajectory_no, which should be reset to 0 after each 1st desc
integer, allocatable :: candidate_trajectory_centroid(:,:) !arguments= (candidate_trajectory_no, location_in_candidate_trajectory) location_in_candidate_trajectory should always be less than max_length_real_traj
integer candidate_trajectory_tree !(candidate_progenitor, candidate_trajectory_no, MAXIMUM_TRAJECTORY_LENGTH+10 )

! Trajectory Arrays:  First subscript is the max number of real trajectoryies and the second subscript is the max length of a trajectory
! The following two dimensional arrays take up the most memory and can cause memory overload errors.
! These 2D Arrays cause the program image size to be greater the 2 GB, which causes LNK1248 error and other runtime errors
integer, allocatable :: real_trajectory_centroid( :,: )  !(real_trajectory_no, location_in_candidate_trajectory)
real,    allocatable :: speed_along_traj( :,: )
real,    allocatable :: angle_along_traj( :,: )  !(real_trajectory_no, location_in_candidate_trajectory)


! ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ ARRAY DECLARATION SECTION ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
real,    allocatable :: avg_speed_of_traj(:), avg_angle_of_traj(:) !(real_trajectory_no)
integer, allocatable :: real_trajectory_total_length(:) !(real_trajectory_no)


ALLOCATE(candidate_trajectory_total_length(-1:MAXIMUM_CANDIDATE_TRAJECTORIES)) ! argument=candidate_trajectory_no, which should be reset to 0 after each 1st desc
ALLOCATE(candidate_trajectory_centroid(-1:MAXIMUM_CANDIDATE_TRAJECTORIES,MAXIMUM_TRAJECTORY_LENGTH+10)) !arguments= (candidate_trajectory_no, location_in_candidate_trajectory) location_in_candidate_trajectory should always be less than max_length_real_traj


ALLOCATE(real_trajectory_centroid( TOTAL_NUMBER_OF_REAL_TRAJECTORIES , MAXIMUM_TRAJECTORY_LENGTH ))
ALLOCATE(speed_along_traj( TOTAL_NUMBER_OF_REAL_TRAJECTORIES , MAXIMUM_TRAJECTORY_LENGTH ))
ALLOCATE(angle_along_traj( TOTAL_NUMBER_OF_REAL_TRAJECTORIES , MAXIMUM_TRAJECTORY_LENGTH ))

ALLOCATE(avg_speed_of_traj(TOTAL_NUMBER_OF_REAL_TRAJECTORIES))
ALLOCATE(avg_angle_of_traj(TOTAL_NUMBER_OF_REAL_TRAJECTORIES)) !(real_trajectory_no)
ALLOCATE(real_trajectory_total_length(TOTAL_NUMBER_OF_REAL_TRAJECTORIES)) !(real_trajectory_no)


print*, "shape is ", SHAPE(real_trajectory_centroid)
end program test

                                     