! Read_traj_data_from_output_files_from_Trajectory_Identification.f90
print*, 'Reading trajectory data from Trajectory_Identification results'
! ******************* Read Trajectory Data from output files *****************************************

! **************** Read_raw_data_by_trajectory_for_post_processing.f90 **************************
! first set "is_centroid_in_a_real_trajectory(cc)" to zero for all centroids.  Below I set this to 1 if a centroid is in a real traj.
do cc = 1,  total_no_centroids; is_centroid_in_a_real_trajectory(cc)=0 ; end do   
! Reads from file unit 101 'raw_data_by_trajectory_for_post_processing.txt' in the output folder of Trajectory_Identification
read(101,*) total_no_real_trajectories;  print*, 'The total number of trajectories is ', total_no_real_trajectories
if(debug .gt. 0.1) write(9000,*) total_no_real_trajectories ! write out this file so it can be checked to make sure it was read correctly
do i = 1 , total_no_real_trajectories 
   read(101,*)   real_trajectory_no, real_trajectory_total_length(real_trajectory_no)
   if(debug .gt. 0.1) write(9000,*) real_trajectory_no, real_trajectory_total_length(real_trajectory_no) ! write out this file so it can be checked to make sure it was read correctly
   do j = 1 , real_trajectory_total_length(real_trajectory_no)  ! scan of length of a real trajectory    
     if( j .lt. real_trajectory_total_length(i) ) then
        read(101,*) real_trajectory_no,  tc,   itemp2,  cc, rtemp1, rtemp2, dummy1, dummy2  ! We don't have to read x and y for cc because it was read already, and we don't need to read speed and angle because we calculate it
        is_centroid_in_a_real_trajectory(cc) = 1
        ! frame_no_of_a_centroid(cc) = itemp2;  !tc = itemp1  ! These are already read in read_particle_centroid_data.f90
        if(debug .gt. 0.1) write(9000,4002) real_trajectory_no,  tc,  frame_no_of_a_centroid(cc),  cc, x(cc), y(cc), dummy1, dummy2
     else ! Don't read speed and angle for last centroid in a traj
        read(101,*) real_trajectory_no,  tc,   itemp1,  cc, rtemp1, rtemp2
        if(debug .gt. 0.1) write(9000,4002) real_trajectory_no,  tc,   frame_no_of_a_centroid(cc),  cc, x(cc), y(cc) ! write out this file so it can be checked to make sure it was read correctly
     end if    
     real_trajectory_centroid(real_trajectory_no,tc) = cc
     real_trajectory_no_of_centroid(cc) = real_trajectory_no       
     position_of_centroid_in_trajectory(cc) = tc  
   end do
end do
4002 format(        i7,',',            2x,i7,','       ,2x,i7,',',                1x,i9,',',  2(2x,f8.1,','),  5x,f13.7,',',5x,f13.7   ) ;  
! include 'read_speed_and_angle_along_traj.f90'  do not need to read this anymore because all of the data is read from read_raw_data_by_trajectory_for_post_processing.f90
! **************** finished read_raw_data_by_trajectory_for_post_processing.f90 *****************

! ***************** Read from 'average_speed_and_angle_by_trajectory.txt' ********************
! PROBABLY DON'T NEED TO READ THIS BECAUSE IT'S CALCULATED LATER....
do i=1,2; read(103,136) A_temp; end do !read past header
do i = 1 , total_no_real_trajectories 
     first_cc = real_trajectory_centroid(i,1);
     read(103,*)      real_trajectory_no, dummy, avg_speed_of_traj(i), avg_angle_of_traj(i)
     !write(7992,7993) real_trajectory_no, frame_no_of_a_centroid(first_cc), avg_speed_of_traj(i), avg_angle_of_traj(i) ! write out this file so it can be checked to make sure it was read correctly
end do
7993 format(i6,6x,i6,10x,f12.5,12x,f12.5)

! ************************ End Read Trajectory Data *****************************************