! Write_MTrackJ_data_auto_color_curve_fitted_trajs.f90

! Calculate the lowest and highest velocity in the real_trajectories
! Recall that all speeds are magnitudes of a velocity vector, so speed is always positive.  The angle determines direction.
min_average_speed_along_a_trajectory=100; max_average_speed_along_a_trajectory=0
cumulative = 0
do real_trajectory_no = 1 , total_no_real_trajectories
   cumulative = cumulative + avg_speed_of_traj(i)
   if(avg_speed_of_traj(real_trajectory_no) .gt. max_average_speed_along_a_trajectory) then 
      max_average_speed_along_a_trajectory = avg_speed_of_traj(real_trajectory_no) 
      real_trajectory_of_max_speed = real_trajectory_no
      temp_cc = real_trajectory_centroid(real_trajectory_no, 1)
      frame_no_of_max_speed = frame_no_of_a_centroid(temp_cc)
   end if;
   if(avg_speed_of_traj(real_trajectory_no) .lt. min_average_speed_along_a_trajectory) then 
      min_average_speed_along_a_trajectory = avg_speed_of_traj(real_trajectory_no) 
      real_trajectory_of_min_speed = real_trajectory_no
      temp_cc = real_trajectory_centroid(real_trajectory_no, 1)
      frame_no_of_min_speed = frame_no_of_a_centroid(temp_cc)
   end if;  
!write(2999,3213) real_trajectory_no, avg_speed_of_traj(real_trajectory_no), min_average_speed_along_a_trajectory, max_average_speed_along_a_trajectory
!3213 format(i6,3(f10.4))
end do 

write(*,3234)   min_average_speed_along_a_trajectory, real_trajectory_of_min_speed, frame_no_of_min_speed
write(599,3234) min_average_speed_along_a_trajectory, real_trajectory_of_min_speed, frame_no_of_min_speed
3234 format(/,/,'MIN SPEED = ',e12.5,' mps; traj no = ',i6,' ; frame = ',i5)

write(*,3235)   max_average_speed_along_a_trajectory, real_trajectory_of_max_speed, frame_no_of_max_speed
write(599,3235) max_average_speed_along_a_trajectory, real_trajectory_of_max_speed, frame_no_of_max_speed
3235 format('MAX SPEED = ',f9.3,' mps; traj no = ',i6,' ; frame = ',i7)

rtemp1 = cumulative / total_no_real_trajectories
write(*,3236)   rtemp1, ( max_average_speed_along_a_trajectory - min_average_speed_along_a_trajectory ) / 2 + min_average_speed_along_a_trajectory
write(905,3236) rtemp1, ( max_average_speed_along_a_trajectory - min_average_speed_along_a_trajectory ) / 2 + min_average_speed_along_a_trajectory
3236 format('Mean speed = ',f9.3,' mps : halfway between min and max =', f9.3)



! _________________ PSEUDOCOLOR TRAJECTORIES FOR MTRACKJ FILE ___________________________________
! Here I set the pseudocoloring for velocity vector magnitudes
! Usually, the maximum velocity is far outside the range of most velocity vectors, so 
! if I set the pseudocoloring range based on the max velocity, most vectors are blue and very few are red
! so I adjust the pseudocoloring range using an exogenously input parameter,  pseudocolor_factor
! as shown below
vmin = min_average_speed_along_a_trajectory; vmax = max_average_speed_along_a_trajectory; 
if(vmin .lt. 0) vmin = 0.0 ;  v_range =  pseudocolor_factor * vmax - vmin 

print*, ' '
print*, 'Velocity range for pseudocoloring is Vmin = 0 to Vmax = ', pseudocolor_factor * vmax 
print*, ' '

do real_trajectory_no = 1 , total_no_real_trajectories
  ! The next line uses abs so that negative velocities are pseudocolored according to magnitude only, not direction
  spd= abs(avg_speed_of_traj(real_trajectory_no));   
      if( spd .ge. vmin+0.00*v_range .and. spd .lt. vmin+0.05*v_range ) color='1B1A5F'
      if( spd .ge. vmin+0.05*v_range .and. spd .lt. vmin+0.10*v_range ) color='113279'
      if( spd .ge. vmin+0.10*v_range .and. spd .lt. vmin+0.15*v_range ) color='0A5397'
      if( spd .ge. vmin+0.15*v_range .and. spd .lt. vmin+0.20*v_range ) color='106CAC'
      if( spd .ge. vmin+0.20*v_range .and. spd .lt. vmin+0.25*v_range ) color='147CB5'
      if( spd .ge. vmin+0.25*v_range .and. spd .lt. vmin+0.30*v_range ) color='159BD4'
      if( spd .ge. vmin+0.30*v_range .and. spd .lt. vmin+0.35*v_range ) color='0994A6'
      if( spd .ge. vmin+0.35*v_range .and. spd .lt. vmin+0.40*v_range ) color='0E8C62'
      if( spd .ge. vmin+0.40*v_range .and. spd .lt. vmin+0.45*v_range ) color='039331'
      if( spd .ge. vmin+0.45*v_range .and. spd .lt. vmin+0.50*v_range ) color='339C1E'
      if( spd .ge. vmin+0.50*v_range .and. spd .lt. vmin+0.55*v_range ) color='69B011'
      if( spd .ge. vmin+0.55*v_range .and. spd .lt. vmin+0.60*v_range ) color='92C00E'
      if( spd .ge. vmin+0.60*v_range .and. spd .lt. vmin+0.65*v_range ) color='B5CC0A'
      if( spd .ge. vmin+0.65*v_range .and. spd .lt. vmin+0.70*v_range ) color='E6E209'
      if( spd .ge. vmin+0.70*v_range .and. spd .lt. vmin+0.75*v_range ) color='FCCF03'
      if( spd .ge. vmin+0.75*v_range .and. spd .lt. vmin+0.80*v_range ) color='ED9E0A'
      if( spd .ge. vmin+0.80*v_range .and. spd .lt. vmin+0.85*v_range ) color='DD680B'
      if( spd .ge. vmin+0.85*v_range .and. spd .lt. vmin+0.90*v_range ) color='D44B0D'
      if( spd .ge. vmin+0.90*v_range                                  ) color='FF0000'
   !write(2999,9331) real_trajectory_no, avg_speed_of_traj(real_trajectory_no), 

   ! Frank changes start here nov 27  : recalculate centroids along trajectory using curve fitted speeds
   ! curve fit trajectories 
!   do c1=1,total_no_real_trajectories  
   !   do c2 = 1,200 ! Avoiding a longer trajectory affecting a smaller one
  !       xtempo(c2) = 0; ytempo(c2) = 0 ; fitted_x(c2) = 0 ; fitted_y(c2) = 0
 !     end do
!      do c2 = 1 , real_trajectory_total_length(c1)-1 ; 
       !  cc = real_trajectory_centroid(c1,c2)     
      !   xtempo(c2) = x(cc); ytempo(c2) = y(cc); 
     ! end do

    !  call Curve_fit_traj_with_Cholesky_method(xtempo,fitted_x,real_trajectory_total_length(c1)-1,order_of_polynomial_for_curve_fitting_trajectories);  
   !   call Curve_fit_traj_with_Cholesky_method(ytempo,fitted_y,real_trajectory_total_length(c1)-1,order_of_polynomial_for_curve_fitting_trajectories);

  !    x_fitted_along_traj(1:real_trajectory_total_length(c1)-1) = fitted_x(1:real_trajectory_total_length(c1)-1);
 !     y_fitted_along_traj(1:real_trajectory_total_length(c1)-1) = fitted_y(1:real_trajectory_total_length(c1)-1); 
!   end do

   ! Now write to input file for ImageJ MTrackJ, MTrackJ_real_trajectories_colored.mdf    
   write(6199,5990) real_trajectory_no, color; 5990 format('Track ',i8,3x,A6); 
   do tc = 1 , ( real_trajectory_total_length(real_trajectory_no) ) ! scan of length of a real trajectory   
      ic = real_trajectory_centroid(real_trajectory_no,tc)      
      ! Note that y is inverted, since I now am using the regular origin in lower left, lower right of the FOV, not ImageJ's goofy origin in upper left.
      inverted_y = y_pixels - y_fitted_along_traj(ic)      
      write(6199,5897) tc, x_fitted_along_traj(ic), inverted_y , frame_no_of_a_centroid(ic) ;  ! Write real traj point to MTrackJ file        
      5897 format('Point ',i8,1x,f6.1,1x,f6.1,1x,'1.0',1x,i6,1x,'1.0',10x); 
   end do
end do
write(6199,3893); 3893 format('End of MTrackJ Data File')

! _________________ END OF PSEUDOCOLOR TRAJECTORIES AUTOMATICALLY FOR MTRACKJ FILE ___________________________________
