! calc_area_of_subregion_covered_by_particle_images_over_avg_window.f90

! Now I -smooth the area_fraction curve because it incremental with particle number and there may be, e.g., 1 to 10 particles in each region.
! This makes the plots against solids fraction look strange.
! Also, the minimum solids concentration occurs when only one particle is seen in a consecutive sequence of frames
! So to capture this min solids concentration I calculate an avg over 11 frames

if( this_is_a_single_phase_fluid_measurement .lt. 0.1) then  ! If this is not a single phase flow, do this first section, if not, jump to the "else" section
print*, 'This is a particle flow analysis, so running calc_area_of_subregion_covered_by_particle_images_over_avg_window.f90 for particle flow!!'
   window_to_avg_area_covered_by_particles = 11  ! This must be odd
   half_window_to_avg_area_covered_by_particles = ( window_to_avg_area_covered_by_particles - 1 )/ 2
   cumulative = 0
   ! area_of_subregion_covered_by_particle_images(i,ix,iy)
   do ix = 1 , m
      do iy = 1 , n
         do frame = 1, number_of_frames_to_analyze
            ! If this frame is one of the first frames and is within half the averaging window to the first frame
            ! Calculate the area_of_subregion_covered_by_particle_images using first 11 frames
            if ( frame .le. (half_window_to_avg_area_covered_by_particles + 1) ) then
               do k = 1 , window_to_avg_area_covered_by_particles
                  cumulative = cumulative + area_of_subregion_covered_by_particle_images(k,ix,iy)
               end do 
               area_of_subregion_covered_by_particle_images(frame,ix,iy) = cumulative / window_to_avg_area_covered_by_particles
               cumulative = 0
            end if
   
            if ( frame .ge. number_of_frames_to_analyze - half_window_to_avg_area_covered_by_particles ) then
               do k = number_of_frames_to_analyze - window_to_avg_area_covered_by_particles, number_of_frames_to_analyze
                  cumulative = cumulative + area_of_subregion_covered_by_particle_images(k,ix,iy)
               end do 
               area_of_subregion_covered_by_particle_images(frame,ix,iy) = cumulative / window_to_avg_area_covered_by_particles
               cumulative = 0    
            end if
    
            if( frame .ge. (half_window_to_avg_area_covered_by_particles + 1) .and. frame .le. (number_of_frames_to_analyze - half_window_to_avg_area_covered_by_particles - 1) ) then
               do k = frame - half_window_to_avg_area_covered_by_particles , frame + half_window_to_avg_area_covered_by_particles
                  cumulative = cumulative + area_of_subregion_covered_by_particle_images(k,ix,iy)
               end do 
               area_of_subregion_covered_by_particle_images(frame,ix,iy)  = cumulative / window_to_avg_area_covered_by_particles
               cumulative = 0         
            end if
         end do 
     end do
  end do

else 
print*, 'This is a single phase PIV analysis, so running calc_area_of_subregion_covered_by_particle_images_over_avg_window.f90 for single phase!!'
   ! For single-phase flow, just set area_of_subregion_covered_by_particle_images(i,ix,iy) equal to 1 because it is meaningless for single phase flows
   do ix = 1 , m
      do iy = 1 , n
         do frame = 1, number_of_frames_to_analyze
              area_of_subregion_covered_by_particle_images(frame,ix,iy) = 1
         end do 
     end do
  end do
 
 end if
