! calc_fluct_comp_and_fluct_energy_for_subregions.f90

! Now calculate fluctuating components of velocities for this frame
! Note that the fluctuating components of velocity are calculated two ways:
! using the total mean and using the rolling average 

! Loop through frames and calculate fluctuating velocities, fluctuating energies for each frame
! See the MS Word file " " in this folder for a derivation of these parameters

if ( m .ge. 1 .or. n .ge. 1) then  ! don't calculate stuff for subregions if there are no subregions!

if( this_is_a_single_phase_fluid_measurement .lt. 0.1) then  ! If this is NOT a single phase flow, do this first section, if not, jump to the "else" section  
   print*, ' ' ; print*, 'This is a particle flow analysis, '; print*, 'so running calc_fluct_comp_and_fluct_energy_for_subregions.f90'; print*,'for particle flow!!'   ;  print*, ' '
   
   ! Zero all the regional values, because some are not calculated because they don't have any/enough vel vectors; so zero them to avoid having them filled with spurious numbers from memory
   do ix = 1, m
      do iy = 1, n
         do frame=1, number_of_frames_to_analyze
            Granular_Temp_using_subregion_avg_vel(frame,ix,iy)=0
            X_RMS_fluct_comp_vel_using_subregion_avg(frame,ix,iy) = 0 ; Y_RMS_fluct_comp_vel_using_subregion_avg(frame,ix,iy) = 0
            X_RMS_fluct_comp_vel_using_total_avg_this_subregion(frame,ix,iy) = 0 ; Y_RMS_fluct_comp_vel_using_total_avg_this_subregion(frame,ix,iy) = 0
        end do
        X_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) = 0 ; Y_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) = 0
      end do
   end do

   do ix = 1, m
      do iy = 1, n
         do frame=1, number_of_frames_to_analyze
            include 'reset_counting_parameters_for_next_frame.f90'
            ! Disregard this subregion and don't do any calc for it if it doesn't have enough vectors in nearby subregions for a good avg
            ! Or, if this subregion doesn't have any velocity vectors, don't do any calc for it
            !if (does_subregion_have_enough_vectors_nearby_for_good_avg(frame,ix,iy) .gt. 0.1 .and. no_velocity_vectors_this_subregion_of_frame(frame,ix,iy) .gt. 0) then 
            if (no_velocity_vectors_this_subregion_of_frame(frame,ix,iy) .gt. 0) then 
               ! units 7530, 7560, 7660 are velocity output files for fluct comp's of velocity; each line has the frame number, then a list of fluct vel for each vel vector in the frame/region
               write(7530,7298) frame, ix, iy; write(7531,7298) frame, ix, iy; write(7630,7298) frame, ix, iy; write(7631,7298) frame, ix, iy; write(7560,7298) frame, ix, iy; write(7561,7298) frame, ix, iy; 
               write(7660,7298) frame, ix, iy; write(7661,7298) frame, ix, iy; write(7760,7298) frame, ix, iy; write(7761,7298) frame, ix, iy; 7298 format(/,i7,',',2x,i2,',',2x,i2,\); 

               !include 'reset_counting_parameters_for_next_region_of_frame.f90'  
               ! reset_counting_parameters_for_next_region_of_frame.f90                
               ! Loop through centroids (velocity vectors) in the averaging window around thisframe, calculate fluct velocity for each based on total mean and frame averaged mean  
               expanded_window_half_width = (expanded_avg_window_for_local_avg_vel_by_frame(frame) + 1)/2 -1
               ! Count the number of velocity vectors in this averaging window
               first_frame_of_averaging_window = (frame - expanded_window_half_width); last_frame_of_averaging_window = (frame + expanded_window_half_width) 
               if ( first_frame_of_averaging_window .le. 0 ) first_frame_of_averaging_window = 1
               if ( last_frame_of_averaging_window  .ge. number_of_frames_to_analyze ) last_frame_of_averaging_window = number_of_frames_to_analyze

               do window_frame = first_frame_of_averaging_window , last_frame_of_averaging_window
                  ! Loop through centroids (velocity vectors) in this subregion, calculate fluct velocity for each, etc  
                  cc = first_centroid_in_frame(window_frame)   ;    
                  do while ( cc .le. last_centroid_in_frame(window_frame) ) 
                     if (subregion_x_cc(cc) .eq. ix .and. subregion_y_cc(cc) .eq. iy) then ! only do calculations for this subregion (ix,iy)
                        if ( is_centroid_in_a_real_trajectory(cc) .gt. 0 ) then  ! only use centroids that are actually in a trajectory          
                           real_trajectory_no = real_trajectory_no_of_centroid(cc);  tc = position_of_centroid_in_trajectory(cc)
                           if ( tc .ne. real_trajectory_total_length(real_trajectory_no) .and.  frame_avg_Y_velocity_at_subregion(frame,ix,iy) .ne. 0) then   ! Balaji change Add if statement for last centroid of trajectory
                              ! Calc fluctuating components of velocity for velocities in this frame using two different means    
                              ! Note that for single phase flow, the total_mean_X_velocity_all_frames_for_subregion(ix,iy) is the same as frame_avg_X_velocity_at_subregion(frame, ix, iy),
                              ! so the "individual_part_X_vel_minus_local_avg_X_vel" is the same as the "individual_particle_Y_vel_minus_total_mean_vel"
                              individual_part_X_vel_minus_local_avg_X_vel =     x_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc) - frame_avg_X_velocity_at_subregion(frame,ix,iy)
                              individual_part_Y_vel_minus_local_avg_Y_vel =     y_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc) - frame_avg_Y_velocity_at_subregion(frame,ix,iy)
                              individual_particle_X_vel_minus_total_mean_vel =  x_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc) - total_mean_X_velocity_all_frames_for_subregion(ix,iy) 
                              individual_particle_Y_vel_minus_total_mean_vel =  y_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc) - total_mean_Y_velocity_all_frames_for_subregion(ix,iy)
                              ! Sum together the squares of fluctuating velocities of velocity vectors in this region of this frame
                              sum_of_squares_of_Vx_minus_local_avg = sum_of_squares_of_Vx_minus_local_avg + individual_part_X_vel_minus_local_avg_X_vel**2
                              sum_of_squares_of_Vy_minus_local_avg = sum_of_squares_of_Vy_minus_local_avg + individual_part_Y_vel_minus_local_avg_Y_vel**2
                              sum_of_squares_of_Vx_minus_total_mean_Vx = sum_of_squares_of_Vx_minus_total_mean_Vx + individual_particle_X_vel_minus_total_mean_vel**2
                              sum_of_squares_of_Vy_minus_total_mean_Vy = sum_of_squares_of_Vy_minus_total_mean_Vy + individual_particle_Y_vel_minus_total_mean_vel**2             
                           
                           end if
                        end if
                        
                     end if
                     cc = cc + 1          
                  end do  ! end of do loop to loop through velocity vectors for this frame
               end do  ! end of do loop to loop through window_frames of averaging window
              include 'Write_velocity_and_fluctuating_component_subregions.f90'  ! This writes to files like "X_component_of_velocity_by_frame.txt"
               ! Now calculate fluctuating components of velocity for each frame, but using expanded averaging window based on the min no vectors required for a good local average
               ! The reason that an expanded window must be used, is that there are not enough vectors in each frame to get a "good" fluctuating component, and GT, for each frame
               ! E.g., some frames have only one or two vectors.  So that would not give a good, realistic value of the true RMS and GT for that frame      
               X_RMS_fluct_comp_vel_using_subregion_avg(frame,ix,iy) =  sqrt( sum_of_squares_of_Vx_minus_local_avg / no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy) )
               Y_RMS_fluct_comp_vel_using_subregion_avg(frame,ix,iy) =  sqrt( sum_of_squares_of_Vy_minus_local_avg / no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy) )
                 
               !X_RMS_fluct_comp_vel_using_total_avg_this_subregion(frame,ix,iy) =  sqrt( sum_of_squares_of_X_vel_minus_total_X_mean_vel / no_velocity_vectors_this_subregion_total_for_all_frames )
               !Y_RMS_fluct_comp_vel_using_total_avg_this_subregion(frame,ix,iy) =  sqrt( sum_of_squares_of_Y_vel_minus_total_Y_mean_vel / no_velocity_vectors_this_subregion_total_for_all_frames )

               X_RMS_fluct_comp_vel_using_total_avg_this_subregion(frame,ix,iy) =  sqrt( sum_of_squares_of_Vx_minus_total_mean_Vx / no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy) )
               Y_RMS_fluct_comp_vel_using_total_avg_this_subregion(frame,ix,iy) =  sqrt( sum_of_squares_of_Vy_minus_total_mean_Vy / no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy) )

               ! Need to figure out correct formula for "turbulence intensity" 
               !X_intensity_of_velocity_fluctuations_by_subregion(frame,ix,iy) = 100 * X_RMS_fluct_comp_vel_using_subregion_avg(frame,ix,iy) / rolling_average_window_size_in_frames
               !Y_intensity_of_velocity_fluctuations_by_subregion(frame,ix,iy) = 100 * Y_RMS_fluct_comp_vel_using_subregion_avg(frame,ix,iy) / rolling_average_window_size_in_frames
               
               ! Now calculate granular temperature for each frame: For the wall case, use 1/3, for inside a flow field with 3D flow, use 2/3: CHANGE THIS FOR FLOW INSIDE RISER
               Granular_Temp_using_subregion_avg_vel(frame,ix,iy) =                0.6666667 * X_RMS_fluct_comp_vel_using_subregion_avg(frame,ix,iy)**2 + 0.333333 * Y_RMS_fluct_comp_vel_using_subregion_avg(frame,ix,iy)**2                                                           
               Granular_Temperature_using_total_avg_by_subregion(frame,ix,iy)   =  0.6666667 * X_RMS_fluct_comp_vel_using_total_avg_this_subregion(frame,ix,iy)**2   + 0.333333 * Y_RMS_fluct_comp_vel_using_total_avg_this_subregion(frame,ix,iy)**2                                                           
            end if
         end do
      end do
   end do 

   ! Now calc RMS of fluct comp of all vectors in a region for ALL frames
   do ix = 1, m
      do iy = 1, n
         sum_of_squares_of_X_vel_minus_total_X_mean_vel = 0 ; sum_of_squares_of_Y_vel_minus_total_Y_mean_vel = 0

         do frame=1, number_of_frames_to_analyze
             if (no_velocity_vectors_this_subregion_of_frame(frame,ix,iy) .gt. 0) then 
               ! Loop through centroids (velocity vectors) in this subregion, calculate fluct velocity for each, etc  
                cc = first_centroid_in_frame(frame)   ;    
                do while ( cc .le. last_centroid_in_frame(frame) )
                   if (subregion_x_cc(cc) .eq. ix .and. subregion_y_cc(cc) .eq. iy) then ! only do calculations for this subregion (ix,iy)
                      if ( is_centroid_in_a_real_trajectory(cc) .gt. 0 ) then  ! only use centroids that are actually in a trajectory          
                         real_trajectory_no = real_trajectory_no_of_centroid(cc);  tc = position_of_centroid_in_trajectory(cc)
                         ! Calc fluctuating components of velocity for velocities in this frame using two different means           
                         individual_particle_X_vel_minus_total_mean_vel =   x_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc) - total_mean_X_velocity_all_frames_for_subregion(ix,iy) 
                         individual_particle_Y_vel_minus_total_mean_vel =   y_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc) - total_mean_Y_velocity_all_frames_for_subregion(ix,iy)
                         ! Sum together the squares of fluctuating velocities of velocity vectors in this region of this frame
                         sum_of_squares_of_X_vel_minus_total_X_mean_vel = sum_of_squares_of_X_vel_minus_total_X_mean_vel + individual_particle_X_vel_minus_total_mean_vel**2
                         sum_of_squares_of_Y_vel_minus_total_Y_mean_vel = sum_of_squares_of_Y_vel_minus_total_Y_mean_vel + individual_particle_Y_vel_minus_total_mean_vel**2                 
                      end if
                   end if
                   cc = cc + 1          
                end do  ! end of do loop to loop through velocity vectors for this frame
            end if
         end do
                  
         if( total_vel_vectors_this_subregion_for_all_frames(ix,iy) .gt. 0 ) then
            X_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) =  sqrt( sum_of_squares_of_X_vel_minus_total_X_mean_vel / total_vel_vectors_this_subregion_for_all_frames(ix,iy)  )
            Y_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) =  sqrt( sum_of_squares_of_Y_vel_minus_total_Y_mean_vel / total_vel_vectors_this_subregion_for_all_frames(ix,iy)  )
         else
            X_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) =  0
            Y_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) =  0
         end if 

         !X_intensity_of_velocity_fluctuations_by_subregion(frame,ix,iy) = 100 * X_RMS_fluct_comp_vel_using_subregion_avg(frame,ix,iy) / rolling_average_window_size_in_frames
         !Y_intensity_of_velocity_fluctuations_by_subregion(frame,ix,iy) = 100 * Y_RMS_fluct_comp_vel_using_subregion_avg(frame,ix,iy) / rolling_average_window_size_in_frames      

         ! To avoid divide by 0 errors, make X values slightly larger than 0 
         total_mean_X_velocity_all_frames_for_subregion(ix,iy) = total_mean_X_velocity_all_frames_for_subregion(ix,iy) + 0.00000001 
         X_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) = X_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) + 0.00000001 
         
         ! Now use atan2 to find angle AND quadrant:  
         ! for atan2(y/x):
         ! atan2 gives a result type that is the same as x and is expressed in radians. 
         ! The value lies in the range -pi <= ATAN2 (y, x) <= pi. 
         ! If x is not zero, the result is approximately equal to the value of arctan (y/ x).
         ! If y > zero, the result is positive; if y < zero, the result is negative.
         
         rtemp1 = sqrt ( total_mean_X_velocity_all_frames_for_subregion(ix,iy)**2.0 + total_mean_Y_velocity_all_frames_for_subregion(ix,iy)**2.0 )
         rtemp2 = atan2 ( total_mean_Y_velocity_all_frames_for_subregion(ix,iy) , total_mean_X_velocity_all_frames_for_subregion(ix,iy) )           
         
         turbulence_intensity =  sqrt( 0.5 * ( X_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy)**2.0 + Y_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy)**2.0 ) ) !&
                                !/ abs(total_mean_X_velocity_all_frames_for_subregion(ix,iy))
         rtemp4 = atan2 ( Y_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) , X_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) )    
         
         write(230,232) ix, iy, total_mean_X_velocity_all_frames_for_subregion(ix,iy), total_mean_Y_velocity_all_frames_for_subregion(ix,iy), rtemp1, rtemp2
         232 format( i3,3x,i3, 5x, 3x,f12.7, 3x,f12.7 ) 
         
         write(330,332) ix, iy, X_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy), Y_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy), turbulence_intensity, rtemp4
         332 format( i3,3x,i3, 5x, 4( 3x,f13.7) ) 

      end do
   end do

   ! Write total fluct energy and solids fraction by subregion
   do iy = 1, n
      do ix = 1, m
         do frame = 1, number_of_frames_to_analyze
            if (no_velocity_vectors_this_subregion_of_frame(frame,ix,iy) .gt. 0) then 
               ! Disregard this subregion and don't do any calc for it if it doesn't have enough vectors in nearby subregions for a good avg
               ! Or, if this subregion doesn't have any velocity vectors, don't do any calc for it
               !if (does_subregion_have_enough_vectors_nearby_for_good_avg(frame,ix,iy) .gt. 0.1 .and. no_velocity_vectors_this_subregion_of_frame(frame,ix,iy) .gt. 0) then 
               ! Write to file='..\Standalone_Post_Processing\output\by_subregion\Granular_Temp_vs_solids_fract_etc_by_subregion.txt'
               write(5630,66313) frame, ix, iy, Relative_Particle_Concentration_by_subregion(frame,ix,iy), &
                             Granular_Temp_using_subregion_avg_vel(frame,ix,iy), Granular_Temperature_using_total_avg_by_subregion(frame,ix,iy), &
                             frame_avg_X_velocity_at_subregion(frame,ix,iy), frame_avg_Y_velocity_at_subregion(frame,ix,iy), &
                             total_mean_X_velocity_all_frames_for_subregion(ix,iy), total_mean_Y_velocity_all_frames_for_subregion(ix,iy),&
                             expanded_average_window_for_mean_vel_by_subregion(frame,ix,iy)
               66313 format(i7,1x,i3,1x,i3,2x,f10.3,11x,2(4x,f12.6),5x,4(f11.7,5x),12x,i6) 
             end if
         end do
      end do
   end do
   66315 format(i8,3x,i3,13x,f7.1,17x,f12.7,11x,f12.7)
   
else ! THIS NEXT SECTION IS USED FOR SINGLE PHASE CALCULATIONS ONLY
   
   print*, ' ' ; print*, 'This is a single-phase flow analysis, '; print*, 'so running calc_fluct_comp_and_fluct_energy_for_subregions.f90 for single-phase flow!!' ; print*, ' '
 
   ! Zero all the regional values, because some are not calculated because they don't have any/enough vel vectors; so zero them to avoid having them filled with spurious numbers from memory
   do ix = 1, m
      do iy = 1, n
         do frame=1, number_of_frames_to_analyze
            X_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) = 0 ; Y_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) = 0
        end do
      end do
   end do

   ! For single phase, add all vectors in a subregion for all frames, then calc RMS of V for that region.  Individual regions do not have an RMS.  This is the Reynolds Decomposition done for single-phase turbulent flow
   do ix = 1, m
      do iy = 1, n
         sum_of_squares_of_X_vel_minus_total_X_mean_vel = 0 ; sum_of_squares_of_Y_vel_minus_total_Y_mean_vel = 0         
         call cpu_time(fs_time); write(*,4455) ix, iy, fs_time ; 4455 format('calculating fluct vel at region (',i3,' , ',i3,') at ',f8.2,' sec',/)
         do frame=1, number_of_frames_to_analyze          
            if (no_velocity_vectors_this_subregion_of_frame(frame,ix,iy) .gt. 0) then 
               write(7530,7299) frame, ix, iy; write(7531,7298) frame, ix, iy; write(7630,7298) frame, ix, iy; write(7631,7298) frame, ix, iy; write(7560,7299) frame, ix, iy; write(7561,7298) frame, ix, iy; 
               write(7660,7299) frame, ix, iy; write(7661,7298) frame, ix, iy; write(7760,7298) frame, ix, iy; write(7761,7298) frame, ix, iy; 7299 format(/,i7,',',2x,i2,',',2x,i2,\); 
               ! Loop through centroids (velocity vectors) in this subregion, calculate fluct velocity for each, etc                 
               cc = first_centroid_in_frame(frame)   ;    
               do while ( cc .le. last_centroid_in_frame(frame) )                
                  if (subregion_x_cc(cc) .eq. ix .and. subregion_y_cc(cc) .eq. iy) then ! only do calculations for centroids/vectors in this subregion (ix,iy)
                     if ( is_centroid_in_a_real_trajectory(cc) .gt. 0 ) then  ! only use centroids that are actually in a trajectory          
                        real_trajectory_no = real_trajectory_no_of_centroid(cc);  tc = position_of_centroid_in_trajectory(cc)
                        ! Note that for single phase flow, the total_mean_X_velocity_all_frames_for_subregion(ix,iy) is the same as frame_avg_X_velocity_at_subregion(frame, ix, iy),
                        ! so the "individual_part_X_vel_minus_local_avg_X_vel" is the same as the "individual_particle_Y_vel_minus_total_mean_vel"
                        individual_particle_X_vel_minus_total_mean_vel =   x_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc) - total_mean_X_velocity_all_frames_for_subregion(ix,iy) 
                        individual_particle_Y_vel_minus_total_mean_vel =   y_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc) - total_mean_Y_velocity_all_frames_for_subregion(ix,iy)
                        ! Sum together the squares of fluctuating velocities of velocity vectors in this region of this frame
                        sum_of_squares_of_X_vel_minus_total_X_mean_vel = sum_of_squares_of_X_vel_minus_total_X_mean_vel + individual_particle_X_vel_minus_total_mean_vel**2
                        sum_of_squares_of_Y_vel_minus_total_Y_mean_vel = sum_of_squares_of_Y_vel_minus_total_Y_mean_vel + individual_particle_Y_vel_minus_total_mean_vel**2                 
                     end if
                  end if                  
                  cc = cc + 1 
               end do
            end if        
         end do  ! end of do loop to loop through velocity vectors for this frame         
         ! Some frames have no velocity vectors, so to avoid dividing by 0 and getting NaN output values -- do not calc or write values for regions with no vectors
         if( total_vel_vectors_this_subregion_for_all_frames(ix,iy) .gt. 0 ) then
            X_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) =  sqrt( sum_of_squares_of_X_vel_minus_total_X_mean_vel / total_vel_vectors_this_subregion_for_all_frames(ix,iy)  )
            Y_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) =  sqrt( sum_of_squares_of_Y_vel_minus_total_Y_mean_vel / total_vel_vectors_this_subregion_for_all_frames(ix,iy)  )
         else
            X_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) =  0
            Y_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) =  0
         end if 

         ! Calc angle of velocity vector, but avoid divide-by-zero error in output for subregions that have no vectors, and therefore their total_mean_X_vel is 0
         total_mean_X_velocity_all_frames_for_subregion(ix,iy) = total_mean_X_velocity_all_frames_for_subregion(ix,iy) + 0.0000001
         rtemp1 = sqrt( total_mean_X_velocity_all_frames_for_subregion(ix,iy)**2.0 + total_mean_Y_velocity_all_frames_for_subregion(ix,iy)**2.0 )
         rtemp2 = atan2 ( total_mean_Y_velocity_all_frames_for_subregion(ix,iy) , total_mean_X_velocity_all_frames_for_subregion(ix,iy) )
         
         ! Calc angle of RMS vector, but make X_rms slightly larger than zero to avoid divide-by-zero error in output for subregions that have no vectors, and therefore their X_RMS value is 0
         X_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) = X_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) + 0.00000001
         avg_angle_of_RMS_fluct_comp_of_region_for_ALL_frames(ix, iy) = atan2( Y_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) , X_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy) )
         
         turbulence_intensity =  sqrt( 0.5 * ( X_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy)**2.0 + Y_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy)**2.0 ) ) !&
                                !/ abs(total_mean_X_velocity_all_frames_for_subregion(ix,iy))

         ! Write total velocity and RMS of fluc comp for each region to: '..\by_subregion\Vel_total_mean_by_region_all_frames.txt" and "..\by_subregion\Vel_RMS_of_fluct_comp_by_region_all_frames.txt'

         write(230,236) ix, iy, total_mean_X_velocity_all_frames_for_subregion(ix,iy), total_mean_Y_velocity_all_frames_for_subregion(ix,iy), rtemp1, rtemp2 ; 
         236 format( i3,2x,i3, 4(5x,f12.7) ) 
         write(330,333) ix, iy, X_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy), Y_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(ix,iy), &
                                turbulence_intensity , avg_angle_of_RMS_fluct_comp_of_region_for_ALL_frames(ix, iy) 
         333 format( i3,3x,i3, 5x, 4( 3x,f13.7) ) 

      end do
   end do

end if
   
end if
