! calc_mean_velocities_of_frames_and_subregions.f90

! _________  NOW CALCULATE MEAN PARTICLE VELOCITY FOR EACH FRAME AND SUBREGION USING EXPANDING AVERAGING WINDOW TECHNIQUE  _________________
! Often there are not enough velocity vectors in each frame or subregion to get the true average, so, for each frame and subregion,
! if the frame/subregion itself does not have enough velocity vectors fo a good average
! I instead use an average of the velocity vectors in the frame plus a number of surrounding frames.
! I do the same for subregions.  I keep increasing the number of surrounding frames/subregions until I 
! have enough velocity vectors to get a good average.  For now, the number of velocity vectors is an exogenous parameter.
! The rolling averages can be used to calculate fluctuating components and other parameters for which a frame averaged value is needed.
! Note that the rolling_average_window must be chosen small enough so as to not remove highest frequencies of signal, but long enough to get
! enough values (of velocity vectors for example) to get a true frame average value.
do frame = 1, number_of_frames_to_analyze
   ! reset variables for this frame
   cumulative_X_speed_over_avg_window=0; cumulative_Y_speed_over_avg_window=0; no_velocity_vectors_in_averaging_window = 0
   ! First count the number of velocity vectors in this frame/window.  If not enough, expand size of averaging window until there are enough
   expanded_rolling_average_window = 1
   expanded_window_half_width = (expanded_rolling_average_window + 1)/2 -1
   ! Count the number of velocity vectors in this averaging window size
   first_frame_of_averaging_window = (frame - expanded_window_half_width); last_frame_of_averaging_window = (frame + expanded_window_half_width) 
   no_velocity_vectors_in_averaging_window = 0   
   do while (no_velocity_vectors_in_averaging_window .lt. enough_velocity_vectors_for_good_average) 
      if ( first_frame_of_averaging_window .lt. 0 ) first_frame_of_averaging_window = 1
      if ( last_frame_of_averaging_window  .ge. number_of_frames_to_analyze ) last_frame_of_averaging_window = number_of_frames_to_analyze
      no_velocity_vectors_in_averaging_window = 0 
      do temp_frame = first_frame_of_averaging_window , last_frame_of_averaging_window 
         no_velocity_vectors_in_averaging_window = no_velocity_vectors_in_averaging_window + no_velocity_vectors_this_frame(temp_frame)     
      end do
      !Balaji changes start here (the commented portion above has been moved below and modified using the if statement)
      if (no_velocity_vectors_in_averaging_window .lt. enough_velocity_vectors_for_good_average) then
        expanded_rolling_average_window = expanded_rolling_average_window + 2 
        expanded_window_half_width = (expanded_rolling_average_window + 1)/2 -1   
        first_frame_of_averaging_window = (frame - expanded_window_half_width); last_frame_of_averaging_window = (frame + expanded_window_half_width) 
      end if
      !expanded_rolling_average_window = expanded_rolling_average_window + 2 
      !expanded_window_half_width = (expanded_rolling_average_window + 1)/2 -1   
      !first_frame_of_averaging_window = (frame - expanded_window_half_width); last_frame_of_averaging_window = (frame + expanded_window_half_width) 
      !Balaji changes end here
   end do
   ! Now that the size and range of the expanded_averaging_window is determined, calculate the averages for this window of frames
   cumulative_X_speed_over_avg_window=0; cumulative_Y_speed_over_avg_window=0; 
   ! First calculate cumulative values for this averaging window of frames
   do temp_frame = first_frame_of_averaging_window , last_frame_of_averaging_window
      cc = first_centroid_in_frame(frame)
      if (cc .gt. 0) then
      do while ( cc .le. last_centroid_in_frame(frame) )    ! Range through centroids for this frame
         real_trajectory_no = real_trajectory_no_of_centroid(cc)
         tc = position_of_centroid_in_trajectory(cc)
                  if ( is_centroid_in_a_real_trajectory(cc) .gt. 0 ) then  ! only use centroids that are actually in a trajectory  
            ! Recall that x_speed_along_traj includes sign of direction (+/-).  How will the change average if particles are moving in opposite directions?
         !Balaji changes start here
          cumulative_X_speed_over_avg_window = cumulative_X_speed_over_avg_window + x_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc)
          cumulative_Y_speed_over_avg_window = cumulative_Y_speed_over_avg_window + y_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc)
         ! cumulative_X_speed_over_avg_window = cumulative_X_speed_over_avg_window + x_speed_along_traj(real_trajectory_no,tc)
         ! cumulative_Y_speed_over_avg_window = cumulative_Y_speed_over_avg_window + y_speed_along_traj(real_trajectory_no,tc)
         !Balaji changes end here
         end if
!write(2994,4994) frame, temp_frame, cc,  x_speed_along_traj(real_trajectory_no,tc), y_speed_along_traj(real_trajectory_no,tc), cumulative_X_speed_over_avg_window, cumulative_Y_speed_over_avg_window
!4994 format(i8,5x,i8,5x,i8,4(5x,f10.6))        
         cc = cc + 1
      end do  
      end if       
   end do 
   ! Now calculate mean values
   mean_X_velocity_at_frame(frame)= cumulative_X_speed_over_avg_window/no_velocity_vectors_in_averaging_window
   mean_Y_velocity_at_frame(frame)= cumulative_Y_speed_over_avg_window/no_velocity_vectors_in_averaging_window
   avg_angle_this_frame(frame) = atan(mean_Y_velocity_at_frame(frame)/mean_X_velocity_at_frame(frame))
   mean_velocity_this_frame(frame) = sqrt(mean_X_velocity_at_frame(frame)**2 + mean_Y_velocity_at_frame(frame)**2)
  ! Balaji changes start here (order corrected)
  ! write(4998,5112) frame, expanded_rolling_average_window, no_velocity_vectors_in_averaging_window, mean_velocity_X_component_over_avg_window(frame), mean_velocity_Y_component_over_avg_window(frame),&
  !                  mean_velocity_this_frame(frame),avg_angle_this_frame(frame)*360/(2.0*3.14159)
   write(4998,5112) frame, expanded_rolling_average_window, no_velocity_vectors_in_averaging_window, mean_X_velocity_at_frame(frame), mean_X_velocity_at_frame(frame),&
                    mean_velocity_this_frame(frame),avg_angle_this_frame(frame)*360/(2.0*3.14159)
  ! Balaji changes end here
   5112 format(i8,9x,i8,20x,i8,3x,4(8x,f10.5) )
   write(4999,3667) frame, expanded_rolling_average_window, no_velocity_vectors_in_averaging_window, cumulative_X_speed_over_avg_window, cumulative_Y_speed_over_avg_window
   3667 format(i7, 10x, i5, 35x, i5, 2(5x,f10.5))
end do
! Now calculate the total mean velocity and the rolling average for use in calculating fluctuating components
! First calculate the total mean velocity based on all frames
do frame = 1, number_of_frames_to_analyze
   total_mean_X_velocity_for_all_frames = total_mean_X_velocity_for_all_frames + mean_X_velocity_at_frame(frame) / number_of_frames_to_analyze
   total_mean_Y_velocity_for_all_frames = total_mean_Y_velocity_for_all_frames + mean_Y_velocity_at_frame(frame) / number_of_frames_to_analyze
end do 

! ****************************************************
! Now do the same for each subregion of each frame!
do ix = 1, m
   do iy = 1, n
      do frame = 1, number_of_frames_to_analyze
         ! reset variables for this frame
         cumulative_X_speed_over_avg_window=0; cumulative_Y_speed_over_avg_window=0; no_velocity_vectors_in_averaging_window = 0
         ! First count the number of velocity vectors in this frame/window.  If not enough, expand size of averaging window until there are enough
         expanded_rolling_average_window = 1
         expanded_window_half_width = (expanded_rolling_average_window + 1)/2 -1
         ! Count the number of velocity vectors in this averaging window size
         first_frame_of_averaging_window = (frame - expanded_window_half_width); last_frame_of_averaging_window = (frame + expanded_window_half_width) 
         no_velocity_vectors_in_averaging_window = 0   
         do while (no_velocity_vectors_in_averaging_window .lt. enough_velocity_vectors_for_good_average) 
            if ( first_frame_of_averaging_window .lt. 0 ) first_frame_of_averaging_window = 1
            if ( last_frame_of_averaging_window  .ge. number_of_frames_to_analyze ) last_frame_of_averaging_window = number_of_frames_to_analyze
            no_velocity_vectors_in_averaging_window = 0 
            do temp_frame = first_frame_of_averaging_window , last_frame_of_averaging_window 
               no_velocity_vectors_in_averaging_window = no_velocity_vectors_in_averaging_window + no_velocity_vectors_this_subregion_of_frame(temp_frame, subregion_x, subregion_y)  
            end do              
            if (no_velocity_vectors_in_averaging_window .lt. enough_velocity_vectors_for_good_average) then
               expanded_rolling_average_window = expanded_rolling_average_window + 2 
               expanded_window_half_width = (expanded_rolling_average_window + 1)/2 -1   
               first_frame_of_averaging_window = (frame - expanded_window_half_width); last_frame_of_averaging_window = (frame + expanded_window_half_width) 
            end if
         end do
         ! Now that the size and range of the expanded_averaging_window is determined, calculate the averages for this window of subregions of frames
         cumulative_X_speed_over_avg_window=0; cumulative_Y_speed_over_avg_window=0; 
         ! First calculate cumulative values for this averaging window of frames
         do temp_frame = first_frame_of_averaging_window , last_frame_of_averaging_window
            cc = first_centroid_in_frame(frame)
            if (cc .gt. 0) then
               do while ( cc .le. last_centroid_in_frame(frame) )    ! Range through centroids for this frame
                  if (subregion_x_cc(ix) .eq. ix .and. subregion_y_cc(iy) .eq. iy) then !only count if this centroid is in the subregion of this loop
                     real_trajectory_no = real_trajectory_no_of_centroid(cc)
                     tc = position_of_centroid_in_trajectory(cc)
                     if ( is_centroid_in_a_real_trajectory(cc) .gt. 0 ) then  ! only use centroids that are actually in a trajectory  
                        cumulative_X_speed_over_avg_window = cumulative_X_speed_over_avg_window + x_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc)
                        cumulative_Y_speed_over_avg_window = cumulative_Y_speed_over_avg_window + y_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc) 
                     end if
                    !write(2994,4994) frame, temp_frame, cc,  x_speed_along_traj(real_trajectory_no,tc), y_speed_along_traj(real_trajectory_no,tc), cumulative_X_speed_over_avg_window, cumulative_Y_speed_over_avg_window
                    !4994 format(i8,5x,i8,5x,i8,4(5x,f10.6))        
                  end if
                  cc = cc + 1
               end do  
            end if       
         end do 
         ! Now calculate mean values
         mean_X_velocity_at_subregion_of_frame(frame, ix, iy) = cumulative_X_speed_over_avg_window / no_velocity_vectors_in_averaging_window
         mean_Y_velocity_at_subregion_of_frame(frame, ix, iy) = cumulative_Y_speed_over_avg_window / no_velocity_vectors_in_averaging_window
         avg_angle_this_frame(frame) = atan(mean_Y_velocity_at_frame(frame)/mean_X_velocity_at_frame(frame))
         mean_velocity_this_subregion_of_frame(frame, subregion_x, subregion_y) = sqrt(mean_X_velocity_at_frame(frame)**2 + mean_Y_velocity_at_frame(frame)**2)
         ! write(4998,5112) frame, expanded_rolling_average_window, no_velocity_vectors_in_averaging_window, mean_velocity_X_component_over_avg_window(frame), mean_velocity_Y_component_over_avg_window(frame),&
         !                  mean_velocity_this_frame(frame),avg_angle_this_frame(frame)*360/(2.0*3.14159)
         write(5998,6112) frame, subregion_x, subregion_y, expanded_rolling_average_window, no_velocity_vectors_in_averaging_window, mean_X_velocity_at_frame(frame), &
                         mean_X_velocity_at_subregion_of_frame(frame, subregion_x, subregion_y), &
                         mean_Y_velocity_at_subregion_of_frame(frame, subregion_x, subregion_y)      
         6112 format(i8,2x,2(i3,2x),5x,i8,20x,i8,3x,4(8x,f10.5) )
         write(5999,4667) frame, subregion_x, subregion_y,expanded_rolling_average_window, no_velocity_vectors_in_averaging_window, cumulative_X_speed_over_avg_window, cumulative_Y_speed_over_avg_window
         4667 format(i7,2x,i3,2x,i3,10x, i5, 35x, i5, 2(5x,f10.5))
      end do
   end do 
end do
! Now calculate the total mean velocity and the rolling average for use in calculating fluctuating components
! First calculate the total mean velocity based on all frames
do ix = 1, m
   do iy = 1, n
      do frame = 1, number_of_frames_to_analyze
         total_mean_X_velocity_all_frames_for_subregion(ix,iy) = total_mean_X_velocity_all_frames_for_subregion(ix,iy) + mean_X_velocity_at_subregion_of_frame(frame, ix, iy) / number_of_frames_to_analyze
         total_mean_Y_velocity_all_frames_for_subregion(ix,iy) = total_mean_Y_velocity_all_frames_for_subregion(ix,iy) + mean_Y_velocity_at_subregion_of_frame(frame, ix, iy) / number_of_frames_to_analyze
      end do 
   end do
end do

