! calc_no_centroids_in_a_frame_by_avg_over_window.f90

! Now I -smooth the no_particles_in_frame() curve because it incremental with particle number and there may be, e.g., 1 to 10 particles in each region.
! This makes the plots against Relative Particle Conc or solids fraction look strange.
! Also, the minimum RPC or solids concentration occurs when only one particle is seen in a consecutive sequence of frames
! So to capture this min solids concentration I calculate an avg over a longer window frames

! avg_window_for_no_cent_per_frame is now exogenous input ! This must be odd
half_avg_window_for_no_cent_per_frame = ( avg_window_for_no_cent_per_frame - 1 )/ 2

cumulative = 0
do frame = 1, number_of_frames_to_analyze  

   if ( frame .le. (half_avg_window_for_no_cent_per_frame + 1) ) then
      do k = 1 , avg_window_for_no_cent_per_frame
         cumulative = cumulative + no_particles_in_frame(k)
      end do 
      no_particles_in_frame_by_avg_window(frame) = cumulative / avg_window_for_no_cent_per_frame
      cumulative = 0
   end if
   
   if ( frame .ge. number_of_frames_to_analyze - half_avg_window_for_no_cent_per_frame ) then
      do k = number_of_frames_to_analyze - avg_window_for_no_cent_per_frame, number_of_frames_to_analyze
         cumulative = cumulative + no_particles_in_frame(k)
      end do 
      no_particles_in_frame_by_avg_window(frame) = cumulative / avg_window_for_no_cent_per_frame
      cumulative = 0    
   end if
    
   if( frame .ge. (half_avg_window_for_no_cent_per_frame + 1) .and. frame .le. (number_of_frames_to_analyze - half_avg_window_for_no_cent_per_frame - 1) ) then
         do k = frame - half_avg_window_for_no_cent_per_frame , frame + half_avg_window_for_no_cent_per_frame
            cumulative = cumulative + no_particles_in_frame(k)
         end do 
         no_particles_in_frame_by_avg_window(frame) = cumulative / avg_window_for_no_cent_per_frame
         cumulative = 0         
   end if
   
end do 

