! The following lines are for using the particle count to calculate area_of_frame_covered_by_particle_images.  But I am returning to using the total area covered by particles
! as extracted from ImageJ's Particle Analyzer.  Using particle count causes the final data to be divided into about 50 bins along the x-axis because, for 4mm x 4mm FOV, the max number of particles is around 50. 
!rtemp1 =  particle_diameter; ! rtemp2 =  rtemp1 * rtemp1 / 4.0  ! in meters; rtemp3 =  3.1415 * rtemp2 ! CSA in meters; cross_sectional_area_of_a_particle = rtemp3 / (fov_scale**2) ! in pixels ;cross_sectional_area_of_a_particle = 3000
!write(8885,*) rtemp1, rtemp2, rtemp3, cross_sectional_area_of_a_particle

read(150,126) A_temp
cross_sectional_area_of_a_particle =  (3.1415 * particle_diameter**2.0 / 4.0)  / (fov_scale**2)! in pixels squared
!write(8885,*) rtemp1, rtemp2, rtemp3, cross_sectional_area_of_a_particle
do i = 1, number_of_frames_to_analyze
   read(150,*) frame, no_particles_in_frame, rtemp1, rtemp2, rtemp3
   ! Now calculate the area covered by particles (in pixels) using the number of particles detected in each frame by ImageJ's Particle Analyzer
   area_of_frame_covered_by_particle_images(i) = cross_sectional_area_of_a_particle * no_particles_in_frame  ! in pixels
 !  write(8885,5888) frame, no_particles_in_frame, cross_sectional_area_of_a_particle, area_of_frame_covered_by_particle_images(i), total_pixel_area_of_a_camera_frame, area_of_frame_covered_by_particle_images(i)/total_pixel_area_of_a_camera_frame*100*0.6
 !  5888 format(i8,3x,i3,3x,4(4x,f12.5))  
end do

! Now find max_area_of_frame_covered_by_particle_images from the area data just read
max_area_of_frame_covered_by_particle_images=0
do i=1, number_of_frames_to_analyze
   if(area_of_frame_covered_by_particle_images(i) .gt. max_area_of_frame_covered_by_particle_images) then 
       max_area_of_frame_covered_by_particle_images = area_of_frame_covered_by_particle_images(i)
   end if;
end do

! Now I need to correct for the fact that some particles that were detected that were not in the plane along the wall, thus, the total number of particles
! is greater than the max possible for a frame.  So I adjust by scaling with max so that the solids fraction goes from 0.0 to 0.6

! Calculate Particle_Relative_Concentration and write it to output file for checking input data
do i=1, number_of_frames_to_analyze
   area_fraction_at_maximum_packing = 0.6 !!!!! NEED TO CHANGE THIS FOR PARTICLES OTHER THEN HDPE 1MM
   scaling_factor_for_area_covered_by_particles =  total_pixel_area_of_a_camera_frame / max_area_of_frame_covered_by_particle_images
   solids_area_fraction(i) =  (area_of_frame_covered_by_particle_images(i) / total_pixel_area_of_a_camera_frame) * area_fraction_at_maximum_packing * scaling_factor_for_area_covered_by_particles
   Relative_Particle_Concentration(i) = area_of_frame_covered_by_particle_images(i)/max_area_of_frame_covered_by_particle_images
   !write(1009,1016) i, area_of_frame_covered_by_particle_images(i), Relative_Particle_Concentration(i); 1016 format(i5,4x,f8.0,3x,f10.5); 
end do
!print*,' '; print*,'max_area_of_frame_covered_by_particle_images = ',max_area_of_frame_covered_by_particle_images
print*,' '; print*,'Begin reading the centroid file;'

! Now I smooth the solids_area_fraction curve because it incremental with particle number.  Makes the plots against solids fraction look strange.
! so calculate a rolling avg over 5 frames
do i=3, number_of_frames_to_analyze-2
   if( i .eq. 1 .or. i .eq. 2 .or. i .eq. 3) then
      rtemp1 = solids_area_fraction(1); rtemp2 = solids_area_fraction(1); rtemp3 = solids_area_fraction(i+1); rtemp2= solids_area_fraction(i+2)
   else
      rtemp1 = solids_area_fraction(i-2); rtemp2= solids_area_fraction(i-1); rtemp3 = solids_area_fraction(i+1); rtemp2= solids_area_fraction(i+2)
   end if
   if( i .eq. number_of_frames_to_analyze .or. i .eq. number_of_frames_to_analyze-1 .or. i .eq. number_of_frames_to_analyze-2) then
      rtemp1 = solids_area_fraction(i-2); rtemp2= solids_area_fraction(i-1); rtemp3 = solids_area_fraction(number_of_frames_to_analyze); rtemp4 = solids_area_fraction(number_of_frames_to_analyze);
   else
      rtemp1 = solids_area_fraction(i-2); rtemp2= solids_area_fraction(i-1); rtemp3 = solids_area_fraction(i+1); rtemp2= solids_area_fraction(i+2)
   end if
   solids_area_fraction(i) = (rtemp1 + rtemp2 + solids_area_fraction(i) + rtemp3 + rtemp4) / 5
end do

! 
! Now write the relative concentration data along with the number of particles in each frame
1066 format('This assumes that solids_fraction is equal to the ratio of',/,&
             'the area of a frame covered by particle images to the total area of the camera frame.',/, &
             'The definition of Relative_Particle_Concentration is simply the ratio of the area of a frame covered by particle images',/,&
             'to the maximum area that could be covered by particles of a certain size.',/)
write(1009,1013); 1013 format('Frame        Relative_Particle_Concentration     solids_area_fraction')
write(1009,1014); 1014 format('                          (%)                                        ')

do i=1, number_of_frames_to_analyze
   write(1009,1016) i, Relative_Particle_Concentration(i)*100, solids_area_fraction(i);
end do
1016 format(i6,15x,f10.4,28x,f10.5); 