! calc_subregion_avg_requiring_min_no_vectors.f90

! _________  CALCULATE MEAN PARTICLE VELOCITY FOR EACH SUBREGION OF EACH FRAME USING EXPANDING AVERAGING WINDOW TECHNIQUE  _________________
! Now go through the frames and calculate an average velocity for each subregion of each frame
! This is exactly the same code used to calculate frame averages, but the average is for a subregion instead of a frame

! For particle flow, we use a shorter frame averaging window so we can try to separate out the high frequency "random" particle motion due to particle-particle collisions
! This random motion is used in Kinetic Theory models, and is used to calculate what KE modelers call "Granular Temperature"
! But for hsPIV measurements of single phase flow, the averaging window is usually all frames
! So I calculate the averaging window separately for particle flow and for single phase flow.  For single phase flow with many subregions, this greatly speeds up the calculation!

! This calculates the expanded_average_window_for_mean_vel_by_subregion(), increasing the window size until it has enough velocity vectors for a "good" average.  The min no of vectors is an exogenous input
if( this_is_a_single_phase_fluid_measurement .lt. 0.1) then  ! If this is not a single phase flow, do this first section, if not, jump to the "else" section
   print*,' '
   print*, 'This is a particle flow analysis, '
   print*, 'so running calc_subregion_avg_requiring_min_no_vectors.f90 for particle flow!!'   
   print*,' '
   
   do ix = 1, m
      do iy = 1, n
         do frame = 1, number_of_frames_to_analyze
            !write(*,3344) ix, iy, frame; 3344 format('   > Calcating window size for frame_avg_vel for subregion ',i4,',',i4,' of frame',i8)
         
            ! Now calculate window size for frame averaging such that the window has enough velocity vectors
            ! reset variables for this subregion of this frame
            cumulative_X_speed_over_avg_window=0; cumulative_Y_speed_over_avg_window=0; no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy) = 0
            ! Setup averaging window
            expanded_average_window_for_mean_vel_by_subregion(frame,ix,iy) = 1  ! Test single frame as averaging window first
            expanded_window_half_width = (expanded_average_window_for_mean_vel_by_subregion(frame,ix,iy) + 1)/2 -1
            ! Count the number of velocity vectors in this averaging window
            first_frame_of_averaging_window = (frame - expanded_window_half_width); last_frame_of_averaging_window = (frame + expanded_window_half_width) 
            no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy) = 0  
            do while (no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy) .lt. enough_velocity_vectors_for_good_average) 
               if ( first_frame_of_averaging_window .le. 0 ) first_frame_of_averaging_window = 1
               if ( last_frame_of_averaging_window  .ge. number_of_frames_to_analyze ) last_frame_of_averaging_window = number_of_frames_to_analyze
               no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy) = 0 
               do window_frame = first_frame_of_averaging_window , last_frame_of_averaging_window 
                  no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy) = no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy) + &
                                                                                      no_velocity_vectors_this_subregion_of_frame(window_frame, ix, iy)  
               end do              
               
          !     if( expanded_average_window_for_mean_vel_by_subregion(frame,ix,iy) .ge. maximum_allowable_size_of_averaging_window) then
                  !print*, 'expanded_average_window_for_mean_vel_by_subregion(frame,ix,iy) > maximum_allowable_size_of_averaging_window'
          !        go to 1888
          !     end if
               
               if (no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy) .lt. enough_velocity_vectors_for_good_average) then
                  expanded_average_window_for_mean_vel_by_subregion(frame,ix,iy) = expanded_average_window_for_mean_vel_by_subregion(frame,ix,iy) + 2 
                  expanded_window_half_width = (expanded_average_window_for_mean_vel_by_subregion(frame,ix,iy) + 1)/2 -1   
                  first_frame_of_averaging_window = (frame - expanded_window_half_width); last_frame_of_averaging_window = (frame + expanded_window_half_width) 
                  ! If there are not enough vectors in nearby frames to get a good average for this subregion, just don't calculate anything later for this frame
               end if

            end do
            
            1888 continue
            
            ! The following is disabled, for now
            if(no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy) .lt. enough_velocity_vectors_for_good_average ) then
               does_subregion_have_enough_vectors_nearby_for_good_avg(frame,ix,iy) = 0
            else
               does_subregion_have_enough_vectors_nearby_for_good_avg(frame,ix,iy) = 1
            end if
            
               if(last_frame_of_averaging_window-first_frame_of_averaging_window  .gt. maximum_allowable_size_of_averaging_window) then
               first_frame_of_averaging_window =0;
               last_frame_of_averaging_window = 0;
               no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy) = 0;
               end if
            
              !write(*,3347)  ;  3347 format('Now calc frame avg vel for each subregion')
            ! Now that the size and range of the expanded_averaging_window is determined for this subregion, calculate the averages for expanded window of frames around this subregion
            cumulative_X_speed_over_avg_window = 0 ; cumulative_Y_speed_over_avg_window = 0 ; 
            ! First calculate cumulative values for this averaging window of frames
            ! This writes to  file='..\Standalone_Post_Processing\output\debugging\debug_calc_avg_velocity_regions.txt'
         
            if(debug .gt. 0.1) write(2994,4993) frame, ix, iy, first_frame_of_averaging_window , last_frame_of_averaging_window, no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy)     ! writes to "debug_calc_avg_velocity_regions.txt"    
            4993 format(/,'frame=',i8,'    region: (',i2,',',i2,')',':  first_frame_of_avg_window=',i8,' last_frame_of_avg_window=',i8,'no_vel_vectors_in_window=',i7 )
        
            do window_frame = first_frame_of_averaging_window , last_frame_of_averaging_window
               cc = first_centroid_in_frame(window_frame)
               do while ( cc .le. last_centroid_in_frame(window_frame) )    ! Range through centroids for this frame

                  if (subregion_x_cc(cc) .eq. ix .and. subregion_y_cc(cc) .eq. iy) then !only count if this centroid is in the subregion of this loop
                     if ( is_centroid_in_a_real_trajectory(cc) .gt. 0 ) then  ! only use centroids that are actually in a trajectory  
                        real_trajectory_no = real_trajectory_no_of_centroid(cc)
                        tc = position_of_centroid_in_trajectory(cc)
                        cumulative_X_speed_over_avg_window = cumulative_X_speed_over_avg_window + x_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc)
                        cumulative_Y_speed_over_avg_window = cumulative_Y_speed_over_avg_window + y_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc) 
                     end if
                  if(debug .gt. 0.1) write(2994,4994) window_frame, cc, x_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc), &
                                                y_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc), &
                                                cumulative_X_speed_over_avg_window, cumulative_Y_speed_over_avg_window
                     4994 format('window_frame=',i4,': cc=',i8,': x_speed=',f9.5,': y_speed=',f9.5,':  cum_x_speed=',f9.5,':  cum_y_speed=',f9.5)  ! writes to "debug_calc_avg_velocity_regions.txt"    
                  end if
                  cc = cc + 1
               end do  
            end do 
            ! Now calculate mean values
            frame_avg_X_velocity_at_subregion(frame, ix, iy) = cumulative_X_speed_over_avg_window / no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy) ! Note that no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy) was calculated above for this particular subregion
            frame_avg_Y_velocity_at_subregion(frame, ix, iy) = cumulative_Y_speed_over_avg_window / no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy)
            avg_angle_at_subregion_of_frame(frame, ix, iy) = atan2( frame_avg_Y_velocity_at_subregion(frame, ix, iy) , frame_avg_X_velocity_at_subregion(frame, ix, iy) )
            mean_velocity_this_subregion_of_frame(frame, ix, iy) = sqrt(frame_avg_X_velocity_at_subregion(frame, ix, iy)**2 + frame_avg_Y_velocity_at_subregion(frame, ix, iy)**2)

            if(debug .gt. 0.1) write(2994,2995)   no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy), local_avg_of_X_velocity(frame), local_avg_of_Y_velocity(frame), &
                          cumulative_X_speed_over_avg_window, no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy), frame_avg_X_velocity_at_subregion(frame, ix, iy), &
                          cumulative_Y_speed_over_avg_window, no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy), frame_avg_Y_velocity_at_subregion(frame, ix, iy)      
            2995 format('no_vectors_in_avg_window=',i3,':      mean_x_speed_frame=',f9.5,': mean_y =',f9.5,/,&
                      'cumulative_X_speed_over_avg_window=',f9.5,' div by ',i2,' = mean_x_speed_region=',f9.5,/,&
                      'cumulative_Y_speed_over_avg_window=',f9.5,' div by ',i2,' = mean_Y_speed_region=',f9.5)
         
            write(5998,6112) frame, ix, iy, expanded_average_window_for_mean_vel_by_subregion(frame,ix,iy), no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy), &
                         local_avg_of_X_velocity(frame), local_avg_of_Y_velocity(frame), &
                         frame_avg_X_velocity_at_subregion(frame, ix, iy), &
                         frame_avg_Y_velocity_at_subregion(frame, ix, iy)      
            6112 format(i8,2x,2(i3,6x),5x,i8,20x,i8,8x,4(12x,f10.5) )
            if(debug .gt. 0.1) write(5999,4667) frame, ix, iy, expanded_average_window_for_mean_vel_by_subregion(frame,ix,iy), no_velocity_vectors_this_subregion_of_frame(window_frame, ix, iy), cumulative_X_speed_over_avg_window, cumulative_Y_speed_over_avg_window
            4667 format(i7,2x,i3,2x,i3,10x, i5, 35x, i5, 2(5x,f10.5))
         

            
         end do
         
         write(*,3345) ix, iy, frame, expanded_average_window_for_mean_vel_by_subregion(frame,ix,iy);
         3345 format('For ix=',i4,' and iy',i4,'  Found window size to be ',i8)
      
      end do 
   end do  
      ! Now calculate the total mean velocity for use in calculating fluctuating components
   ! Note that for single phase flow, the total_mean_X_velocity_all_frames_for_subregion(ix,iy) is the same as frame_avg_X_velocity_at_subregion(frame, ix, iy)
   ! But in this section for particle flow, the total_mean velocity for each subregion must be calculated by adding the mean vel for a subregion for all frames, then dividing by the total number of frames
   do ix = 1, m
      do iy = 1, n
         do frame = 1, number_of_frames_to_analyze
            total_mean_X_velocity_all_frames_for_subregion(ix,iy) = total_mean_X_velocity_all_frames_for_subregion(ix,iy) + frame_avg_X_velocity_at_subregion(frame, ix, iy) / number_of_frames_to_analyze
            total_mean_Y_velocity_all_frames_for_subregion(ix,iy) = total_mean_Y_velocity_all_frames_for_subregion(ix,iy) + frame_avg_Y_velocity_at_subregion(frame, ix, iy) / number_of_frames_to_analyze
         end do 
      end do
   end do
   
else ! If this is a single phase flow, then the averaging window is simply all frames
   print*, 'This is a single-phase flow analysis, so running calc_subregion_avg_requiring_min_no_vectors.f90 for single-phase flow!!'   
   do ix = 1, m
      do iy = 1, n
         do frame = 1, number_of_frames_to_analyze  
            expanded_average_window_for_mean_vel_by_subregion(frame,ix,iy) = number_of_frames_to_analyze
         end do
      end do
   end do
   ! this is a single phase flow, so the frame avg for each subregion is the same for all frames!  So only do the calculation for one frame!
   ! SINGLE PHASE FLOW CALC OF TOTAL AVG VEL IN EACH SUBREGION
   ! This section uses a frame averaging window of all frames, so the total mean velocity in each subregion across all frames is calcuted.  This is the mean that's used to calc fluct components for single phase flow
   ! First calc total number of velocity vectors for each subregion across all frames (so it can be used to calc total avg vel for each subregion across all frames)
   do ix = 1, m
      do iy = 1, n
         total_vel_vectors_this_subregion_for_all_frames(ix,iy) = 0
         do frame = 1, number_of_frames_to_analyze
            !Balaji Change 05/25 Start
            total_vel_vectors_this_subregion_for_all_frames(ix,iy) =   total_vel_vectors_this_subregion_for_all_frames(ix,iy) + no_velocity_vectors_this_subregion_of_frame(frame,ix,iy) 
            !Balaji Change 05/25 End
         end do
      end do
   end do

   ! Calc total avg vel for each subregion across all frames.  Since it is the same for all frames, do the calc only for 1 frame
   do ix = 1, m
      do iy = 1, n
         frame = 1
         !do frame = 1, number_of_frames_to_analyze
          !write(*,3348) ix,iy ;  3348 format('Now calc frame avg vel for subregion ,'i4,',',i4,' for one frame because this is a single phase flow!')
         cumulative_X_speed_over_avg_window = 0 ; cumulative_Y_speed_over_avg_window = 0 ; 
        
         do window_frame = 1 , number_of_frames_to_analyze
            cc = first_centroid_in_frame(window_frame)
            do while ( cc .le. last_centroid_in_frame(window_frame) )    ! Range through centroids for this frame
               if (subregion_x_cc(cc) .eq. ix .and. subregion_y_cc(cc) .eq. iy) then !only count if this centroid is in the subregion of this loop
                  if ( is_centroid_in_a_real_trajectory(cc) .gt. 0 ) then  ! only use centroids that are actually in a trajectory  
                     real_trajectory_no = real_trajectory_no_of_centroid(cc)
                     tc = position_of_centroid_in_trajectory(cc)
                     cumulative_X_speed_over_avg_window = cumulative_X_speed_over_avg_window + x_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc)
                     cumulative_Y_speed_over_avg_window = cumulative_Y_speed_over_avg_window + y_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc) 
                  
                     ! Here write out curve fitted velocity components for subregion 16,11.  Y should be positive and X negative for 
                     !if(debug. gt. 0) then 
                     !   if (ix .gt. 15.5 .and. ix .lt. 16.5) then
                     !      if (iy .gt. 10.5 .and. ix .ly. 11.5) then
                     !         write(7111,8111) ix, iy, x_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc), y_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc)
                     !      end if
                     !   end if
                     !end if
                     
                     
                  end if
               end if
               cc = cc + 1
            end do  
         end do 
         ! Now calculate mean values
         
         if ( total_vel_vectors_this_subregion_for_all_frames(ix,iy) .gt. 0 ) then
            frame_avg_X_velocity_at_subregion(frame, ix, iy) = cumulative_X_speed_over_avg_window / total_vel_vectors_this_subregion_for_all_frames(ix,iy) ! Note that no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy) was calculated above for this particular subregion
            frame_avg_Y_velocity_at_subregion(frame, ix, iy) = cumulative_Y_speed_over_avg_window / total_vel_vectors_this_subregion_for_all_frames(ix,iy)
            ! For single phase flow
            total_mean_X_velocity_all_frames_for_subregion(ix,iy) = frame_avg_X_velocity_at_subregion(frame, ix, iy) 
            total_mean_Y_velocity_all_frames_for_subregion(ix,iy) = frame_avg_Y_velocity_at_subregion(frame, ix, iy) 
         
            avg_angle_at_subregion_of_frame(frame, ix, iy) = atan2( frame_avg_Y_velocity_at_subregion(frame, ix, iy) , frame_avg_Y_velocity_at_subregion(frame, ix, iy) )
            mean_velocity_this_subregion_of_frame(frame, ix, iy) = sqrt(frame_avg_X_velocity_at_subregion(frame, ix, iy)**2 + frame_avg_Y_velocity_at_subregion(frame, ix, iy)**2)
        else  ! If there are no velocity vectors in this region, just set values to zero for this frame -- I will have to learn how to ignore zero values in plots!
            frame_avg_X_velocity_at_subregion(frame, ix, iy) = 0
            frame_avg_Y_velocity_at_subregion(frame, ix, iy) = 0
            ! For single phase flow
            total_mean_X_velocity_all_frames_for_subregion(ix,iy) = frame_avg_X_velocity_at_subregion(frame, ix, iy) 
            total_mean_Y_velocity_all_frames_for_subregion(ix,iy) = frame_avg_Y_velocity_at_subregion(frame, ix, iy) 
         
            avg_angle_at_subregion_of_frame(frame, ix, iy) = 0
            mean_velocity_this_subregion_of_frame(frame, ix, iy) = 0

            if(debug .gt. 0.1) write(2994,2996)   no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy), local_avg_of_X_velocity(frame), local_avg_of_Y_velocity(frame), &
                          cumulative_X_speed_over_avg_window, no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy), frame_avg_X_velocity_at_subregion(frame, ix, iy), &
                          cumulative_Y_speed_over_avg_window, no_vel_vectors_in_mean_avg_window_around_this_subregion(frame,ix,iy), frame_avg_Y_velocity_at_subregion(frame, ix, iy)      
            2996 format('no_vectors_in_avg_window=',i3,':      mean_x_speed_frame=',f9.5,': mean_y =',f9.5,/,&
                      'cumulative_X_speed_over_avg_window=',f9.5,' div by ',i2,' = mean_x_speed_region=',f9.5,/,&
                      'cumulative_Y_speed_over_avg_window=',f9.5,' div by ',i2,' = mean_Y_speed_region=',f9.5)  
         end if      
      end do 
   end do

   ! I just calculated the total average velocity for each subregion using frame 1.
   ! Now set the same value of total avg vel for each subregion the same for all subregions across all frames 
   ! I need to change this later to use different variables for single phase flows
   do ix = 1, m
      do iy = 1, n
         do frame = 1, number_of_frames_to_analyze
            frame_avg_X_velocity_at_subregion(frame, ix, iy) = frame_avg_X_velocity_at_subregion(1, ix, iy) 
            frame_avg_Y_velocity_at_subregion(frame, ix, iy) = frame_avg_Y_velocity_at_subregion(1, ix, iy) 
            avg_angle_at_subregion_of_frame(frame, ix, iy) = avg_angle_at_subregion_of_frame(1, ix, iy) 
            mean_velocity_this_subregion_of_frame(frame, ix, iy) =  mean_velocity_this_subregion_of_frame(1, ix, iy) 
         end do
      end do 
   end do
 
 ! Now write the avg vel data for entire frame and subregions for all frames
   do ix = 1, m
      do iy = 1, n
         frame = 1  ! Only write one frame, because for single-phase flows, the subregion values for all frames are the same
            write(5998,6123) ix, iy, total_vel_vectors_this_subregion_for_all_frames(ix,iy), &
                         frame_avg_X_velocity_at_subregion(frame, ix, iy), frame_avg_Y_velocity_at_subregion(frame, ix, iy)      
            6123 format(2(i3,3x),5x,f7.0,2(10x,f12.8) )
            if(debug .gt. 0.1) write(5999,4668) frame, ix, iy, expanded_average_window_for_mean_vel_by_subregion(frame,ix,iy), total_vel_vectors_this_subregion_for_all_frames(ix,iy), &
                                                cumulative_X_speed_over_avg_window, cumulative_Y_speed_over_avg_window
            4668 format(i7,2x,i3,2x,i3,10x, i5, 35x, i5, 2(5x,f10.5) )
      end do 
   end do
end if ! End if if section for single phase flow or not

! Now that we know the appropriate averaging window size for all subregions of all frames, 
! calculate frame average velocity for each subregion of each frame
write(*,3346) ;  3346 format('Now calc frame avg vel for each subregion')




