! count_no_centroids_and_vectors_in_each_frame_and_subregion.f90
  
! set no_velocity_vectors in frames and subregions to zero
! m is the number of subregions in the x-direction (no of columns) and n is the number of subregions in the y-direction (no of rows)
do frame = 1, number_of_frames_to_analyze; 
no_velocity_vectors_this_frame(frame)=0; 
   do ix = 1 , m; 
      do iy = 1 , n; 
         no_velocity_vectors_this_subregion_of_frame(frame, ix, iy) = 0; 
         no_centroids_this_subregion_of_frame(frame,ix,iy) = 0
end do; end do; end do

!!!!!!!!!!!!! Calc number of velocity vectors in each frame and in each subregion of each frame !!!!!!!!!!!!!!!!!!!!!!!!
do frame = 1, number_of_frames_to_analyze
   ! Go through each centroid of this frame and count it if it is in a real trajectory
   cc = first_centroid_in_frame(frame)  
   do while ( cc .le. last_centroid_in_frame(frame) )    ! Range through centroids for this frame
      if ( is_centroid_in_a_real_trajectory(cc) .gt. 0.1 ) then !only calculate if this centroid is in a real trajectory
         real_trajectory_no = real_trajectory_no_of_centroid(cc); tc = position_of_centroid_in_trajectory(cc)
         !if(debug .gt. 0.1) write(2177,2178) real_trajectory_no, tc; 2178 format(':  traj=',i7,':  tc=',i5,\)
         if ( tc .ne. real_trajectory_total_length(real_trajectory_no) ) then ! do not count last centroid in a traj because velocity vectors are over a pair of centroids
            no_velocity_vectors_this_frame(frame) = no_velocity_vectors_this_frame(frame) + 1
            ! Now find subregion this vector is in, and add it to no of vectors in that subregion
            do ix = 1, m
               if( x(cc) .gt. X_boundary_subregion_min(ix) .and. x(cc) .le. X_boundary_subregion_max(ix) ) subregion_X = ix;
            end do
            do iy = 1, n
               if( y(cc) .gt. Y_boundary_subregion_min(iy) .and. y(cc) .le. Y_boundary_subregion_max(iy) ) subregion_Y = iy;
            end do

            if(debug .gt. 0.1) write(926,927) cc,  subregion_x, subregion_y, X_boundary_subregion_min(subregion_X), x(cc), X_boundary_subregion_max(subregion_X), Y_boundary_subregion_min(subregion_Y), y(cc), Y_boundary_subregion_max(subregion_Y)
            927 format(' cc=',i8,'subregion_x=',i4,'  subregion_y=',i4    ,/, 20x, ': x_min=' ,f7.1, ' x(cc)=' ,f7.1, ' x_max=' ,f7.1 ,/, 20x, ': y_min=' ,f7.1, ' y(cc)=' ,f7.1, ' y_max=' ,f7.1 )
  
            no_velocity_vectors_this_subregion_of_frame(frame,subregion_x,subregion_y) = &
            no_velocity_vectors_this_subregion_of_frame(frame,subregion_x,subregion_y) + 1
                       
         end if
      else
         if(debug .gt. 0.1) write(2177,2190) ; 2190 format(/) 
      end if       
      cc = cc + 1
   end do
end do 

!!!!!!!!!!!!!!!!!! Calc number of centroids in each subregion of each frame !!!!!!!!!!!!!!!!!!!!!!!!!!!!
do frame = 1, number_of_frames_to_analyze
   ! Go through each centroid of this frame and count it if it is in a real trajectory
   cc = first_centroid_in_frame(frame)  
   do while ( cc .le. last_centroid_in_frame(frame) )    ! Range through centroids for this frame
      ! Now find subregion this centroid is in, and add it to no of centroids in that subregion
            do ix = 1, m
               if( x(cc) .gt. X_boundary_subregion_min(ix) .and. x(cc) .le. X_boundary_subregion_max(ix) ) subregion_X = ix;
            end do
            do iy = 1, n
               if( y(cc) .gt. Y_boundary_subregion_min(iy) .and. y(cc) .le. Y_boundary_subregion_max(iy) ) subregion_Y = iy;
            end do
      subregion_x_cc(cc) = subregion_x; subregion_y_cc(cc) = subregion_y
      no_centroids_this_subregion_of_frame(frame,subregion_x,subregion_y) = no_centroids_this_subregion_of_frame(frame,subregion_x,subregion_y) + 1

      if(debug .gt. 0.1) write(9216,9217) cc,  subregion_x, subregion_y, X_boundary_subregion_min(subregion_X), x(cc), X_boundary_subregion_max(subregion_X), Y_boundary_subregion_min(subregion_Y), y(cc), Y_boundary_subregion_max(subregion_Y)
            9217 format(' cc=',i8,'subregion_x=',i4,'  subregion_y=',i4,/, 20x, ': x_min=' ,f7.1, ' x(cc)=' ,f7.1, ' x_max=' ,f7.1 ,/, 20x, ': y_min=' ,f7.1, ' y(cc)=' ,f7.1, ' y_max=' ,f7.1 )
      if(debug .gt. 0.1) write(925,926) m,n, frame, ix, iy, cc, subregion_x_cc(cc), subregion_y_cc(cc), no_centroids_this_subregion_of_frame(frame, subregion_x, subregion_y)
            926 format('m=',i3,' n=',i3,' frame=',i7,' ix=',i2,' iy=',i2,': cc=',i8,': subregion_x=',i2,' subregion_y=',i2,': no_centroids_this_subregion(',i2,',',i2,')=',i8)      
      
      cc = cc + 1
   end do      
end do 

! Use the exogenous input parameter 'max_no_particles_in_any_frame' to limit the number of centroids that can be in a subregion
! We could also get a rough estimate of "imposed_limit_on_number_of_particles_in_a_subregion" based on side-by-side packing using the equation in the next line
! imposed_limit_on_number_of_particles_in_a_subregion = ( x_pixels/m * y_pixels/n ) / cross_sectional_area_of_a_particle
! But for now we will instead use the exogenous input value
imposed_limit_on_number_of_particles_in_a_subregion = max_no_particles_in_any_frame / (m * n)
write(*,76) imposed_limit_on_number_of_particles_in_a_subregion; 76 format(' imposed_limit_on_number_of_particles_in_a_subregion = ', f8.1)

do frame = 1, number_of_frames_to_analyze
   ! Note that no_particles_in_frame() is read from an input file and no_particles_in_frame_by_avg_window() is calculated in 'calc_no_centroids_in_a_frame_by_avg_over_window.f90'
   ! no_centroids_in_frame(frame) is calculated in subroutine 'find_number_of_centroids_in_each_frame'
   ! no_particles_in_frame(frame) should be the same as no_centroids_in_frame(frame)

   ! Unit 8010 writes to file='..\Standalone_Post_Processing\output\by_subregion\no_vectors_and_centroids_in_frames_and_subregions.txt'
   ! write(8010,8110) frame, no_velocity_vectors_this_frame(frame), no_centroids_in_frame(frame);
   !8110 format(/,'frame=',i8,': no_vectors_in_frame=',i5,':   no_centroids_in_frame=',i5,/,&
   !              '    frame   ix    iy   vectors      centroids')
   
   ! Now set limit on max number of particles that can fit in a subregion
   ! The particle recognition process is not perfect and often produces more than one centroid per particle.
   ! So it is necessary to exogenously limit the number of centroids to a reasonable maximum
   ! For 750 micron HDPE, I use a value of 10.  For 70 micron FCC, I do not use a limit (or set the limit very high).
   do ix = 1, m
      do iy = 1, n
         if (no_centroids_this_subregion_of_frame(frame,ix,iy) .gt. imposed_limit_on_number_of_particles_in_a_subregion) then
             no_centroids_this_subregion_of_frame(frame,ix,iy) = aint(imposed_limit_on_number_of_particles_in_a_subregion)+1
         end if
         ! this writes to  file='..\Standalone_Post_Processing\output\by_subregion\no_vectors_and_centroids_in_frames_and_subregions.txt')
         write(8010,8111) frame, ix, iy, no_velocity_vectors_this_subregion_of_frame(frame, ix, iy), no_centroids_this_subregion_of_frame(frame,ix,iy)
         8111 format(i8,2x,i4,2x,i4,13x,i5,18x,i5)
     end do
   end do
   
  ! Unit 7010 writes to file='..\Standalone_Post_Processing\output\by_frame\no_vectors_and_centroids_in_each_frame.txt'
   write(7010,7110) frame, no_velocity_vectors_this_frame(frame), no_centroids_in_frame(frame),  no_particles_in_frame(frame), no_particles_in_frame_by_avg_window(frame);
   7110 format(i6,4(15x,i8))
   
end do

! Calc and write total number of vectors and centroids in a region across all frames
do ix = 1, m
   do iy = 1, n
      do frame = 1, number_of_frames_to_analyze
         if (no_centroids_this_subregion_of_frame(frame,ix,iy) .gt. imposed_limit_on_number_of_particles_in_a_subregion) then
             no_centroids_this_subregion_of_frame(frame,ix,iy) = int(imposed_limit_on_number_of_particles_in_a_subregion)
            itemp1 = itemp1 + no_velocity_vectors_this_subregion_of_frame(frame, ix, iy) 
            itemp2 = itemp2 + no_centroids_this_subregion_of_frame(frame,ix,iy)         
         end if
      end do
      ! this writes to file='..\Standalone_Post_Processing\output\by_subregion\no_vectors_and_centroids_total_in_subregions.txt')
      write(8020,8121) frame, ix, iy,  itemp1, itemp2
      8121 format(i8,10x,i4,10x,i4,10x,i5,10x,i5)
      itemp1 = 0 ; itemp2 = 0
   end do
end do

! Count the number of frames with NO velocity vectors in each frame and subregion
no_frames_with_zero_velocity_vectors = 0 ; 
do frame = 1, number_of_frames_to_analyze; 
   if( no_velocity_vectors_this_frame(frame) .lt. 0.9 ) no_frames_with_zero_velocity_vectors = no_frames_with_zero_velocity_vectors + 1
end do
! unit 1300 writes to file='..\Standalone_Post_Processing\output\Number_frames_and_subregions_without_velocity_vectors.txt'
write(*,1310)    number_of_frames_to_analyze, no_frames_with_zero_velocity_vectors
write(1300,1310) number_of_frames_to_analyze, no_frames_with_zero_velocity_vectors
1310 format(/,'Of the ',i7,' frames to be analyzed ',i7,' frames have no (zero) velocity vectors' )
write(*,1311); write(1310,1311); 1311 format('The number of subregions with no velocity vectors is:')
do iy = 1 , n; 
   do ix = 1 , m; 
      no_subregions_with_zero_velocity_vectors_this_subregion = 0
      do frame = 1, number_of_frames_to_analyze; 
         if( no_velocity_vectors_this_subregion_of_frame(frame, ix, iy) .lt. 0.9 ) then
            no_subregions_with_zero_velocity_vectors_this_subregion = no_subregions_with_zero_velocity_vectors_this_subregion + 1
         end if
      end do;
      !write(*, 1312)    ix, iy, no_subregions_with_zero_velocity_vectors_this_subregion
      write(1300, 1312) ix, iy, no_subregions_with_zero_velocity_vectors_this_subregion
      1312 format('  Subregion ix=',i3,' iy=',i3,' has ',i7,' with no velocity vectors')
   end do; 
 end do

! Now write the no_centroids in each region as a grid so it's easy to compare with real images
!if (debug .gt. 0.1) then
!   do frame = 1, number_of_frames_to_analyze 
!      write(9010,9110) frame, no_centroids_in_frame(frame);
!      9110 format(/,'frame=',i8,':  total no_centroids_in_frame=',i5)
   
!         write(9010,9111) 1,3, no_centroids_this_subregion_of_frame(frame,1,3),&
!                          2,3, no_centroids_this_subregion_of_frame(frame,2,3), &
!                          3,3, no_centroids_this_subregion_of_frame(frame,3,3)
   
!         write(9010,9111) 1,2, no_centroids_this_subregion_of_frame(frame,1,2),&
!                          2,2, no_centroids_this_subregion_of_frame(frame,2,2), &
!                          3,2, no_centroids_this_subregion_of_frame(frame,3,2)
   
!         write(9010,9111) 1,1, no_centroids_this_subregion_of_frame(frame,1,1),&
!                          2,1, no_centroids_this_subregion_of_frame(frame,2,1), &
!                          3,1, no_centroids_this_subregion_of_frame(frame,3,1)
         
!         9111 format(3(':',i2,i2,i4,5x)) 
!   end do
!end if
