
!module modules_for_Trajectory_Identification
!contains

!-----------is_centroid_within_progenitor_search_area----------------
   subroutine is_cand_1st_descendant_in_progenitor_search_area(dt,prog_search_Velocity,x,y,candidate_progenitor,candidate_first_descendant,status_centroid,distance_to_detect_very_slow_particles,answer,debug, use_additional_exogenous_criteria_for_real_trajs, max_distance_between_cent_of_a_traj)
      use declarations_section
      !implicit none
      !include 'declarations_section_for_Trajectory_Identification.f90'
      !real distance_p_to_cc, distance_to_detect_very_slow_particles, distance_between_centroids
      !real r_max, dt, prog_search_Velocity, delt_x, delt_y, degree_traj, angle_c1, max_distance_between_cent_of_a_traj; 
      !integer c1,candidate_progenitor, candidate_first_descendant, debug, first_centroid, second_centroid, apply_criteria_always
      !include 'declaration_of_variables_appearing_in_module_subroutines.f90'
      !character answer, use_additional_exogenous_criteria_for_real_trajs
      
      ! ***************** Is this 1st_Desc in the PSA? ************************
      ! distance_p_to_cc is the distance between the Progenitor and the 1st_desc.  "cc" is a generic parameter usually representing the centroid being tested to see if it is in a search area.     
      distance_p_to_cc = distance_between_points(x(candidate_progenitor),y(candidate_progenitor),x(candidate_first_descendant),y(candidate_first_descendant)) !distance is in pixels
      ! r_max is the diameter of the Progenitor Search Area
      r_max = dt * prog_search_Velocity ! recall that prog_search_Velocity is in units of pixels per second and dt in seconds     
      if(distance_p_to_cc .lt. r_max .or. distance_p_to_cc .eq. 0) then        
         !status_centroid(candidate_first_descendant)=100
         answer='yes'
         ! >>>>>>>>>>>>>>>>>>> apply additional case-specific criteria <<<<<<<<<<<<<<<<<<
      else
         answer='no'
      end if 
      ! Now apply additional criteria
      if(use_additional_exogenous_criteria_for_real_trajs .eq. 'Y') then 
         call case_specific_criteria_for_p_c1_pair(answer,apply_criteria_always, candidate_progenitor,candidate_first_descendant,distance_p_to_cc, distance_to_detect_very_slow_particles,max_distance_between_cent_of_a_traj, x, y);
      end if

      ! ************************************************************************

      ! For particles with very low velocity, the centroid can jump around from frame-to-frame within a 1-2 pixel area;
      ! therefore, it will not be detected using descendant searches
      ! So to detect particles with very low velocities, if displacement is less than a certain exogenous criterion, then assume it is in the search area     
      ! For Region 1 and Region 3, upstream of the step, if distance_p_to_cc is small, go for it
      ! >>>>>>>>>>>>>>>>>>> end of additional case-specific criteria <<<<<<<<<<<<<<<<<< 
      
      !write(*,8991) candidate_progenitor, candidate_first_descendant, distance_p_to_cc, r_max, answer
      if(debug .gt. 0.1) then 
         if ( answer .eq. 'y') then
         write(945,8991) candidate_progenitor, candidate_first_descendant, distance_p_to_cc, r_max, answer; 
          8991 format( ' p=',i8,' is 1st_Desc=',i8,' in PSA?  :   Distance p to 1st_Desc =',f12.6,'  r_max=',f12.6, '  answer=',A3,' YES!')
         else
           write(945,8992) candidate_progenitor, candidate_first_descendant, distance_p_to_cc, r_max, answer; 
           8992 format(' p=',i8,' is 1st_Desc=',i8,' in PSA?  :   Distance p to 1st_Desc =',f12.6,'  r_max=',f12.6, '  answer=',A3)
         end if
      end if                 
       
   return; end subroutine is_cand_1st_descendant_in_progenitor_search_area

!-----------is_centroid_within_Descendant_Search_Area----------------        
      subroutine is_centroid_cc_in_descendant_search_area(t,Acc_min,Acc_max,search_angle,max_prog_search_Velocity,dt,c0,c1,cc,&
                                                          x,y,status_centroid,distance_to_detect_very_slow_particles,debug,use_additional_exogenous_criteria_for_real_trajs,max_distance_between_cent_of_a_traj, answer)
      use declarations_section

      ! See "Basic Search Step for Trajectory Identification.doc" for description of this step
      ! c0 is the centroid at time 0, c1 at time 1, cc at time 2 (guessed for search area) and cc is the candidate centroid
      ! Rmin, Rmax, and search_angle define the search area
      !implicit none
      !include 'declarations_section_for_Trajectory_Identification.f90'
      !real angle_candidate, angle_c1, distance_0_to_1, distance_0_to_cc, distance_1_to_cc, velocity_1_to_cc, max_distance_between_cent_of_a_traj
      !real Acc_min, Acc_max, r_min, r_max, search_angle !,search_area_translational, search_area_angular 
      !real dt, max_prog_search_Velocity, temp 
      !real distance_to_detect_very_slow_particles, delt_x, delt_y, degree_traj, distance_between_centroids
      !integer t,lower_bound,upper_bound, debug ; integer  c0, c1, cc, first_centroid, second_centroid, apply_criteria_always
      !character answer, use_additional_exogenous_criteria_for_real_trajs
      !include 'declaration_of_variables_appearing_in_module_subroutines.f90'
  
      ! Is cc within descendent search area (DSA) ? 
      ! Split up these if statements to speed calculation.  If the first if statement is false, then no reason to calculate the next two also! 
      ! Only do calculations if necessary for the next if statement
      distance_0_to_1  = distance_between_points(x(c0),y(c0),x(c1),y(c1))     
      distance_0_to_cc = distance_between_points(x(c0),y(c0),x(cc),y(cc))
      r_max = distance_0_to_1 * (2.0 + Acc_max)    
         
      if(  distance_0_to_cc .lt. r_max ) then       
         r_min = distance_0_to_1 * (2.0 - Acc_min)
         if(  distance_0_to_cc .gt. r_min ) then                       
            angle_candidate = angle_between_lines(x(c0),y(c0),x(c1),y(c1),x(cc),y(cc), temp)   
            if( angle_candidate .lt. search_angle .or. distance_0_to_1 .eq. 0) then         
               answer='y'
            else
               answer='n' 
            end if       
         else
            answer='n' 
         end if     
      else
         answer='n' 
      end if

      ! ADDITIONAL CRITERIA FOR RELATIONSHIP CENTRIOD C1 AND CANDIDATE CENTROID CC         
      ! Apply the distance criteria for slow moving particles      
      if (distance_to_detect_very_slow_particles .gt. 0) then
         if (answer .eq. 'n') then
           distance_1_to_cc = distance_between_points(x(c1),y(c1),x(cc),y(cc))     
           ! if(distance_1_to_cc .gt. 2) then ! If displacement is large enough
           !    if(distance_1_to_cc .lt. distance_to_detect_very_slow_particles .and. abs(angle_c1) .gt. 125 ) answer='y'
           ! else ! Displacement is so small that pixel jitter can make the centroid move in almost any direction
           if(distance_1_to_cc .lt. distance_to_detect_very_slow_particles ) answer='y'
           !end if  
         end if
      end if
      
      if(use_additional_exogenous_criteria_for_real_trajs .eq. 'Y') then           
         call case_specific_criteria_for_c1_cc_pair(answer,apply_criteria_always, c0,c1,cc,distance_0_to_1,distance_1_to_cc,distance_0_to_cc,distance_to_detect_very_slow_particles, angle_candidate, angle_c1, max_distance_between_cent_of_a_traj, x, y)
      end if 
      
      !if (answer .eq. 'y') then
         !The following if condition reduces erroneous trajctories by keeping any velocity along a trajectory from getting much faster than the max possible velocity
      !   velocity_1_to_cc = distance_1_to_cc / dt
      !   if(velocity_1_to_cc .gt. 2.0 * max_prog_search_Velocity ) answer='n'
      !end if
      
      ! END ADDITIONAL CRITERIA FOR CENTROID PAIRS     
           
      if(debug .gt. 0.1) then
         if (answer .eq. 'y') then
            write(945,6991) c0, c1, cc, distance_0_to_cc, r_min, r_max, angle_candidate, search_angle !, answer
            6991 format( 'c0=',i8,' : c1=',i8,'  cc=',i8,' : dist_0_to_cc=',f8.3,' : r_min=',f8.3,' r_max=',f8.3,' : ang_cand=',f9.4,' ang_search=',f9.4,' Found in DSA')
         else
            write(945,6992) c0, c1, cc, distance_0_to_cc, r_min, r_max, angle_candidate, search_angle !, answer
            6992 format( 'c0=',i8,' : c1=',i8,'  cc=',i8,' : dist_0_to_cc=',f8.3,' : r_min=',f8.3,' r_max=',f8.3,' : ang_cand=',f9.4,' ang_search=',f9.4)
         end if
      end if
           
      !write(*,6991) c0, c1, cc, distance_0_to_cc, r_min, r_max, angle_candidate, search_angle, answer
      !6996 format( 'c0=',i8,' c1=',i8,' cc=',i8,' distance_0_to_cc=',f8.3,'  r_min=',f8.3,'  r_max=',f8.3,' ang_cand=',f9.4,' ang_search=',f9.4,'  answer=',A3)
      !write(905,6996) c0, c1, cc, distance_0_to_cc, r_min, r_max, angle_candidate, search_angle, answer
      
   return; end subroutine is_centroid_cc_in_descendant_search_area

!----------- case_specific_criteria_for_c1_cc_pair ----------------        
include '..\Trajectory_Identification\input\Additional_Criteria\case-specific_criteria_for_c1-cc_pair.f90'

! --------------- apply_additional_case_specific_criteria_for_p_c1_pair -----------------------
include '..\Trajectory_Identification\input\Additional_Criteria\case-specific_criteria_for_p-cc_pair.f90'

!-------------find_number_of_centroids_in_each_frame----------------
   subroutine find_number_of_centroids_in_each_frame(total_no_centroids,frame_no_of_a_centroid,no_centroids_in_frame,first_centroid_in_frame,last_centroid_in_frame,debug)
      use declarations_section

      !implicit none
      !include 'declarations_section_for_Trajectory_Identification.f90'

      frame_number = 1; centroid_counter = 1; no_centroids_in_frame(frame_number)=0; first_centroid_in_frame(1)=1
      frame_no_of_a_centroid(0)=1; ! This avoids the problem of frame_no_of_a_centroid(centroid_counter-1) being out-of-range
      
      if(debug .gt. 0.1) write(976,3976) frame_number, centroid_counter; 3976 format('Starting into centroid loop  frame_number=',i7,'  centroid_counter=',i7);
      
      do while (centroid_counter .le. total_no_centroids)
         if ( centroid_counter .eq. 1 .or. frame_no_of_a_centroid(centroid_counter) .eq. frame_no_of_a_centroid(centroid_counter-1) ) then !still in same frame
            no_centroids_in_frame(frame_number) = no_centroids_in_frame(frame_number) + 1
            if(debug .gt. 0.1) write(976,3977) frame_number, centroid_counter; 3977 format('Still in frame ',i7,' for centroid ',i7);
         end if
         
         ! Now that we have counted all of the centroids in this frame, there are three cases for the next frame:
         
         ! CASE_1: next frame has no centroids
         ! Now that the operation is past the last centroid of a frame and to the next centroid, but not necessarily the next frame:
         ! First find out if the next frame has 0 centroids
         no_consecutive_frames_with_no_centroids = ( frame_no_of_a_centroid(centroid_counter) - frame_no_of_a_centroid(centroid_counter-1) )  -  1                  
         if ( no_consecutive_frames_with_no_centroids .gt. 0 ) then ! Encountered a series of frames with no centroids !!!             
            if(debug .gt. 0.1) write(976,3111) frame_number, no_consecutive_frames_with_no_centroids; 
			   3111 format('Into Case1 because no centroids in frame_number ',i7, '  has  ',i7,' consecutive frames with no centroids');
			
			   ! Now take care of the last frame before the frame(s) with no centroids
            last_centroid_in_frame(frame_number) = centroid_counter-1

            if(debug .gt. 0.1) write(976,3978) frame_number, centroid_counter; 3978 format('Frame ',i7,' has no centroids');

            ! Write parameters for the consecutive frame(s) that have no centroids
            do k = 1 , no_consecutive_frames_with_no_centroids        
               frame_with_no_centroids = frame_no_of_a_centroid(centroid_counter-1) + k;  frame_number = frame_with_no_centroids;              
               no_centroids_in_frame(frame_number)  = 0 ; first_centroid_in_frame(frame_number) = 0; last_centroid_in_frame(frame_number) = 0            
               !print*, 'Frame no ',frame_with_no_centroids,'  has ',no_centroids_in_frame(frame_with_no_centroids),' centroids!'
               !pause               
            end do  
            
            ! Now that all consecutive frames with no centroids have been taken care of, prepare for the next frame that has centroids
            frame_number = frame_number + 1 ;            
            first_centroid_in_frame(frame_number) = centroid_counter
            no_centroids_in_frame(frame_number)=1 
            go to 2582
         end if         
         ! CASE_2: next frame has centroids
         if ( centroid_counter .ne. 1 .and. frame_no_of_a_centroid(centroid_counter) .gt. frame_no_of_a_centroid(centroid_counter-1) ) then !AT THE FIRST CENTROID OF NEXT FRAME
            ! Now (remember that 'frame_number' is usually the frame no of the last frame, but if this is after a frame with no centroids, then frame_number
            
            if(no_consecutive_frames_with_no_centroids .gt. 0) then  ! if frame_number had no centroids, then
               last_centroid_in_frame(frame_number)= centroid_counter
               
               if(debug .gt. 0.1) then
                  write(976,2979) no_consecutive_frames_with_no_centroids; 2979 format('no_consecutive_frames_with_no_centroids=',i3);
                  write(976,3979) frame_number+1, centroid_counter, frame_number, first_centroid_in_frame(frame_number), last_centroid_in_frame(frame_number); 
               end if

            else
               last_centroid_in_frame(frame_number)= centroid_counter - 1   
               if(debug .gt. 0.1) write(976,3979) frame_number+1, centroid_counter, frame_number, first_centroid_in_frame(frame_number), last_centroid_in_frame(frame_number); 
               3979 format(/,'At the first centroid of frame ',i7,' which is ',i7,' so the first centroid of frame',i7,' is ',i7, '  and the last centroid is ',i7);    
            end if
         
            ! Since we're at the first centroid of the next frame, setup for next frame
            frame_number = frame_number + 1 ; 
            first_centroid_in_frame(frame_number) = centroid_counter
			if(debug .gt. 0.1) then
			   write(976,1087)first_centroid_in_frame(frame_number), frame_number, centroid_counter
			   1087 format('first_centroid_in_frame just changed to ',i7,' at frame ',i7,' centroid_counter=',i7);
			end if			
            
			! Set centroid counter for next frame
			no_centroids_in_frame(frame_number)= 1   
			
         endif
         
     ! CASE_3: At last centroid is centroid list
         if ( centroid_counter .eq. total_no_centroids ) then !at last centroid
            last_centroid_in_frame(frame_number)=centroid_counter
            if(debug .gt. 0.1) write(976,3980) frame_number, centroid_counter; 3980 format('At last centroid of centroid list for frame ',i7,' which is ',i7);    
         endif
         
         2582 continue   
         centroid_counter=centroid_counter+1 
      end do
      
      ! Let's write out all of the first and last centroids 
      if(debug .gt. 0.1) then
         do i = 1, frame_number
            write(976,3981) i, i, first_centroid_in_frame(i), i, last_centroid_in_frame(i); 
         end do
         3981 format('frame ',i7,' first_centroid_in_frame(',i5,')=',i7,'  last_centroid_in_frame(',i5,')=',i7);
      end if      
      
   return; end subroutine find_number_of_centroids_in_each_frame!-------------------------------------------------------------------



!----------------extrapolate new imaginary centroid-----------------
   !subroutine create_an_imaginary_centroid(status_centroid,c0,c1,x,y,xi,yi,ci,cc,direction_along_path,frame_no_of_a_centroid, imaginary_centroid, frame_no_of_an_imaginary_centroid)
   subroutine create_an_imaginary_centroid(status_centroid,c0,c1,x,y,xi,yi,ci,cc,direction_along_path,frame_no_of_a_centroid, imaginary_centroid)
      use declarations_section

      !implicit none
     ! include 'declarations_section_for_Trajectory_Identification.f90'
      real xi, yi !real xi, yi, x(20000000), y(20000000)
      integer c0, c1,ci,cc,direction_along_path,imaginary_centroid  !  integer status_centroid(20000000), c0, c1,ci,cc,direction_along_path  
      !include 'declaration_of_variables_appearing_in_module_subroutines.f90'
     ! integer frame_no_of_an_imaginary_centroid(1000000)

      ! Generate an imaginary centroid by extrapolating using c0 and c1
      xi = x(c1) + ( x(c1) - x(c0) )
      yi = y(c1) + ( y(c1) - y(c0) )    
        
      direction_along_path = -2
      ci = ci - 1  ! increment (in negative direction) the centroid_no for this imaginary centroid; imaginary centroid numbers are negative
      x(ci) = xi ;  y(ci) = yi
      cc = ci
      frame_no_of_a_centroid(ci) = frame_no_of_a_centroid(c1)+1
      status_centroid(ci) = -1  ! Mark imaginary centroid so it is never found it a search (imaginary centroids are only used as c1 in a c0-c1 pair

      ! But if this imaginary centroid is out of the FOV, then no need to test it, so set its status as -3
      if(xi .lt. 0 .or. xi .gt. x_pixels) status_centroid(ci) = -3
      if(yi .lt. 0 .or. yi .gt. y_pixels) status_centroid(ci) = -3
     
     ! write(920,1937) ci, x(ci), y(ci), frame_no_of_a_centroid(ci) ; 
     ! 1937 format('In find_real_trajs, ci reset to =',2x,i8,2(3x,f11.3),3x,i8)
     ! imaginary_centroid = imaginary_centroid + 1 ! This generates an array of imaginary centroids with positive subscripts
     ! frame_no_of_an_imaginary_centroid(imaginary_centroid) = frame_no_of_a_centroid(ci)
     ! direction_along_path = -2
     ! print*, 'Just created the ', imaginary_centroid,'th  imaginary centroid with c0=',c0,' ci=',ci,'  c1=',c1
     ! write(905,*) 'Just created another imaginary centroid'
!      pause
   return; end subroutine create_an_imaginary_centroid
   
!----------------distance_between_points----------------------------
   real function distance_between_points(x1,y1,x2,y2)
      ! This subroutine has been verified to be correct
      !implicit none
      real x1,y1,x2,y2
      distance_between_points= sqrt( (x2-x1)**2.0 + (y2-y1)**2.0 )  !**0.5
   end function distance_between_points

!---------------angle_between_lines---------------------------------
  real function angle_between_lines(x_a, y_a, x_b, y_b, x_c, y_c, temp) 
      ! This subroutine has been verified to be correct
      !implicit none
      real x_a, y_a, x_b, y_b, x_c, y_c, side_a, side_b, side_c, temp

      ! (I use "_" in names to avoid confusion of xc,yc with centroid in other program areas)
      ! From the Law of Cosines:  cos(A)=(b**2+c**2-a**2)/(2*b*c)
      ! where A,B, and C are angles for a triangle of point_A, point_B, point_C and sides side_a, side_b, side_c.
      ! side_a is opposite angle A, so side_a is between Points B and C
      ! I use Point 0 as point A, Point 2 as Point B, and Point 3 as Point C (for candidate)
      ! Wiki and other texts often use different labeling for their triangle: they solve for angle C.
      ! First find distance between points, i.e., sides of triangle
      side_a= distance_between_points(x_b,y_b,x_c,y_c)
      side_b= distance_between_points(x_a,y_a,x_c,y_c)
      side_c= distance_between_points(x_a,y_a,x_b,y_b)
      
      ! Prevent return of NaN if two of the three points are exactly horizontal or vertical
      ! Remember that units are pixels, and centroids are only to 1 decimal point
      if(abs(side_a) .lt. 0.00001) side_a=0.0001; 
      if(abs(side_b) .lt. 0.00001) side_b=0.0001; 
      if(abs(side_c) .lt. 0.00001) side_b=0.0001; 
     
      !if(side_a .eq. 0.0) side_c=0.0000001
      !if(side_b .eq. 0.0) side_c=0.0000001
      !if(side_c .eq. 0.0) side_c=0.0000001
                
      ! If the angle is 0, then temp will be 1.0, but sometimes it is slightly more than 1.0 so it gives a result of "NaN"
      ! To avoid this:
      ! if (   ( side_b**2 + side_c**2 - side_a**2 )/( 2.0 * side_b * side_c )   .gt.  0.9999  ) temp=0.999999999
      
      angle_between_lines = acos(   ( side_b**2 + side_c**2 - side_a**2 )/( 2.0 * side_b * side_c )   )  !This is angle A in radians   
   
   end function angle_between_lines
     
   !-------------Other angle between Lines Balaji 03/08----------------------------!
   ! This calculates the turning angle and it is also used to avoid turning back of tracks. It might become obsolete because of modifications made in 
   ! detection of slow moving tracks   
   
  real function sec_angle_between_lines(x_a, y_a, x_b, y_b, x_c, y_c, temp) 
      ! This subroutine has been verified to be correct
      !implicit none
      real x_a, y_a, x_b, y_b, x_c, y_c, side_a, side_b, side_c, temp

      ! (I use "_" in names to avoid confusion of xc,yc with centroid in other program areas)
      ! From the Law of Cosines:  cos(A)=(b**2+c**2-a**2)/(2*b*c)
      ! where A,B, and C are angles for a triangle of three point_A, point_B, point_C and sides side_a, side_b, side_c.
      ! side_a is opposite angle A, so side_a is between Points B and C
      ! I use Point 0 as point A, Point 2 as Point B, and Point 3 as Point C (for candidate)
      ! Wiki and other texts often use different labeling for their triangle: they solve for angle C.
      ! First find distance between points, i.e., sides of triangle
      side_a= distance_between_points(x_b,y_b,x_c,y_c)
      side_b= distance_between_points(x_a,y_a,x_c,y_c)
      side_c= distance_between_points(x_a,y_a,x_b,y_b)
      ! Prevent return of NaN if two of the three points are exactly horizontal or vertical
      ! Remember that units are pixels, and centroids are only to 1 decimal point
      if(abs(side_a - 0) .lt. 0.001) side_a=0.001; 
      if(abs(side_b - 0) .lt. 0.001) side_b=0.001; 
      if(abs(side_c - 0) .lt. 0.001) side_b=0.001; 
     
      !if(side_a .eq. 0.0) side_c=0.0000001
      !if(side_b .eq. 0.0) side_c=0.0000001
      !if(side_c .eq. 0.0) side_c=0.0000001
           
      temp=( side_c**2 + side_a**2 - side_b**2 )/( 2.0 * side_c * side_a )
      
      ! If the angle is 0, then temp will be 1.0, but sometimes it is slightly more than 1.0 so it gives a result of "NaN"
      ! To avoid this:
            if (temp .gt. 0.9999) temp=0.999999999
      
      sec_angle_between_lines = acos(temp)  !This is angle A in radians   
   
   end function sec_angle_between_lines   

!-------------------------------------------------------------------


!!!!!!!! Balaji changes start here 
subroutine Curve_fit_traj_with_Cholesky_method(y,fitted_y,n,order_of_polynomial_for_curve_fitting_trajectories) 
!implicit none
real  x(50000), y(50000), fitted_y(50000), F(50000,1000), FT(1000,50000), A1(1000,1000), B1(1000), C1(1000)
integer  i, j, k, n, ii, l, m, mp1,no_data, itemp1, itemp2, order_of_polynomial_for_curve_fitting_trajectories
!m = 3;  !FS: Frank changed this
m = order_of_polynomial_for_curve_fitting_trajectories
! This part has been modified from Franks fitting code to be used with any polynomial expansion
do i=1,n ! Generate the time domain matrix
x(i) = i
end do

! F is an nxm matrix, where n is the number of data points, m is the number of coefficients
do i=1,n 
   do j=0,m-1
   if(j .lt. 1) then
   F(i,j+1) = j+1
   else
   F(i,j+1)= x(i)**j  
   end if
   end do 
end do

do i=1,n 
   do j=0,m-1
   if(j .lt. 1) then
   FT(j+1,i) = j+1
   else
   FT(j+1,i)= x(i)**j  
   end if
   end do 
end do


! Determine coefficient matrix A of simultaneous equation system
call matmpy(ft,f,a1,m,n,m)
! Determine the column of constants for simultaneous equation system
call matmpy1(ft,y,b1,m,n,1)
do i=1,m; 
     a1(i,m+1)=b1(i)
end do;

! Determine c values by solving simultaneous eqn's using Cholesky method
mp1 = m + 1
call chlsky(a1,m,mp1,c1)
do i=1,n;
   do j = 1,m;
   fitted_y(i) = fitted_y(i) + c1(j)*x(i)**(j-1)
   end do;
end do;

return ; end subroutine Curve_fit_traj_with_Cholesky_method

!_______________________________________________________
subroutine matmpy(a,b,c,m,n,l)
! determines matrix c as product of a and b
dimension  A(1000,50000), B(50000,1000), C(1000,1000)
! Now multiply FT x F , a mxn X nxm gives an mxm
do i=1,m; 
   do j=1,l;
      C(i,j)=0.0 ;
      do k=1,n; 
         c(i,j)= c(i,j) + a(i,k) * b(k,j);
      end do; 
   end do; 
end do;
return
end subroutine matmpy

subroutine matmpy1(a,b,c,m,n,l)
! determines matrix c as product of a and b
dimension  A(1000,50000), B(50000), C(1000)
! Now multiply FT x F , a mxn X nxm gives an mxm
do i=1,m; 
   do j=1,l;
      C(i)=0.0 ;
      do k=1,n; 
         c(i)= c(i) + a(i,k) * b(k);
      end do; 
   end do; 
end do;
return
end subroutine matmpy1
!_______________________________________________________

! ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
subroutine chlsky(a,n,m,x)
dimension  A(1000,1000), x(1000)
! calc first row of upper unit triangular matrix
do j=2,m ; a(1,J) = a(1,J) / a(1,1) ; end do
! calc other elements of U and L matrices
do i = 2,n !8
   j=i
   do ii = j,n !5
      sum=0
      jm1=j-1
      do k=1,jm1; sum = sum + a(ii,k) * a(k,j); end do !4
      a(ii,j) = a(ii,j) - sum
   end do !5
   ip1 = i + 1
   do jj=ip1,m !7
      sum=0.
      im1=i-1
      do k=1, im1; sum = sum + a(i,k) * a(k,jj); end do !6
   a(i,jj) = ( a(i,jj) - sum ) / a(i,i)
   end do !7
end do !8
! solve for x(i) by back substitition
x(n) = a(n,n+1)
l = n - 1
do nn = 1 , l !10
   sum=0.
   i=n-nn
   ip1=i+1
   do j=ip1,n ; sum = sum + a(i,j) * x(j); end do !9
   x(i) = a(i,m) - sum
end do
return
end subroutine chlsky
! ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
! Balaji changes end here

!end module modules_for_Trajectory_Identification

!-------------intersection_of_two_lines-----------------------------
!   subroutine intersection_of_two_lines(x1,y1, x2,y2, x3,y3, x4,y4, x_intersection, y_intersection)
      !real x1, y1, x2, y2, x3, y3, x4, y4, x_intersection, y_intersection, DelM, DelMInv;
!      !implicit none
!      include 'declarations_section_for_Trajectory_Identification.f90'
!      DelM = (y2 - y1)/(x2 - x1) - (y4 - y3)/(x4 - x3);
!      DelMInv = (x2 - x1)/(y2 - y1) - (x4 - x3)/(y4 - y3);
!      y_intersection = (y1*(x2 - x1)/(y2 - y1) - y3*(x4 - x3)/(y4 - y3) - (x1 - x3))/ DelMInv;
!      x_intersection = (x1*(y2 - y1)/(x2 - x1) - x3*(y4 - y3)/(x4 - x3) - (y1 - y3))/ DelM;
!   return; end subroutine intersection_of_two_lines
!------------ find last branch point in a trajectory ---------------
!   subroutine check_for_branch_point(dt,c0,c1,cc,x,y,status_centroid,answer, &
!                                     no_centroids_in_search_area,t,first_centroid_in_frame,last_centroid_in_frame,last_branch_point)
!     !implicit none
!     include 'declarations_section_for_Trajectory_Identification.f90'
!     no_centroids_in_search_area = 0
!     do ic = first_centroid_in_frame(t),last_centroid_in_frame(t)   
!           call is_centroid_cc_in_descendant_search_area(t,Acc_min,Acc_max,search_angle,prog_search_Velocity,dt,c0,c1,cc,x,y,status_centroid,answer)
!           no_centroids_in_search_area = no_centroids_in_search_area + 1
!        end do 
!       if (no_centroids_in_search_area .gt. 1) last_branch_point = t
!   return; end subroutine check_for_branch_point
!-------------set_temp_status_as_candidate_progenitor-----------
!   subroutine set_centroids_in_frame_as_progenitors(progenitor_frame,first_centroid_in_frame,last_centroid_in_frame,status_centroid)
!      !implicit none
!      include 'declarations_section_for_Trajectory_Identification.f90'
!      integer cp
!      do cp = first_centroid_in_frame(progenitor_frame), last_centroid_in_frame(progenitor_frame)
!         status_centroid(cp)=0  !let status for progenitors be 0!
!      end do
!   return; end subroutine set_centroids_in_frame_as_progenitors

!-------------set_temp_status_as_candidate_first_descendant---------
!   subroutine set_frame_centroids_status_as_1st_descendants(first_descendant_frame,status_centroid)
!      !implicit none
!      include 'declarations_section_for_Trajectory_Identification.f90'
!      integer fd  !use a private counter for this subroutine to avoid confusion
!      do fd = first_centroid_in_frame(first_descendant_frame), last_centroid_in_frame(first_descendant_frame)
!         status_centroid(fd)=0  !let status for candidates for first descendant be 1
!      end do
!   return; end subroutine set_frame_centroids_status_as_1st_descendants
!---------- mark centroids back to branch point as ineligible-------
!   subroutine mark_all_centroids_ineligible_back_to_branch(last_branch_point,centroid_no,status_centroid)
!      !implicit none
!      include 'declarations_section_for_Trajectory_Identification.f90'
!      do j=last_branch_point,t
!         status_centroid(j) = 100
!      end do
!   return; end subroutine mark_all_centroids_ineligible_back_to_branch

