! calc_trajs_of_individual_part_and_clusters_separately.f90
! This divides trajectories into groups based on particle image size.  The variable dividing providing a "cutoff"
! between individual particles and clusters is "calc_trajs_of_individual_part_and_clusters_separately.f90"
! In the PSRI cluster analysis, Nov-Feb 2008-2009, I assume that small, individual particles follow the air flow, 
! and I assume larger clusters do not.  Also, the air flow varies in velocity throughout the frames, so I need to compute
! an average air velocity for each frame. 

!-------------------------------------------------------------------------
! Now write the MTrackJ data file with "Cluster 1" for individual particles and "Cluster 2" for clusters.
! (Note that "Cluster 1" and "Cluster 2" are definitions used in MTrackJ.  These have nothing to do with my definition of clusters.)
! Write the file "MTrackJ_real_trajectories_particles_and_clusters.mdf"
! Draw individual particles red and clusters blue.
write(198,58921) ;  58921 format('Cluster 1  6628F2'); ! Write Cluster 1 header to MTrackJ file
do real_trajectory_no = 1 , total_no_real_trajectories
   ! First write Cluster 1 to MTrackJ file, where Cluster 1 contains only trajectories whose particle size is less than the upper_limit...
   ! Go through all real trajectories, and this time just write those with small particles to MTrackJ
   ! Note that size_dividing_between_individual_particles_and_clusters is read in units of microns, but Avg_particle_feret_dia_for_trajectory is still in units of pixels, so I to convert it to microns
   if ( (Avg_particle_feret_dia_for_trajectory(real_trajectory_no)* fov_scale * 1e6) .lt. size_dividing_between_individual_particles_and_clusters) then 
      color='FF0000'
      write(198,59901) real_trajectory_no, color; 59901 format('Track ',i8,3x,A6); 
      ! Now write the centroids of this trajectory to MTrackJ
      do tc = 1 , ( real_trajectory_total_length(real_trajectory_no) ) ! scan of length of a real trajectory
         ic = real_trajectory_centroid(real_trajectory_no,tc)      
         !include "Find_frame_number_of_any_centroid_along_a_real_traj.F90" ! This takes tc and finds frame_no_of_a_centroid()
         ! Note that y is inverted, since I now am using the regular origin in lower left, not ImageJ's goofy origin in upper left.
         temp = y_pixels - y(ic)
         write(198,58971) tc, x(ic), temp, frame_no_of_a_centroid(ic) ;  ! Write real traj point to MTrackJ file
      end do
      58971 format('Point ',i8,1x,f5.1,1x,f5.1,1x,'1.0',1x,i7,1x,'1.0'); 
   end if
end do

!-------------------------------------------------------------------------
! Now write Cluster 2 containing clusters to MTrackJ file
write(198,58922) ;  58922 format('Cluster 2  6628F2'); ! Write Cluster 1 header to MTrackJ file
do real_trajectory_no = 1 , total_no_real_trajectories
   ! First write Cluster 1 to MTrackJ file, where Cluster 1 contains only trajectories whose particle size is less than the upper_limit...
   ! Go through all real trajectories, and this time just write those with small particles to MTrackJ
   if ( (Avg_particle_feret_dia_for_trajectory(real_trajectory_no)* fov_scale * 1e6) .gt. size_dividing_between_individual_particles_and_clusters) then 
      color='0B65EB'
      write(198,59902) real_trajectory_no, color; 59902 format('Track ',i8,3x,A6); 
      ! Now write the centroids of this trajectory to MTrackJ
      do tc = 1 , ( real_trajectory_total_length(real_trajectory_no) ) ! scan of length of a real trajectory
         ic = real_trajectory_centroid(real_trajectory_no,tc)      
         !include "Find_frame_number_of_any_centroid_along_a_real_traj.F90" ! This takes tc and finds frame_no_of_a_centroid()
         ! Note that y is inverted, since I now am using the regular origin in lower left, not ImageJ's goofy origin in upper left.
         temp = y_pixels - y(ic)
         write(198,58972) tc, x(ic), temp, frame_no_of_a_centroid(ic) ;  ! Write real traj point to MTrackJ file
      end do
      58972 format('Point ',i8,1x,f5.1,1x,f5.1,1x,'1.0',1x,i7,1x,'1.0'); 
   end if
end do

write(198,38931); 38931 format('End of MTrackJ Data File')

!----------------------------------------------------
! Now calculate average speed and angle for each frame, first for individual particles, then for clusters
! What I am after here is the slip velocity of the clusters.  I assume that the indidivual particles are following the gas flow, 
! so I get the gas flow from the individual particle velocities.  Then I subtract the indidivual cluster velocities from the gas velocity to
! get the slip velocity for each cluster.  This accounts for clusters moving downward (-y direction). Then I average the slip velocity for each frame.  

! FIRST FOR INDIVIDUAL PARTICLES (to get the gas flow velocity by frame)
! ________________ Calculate frame-averaged velocities for INDIVIDUAL PARTICLES ___________________________
do frame=1, number_of_frames_to_analyze
no_velocity_vectors_this_frame(frame)=0; cumulative_X_speed_this_frame=0; cumulative_Y_speed_this_frame=0; 
   ! Range through centroids for this frame
   cc = first_centroid_in_frame(frame)
   do while ( cc .le. last_centroid_in_frame(frame) ) 
      real_trajectory_no = real_trajectory_no_of_centroid(cc)
      if ((Avg_particle_feret_dia_for_trajectory(real_trajectory_no)* fov_scale * 1e6) .lt. size_dividing_between_individual_particles_and_clusters) then 
         tc = position_of_centroid_in_trajectory(cc)
            if(real_trajectory_no .gt. 0 .and. tc .gt. 0) then !only calculate if this centroid is in a trajectory
               no_velocity_vectors_this_frame(frame) = no_velocity_vectors_this_frame(frame) + 1
               ! Recall that x_speed_along_traj includes sign of direction (+/-).  How will the change average if particles are moving in opposite directions?
               cumulative_X_speed_this_frame = cumulative_X_speed_this_frame + x_speed_along_traj(real_trajectory_no,tc)
               cumulative_Y_speed_this_frame = cumulative_Y_speed_this_frame + y_speed_along_traj(real_trajectory_no,tc)
            end if
      end if
         cc = cc + 1
   end do
   if (no_velocity_vectors_this_frame(frame) .le. 0) then ! if no vectors detected in this frame, set velocities to that of previous frameo 0 ! Need to check this, may not be correct!!!!
      x_avg_speed_this_frame_for_individual_particle(frame)= x_avg_speed_this_frame_for_individual_particle(frame-1)
      y_avg_speed_this_frame_for_individual_particle(frame)= y_avg_speed_this_frame_for_individual_particle(frame-1)
      avg_speed_this_frame_for_individual_particle(frame) = avg_speed_this_frame_for_individual_particle(frame-1)
      avg_angle_this_frame_for_individual_particle(frame) = avg_angle_this_frame_for_individual_particle(frame-1)
   else
      x_avg_speed_this_frame_for_individual_particle(frame)= cumulative_X_speed_this_frame / no_velocity_vectors_this_frame(frame)
      y_avg_speed_this_frame_for_individual_particle(frame)= cumulative_Y_speed_this_frame / no_velocity_vectors_this_frame(frame)
      avg_speed_this_frame_for_individual_particle(frame) = sqrt(x_avg_speed_this_frame_for_individual_particle(frame)**2 + y_avg_speed_this_frame_for_individual_particle(frame)**2)
      avg_angle_this_frame_for_individual_particle(frame) = atan(y_avg_speed_this_frame_for_individual_particle(frame)/x_avg_speed_this_frame_for_individual_particle(frame))
   end if
! ________________ End of Calculate frame-averaged velocities for individual particles ___________________________

end do
! _______________  End of Calculate variance of individual particle velocities for this frame ____________________


! NEXT FOR CLUSTERS
! ________________ Calculate frame-averaged velocities for CLUSTERS ___________________________
do frame=1, number_of_frames_to_analyze
! reset counting dummy parameters:
cumulative_X_slip_speed_this_frame=0; cumulative_Y_slip_speed_this_frame = 0;
no_velocity_vectors_this_frame(frame)=0; cumulative_X_speed_this_frame=0; cumulative_Y_speed_this_frame=0; 
   ! Range through centroids for this frame
   cc = first_centroid_in_frame(frame)
   do while ( cc .le. last_centroid_in_frame(frame) ) 
      real_trajectory_no = real_trajectory_no_of_centroid(cc)
      if ((Avg_particle_feret_dia_for_trajectory(real_trajectory_no)* fov_scale * 1e6) .gt. size_dividing_between_individual_particles_and_clusters) then 
         tc = position_of_centroid_in_trajectory(cc)
            if(real_trajectory_no .gt. 0 .and. tc .gt. 0) then !only calculate if this centroid is in a trajectory
               no_velocity_vectors_this_frame(frame) = no_velocity_vectors_this_frame(frame) + 1            
               ! Recall that x_speed_along_traj includes sign of direction (+/-).  How will the change average if particles are moving in opposite directions?
               ! Calculate averages of mean cluster velocity
               x_speed_along_trajectory_for_cluster(real_trajectory_no,tc) = x_speed_along_traj(real_trajectory_no,tc)
               y_speed_along_trajectory_for_cluster(real_trajectory_no,tc) = y_speed_along_traj(real_trajectory_no,tc)
               cumulative_X_speed_this_frame = cumulative_X_speed_this_frame + x_speed_along_trajectory_for_cluster(real_trajectory_no,tc)
               cumulative_Y_speed_this_frame = cumulative_Y_speed_this_frame + y_speed_along_trajectory_for_cluster(real_trajectory_no,tc)
               ! Calculate averages of slip velocity
               x_slip_speed_cluster(real_trajectory_no,tc) = x_avg_speed_this_frame_for_individual_particle(frame) - x_speed_along_trajectory_for_cluster(real_trajectory_no,tc)
               y_slip_speed_cluster(real_trajectory_no,tc) = y_avg_speed_this_frame_for_individual_particle(frame) - y_speed_along_trajectory_for_cluster(real_trajectory_no,tc)
               cumulative_X_slip_speed_this_frame = cumulative_X_slip_speed_this_frame + x_slip_speed_cluster(real_trajectory_no,tc)
               cumulative_Y_slip_speed_this_frame = cumulative_Y_slip_speed_this_frame + y_slip_speed_cluster(real_trajectory_no,tc)
            end if
      end if
         !write(2999,2191) frame, real_trajectory_no, tc, speed_along_traj(real_trajectory_no,tc), angle_along_traj(real_trajectory_no,tc),cos(angle_along_traj(real_trajectory_no,tc)),sin(angle_along_traj(real_trajectory_no,tc)),x_spd, y_spd, cumulative_X_speed_this_frame, cumulative_Y_speed_this_frame
         !2191 format('frame=',i3,' rt=',i3,' tc=',i3,' speed_along_traj=',f8.2,' angle_along_traj=',f8.2,' cos=',f6.2,' sin=',f6.2,' x_spd='f6.3,' y_spd='f6.3,' cum_x=',f7.2,' cum_y=',f7.2)
         cc = cc + 1
   end do
   ! Calculate and averages for clusters absolute velocities
   ! Notice that in naming variables, I use plural "clusters" for averaged variables!
   if (no_velocity_vectors_this_frame(frame) .le. 0) then ! if no vectors detected in this frame, set velocities to that of previous frameo 0 ! Need to check this, may not be correct!!!!
      x_avg_speed_this_frame_for_clusters(frame)=           x_avg_speed_this_frame_for_clusters(frame-1)
      y_avg_speed_this_frame_for_clusters(frame)=           y_avg_speed_this_frame_for_clusters(frame-1)
      avg_angle_this_frame_for_clusters(frame) =              avg_angle_this_frame_for_clusters(frame-1)
      avg_speed_this_frame_for_clusters(frame) =              avg_speed_this_frame_for_clusters(frame-1)
      x_avg_slip_speed_this_frame_for_clusters(frame)= x_avg_slip_speed_this_frame_for_clusters(frame-1)
      y_avg_slip_speed_this_frame_for_clusters(frame)= y_avg_slip_speed_this_frame_for_clusters(frame-1)
      avg_slip_angle_this_frame_for_clusters(frame) =    avg_slip_angle_this_frame_for_clusters(frame-1)
      avg_slip_speed_this_frame_for_clusters(frame) =    avg_slip_speed_this_frame_for_clusters(frame-1)
   else
      x_avg_speed_this_frame_for_clusters(frame)= cumulative_X_speed_this_frame/no_velocity_vectors_this_frame(frame)
      y_avg_speed_this_frame_for_clusters(frame)= cumulative_Y_speed_this_frame/no_velocity_vectors_this_frame(frame)
      avg_angle_this_frame_for_clusters(frame) =      atan(y_avg_speed_this_frame_for_clusters(frame)/x_avg_speed_this_frame_for_clusters(frame))
      avg_speed_this_frame_for_clusters(frame) =      sqrt(x_avg_speed_this_frame_for_clusters(frame)**2 + y_avg_speed_this_frame_for_clusters(frame)**2)
      ! Calculate and averages for clusters SLIP velocities
      x_avg_slip_speed_this_frame_for_clusters(frame)= cumulative_X_slip_speed_this_frame/no_velocity_vectors_this_frame(frame)
      y_avg_slip_speed_this_frame_for_clusters(frame)= cumulative_Y_slip_speed_this_frame/no_velocity_vectors_this_frame(frame)
      avg_slip_angle_this_frame_for_clusters(frame) = atan(y_avg_slip_speed_this_frame_for_clusters(frame)/x_avg_slip_speed_this_frame_for_clusters(frame))
      avg_slip_speed_this_frame_for_clusters(frame) = sqrt(x_avg_slip_speed_this_frame_for_clusters(frame)**2 + y_avg_slip_speed_this_frame_for_clusters(frame)**2)
   end if

   write(700,6701) frame, x_avg_speed_this_frame_for_clusters(frame),y_avg_speed_this_frame_for_clusters(frame), &
                          avg_speed_this_frame_for_clusters(frame), avg_angle_this_frame_for_clusters(frame)*360/(2.0*3.14159)
   
   write(701,6701) frame, x_avg_slip_speed_this_frame_for_clusters(frame), y_avg_slip_speed_this_frame_for_clusters(frame),&
                          avg_slip_speed_this_frame_for_clusters(frame), avg_slip_angle_this_frame_for_clusters(frame)*360/(2.0*3.14159)
   6701 format(i6,4(3x,e13.5),2(3x,e13.5))
! ________________ End of Calculate frame-averaged velocities for CLUSTERS ___________________________
   
! ________________ Put key results for individual particles and clusters into single file _____________
   write(702,6704) frame, x_avg_speed_this_frame_for_individual_particle(frame),y_avg_speed_this_frame_for_individual_particle(frame), &
                          avg_speed_this_frame_for_individual_particle(frame), avg_angle_this_frame_for_individual_particle(frame)*360/(2.0*3.14159),&
                          x_avg_speed_this_frame_for_clusters(frame),y_avg_speed_this_frame_for_clusters(frame), &
                          avg_speed_this_frame_for_clusters(frame), avg_angle_this_frame_for_clusters(frame)*360/(2.0*3.14159), &
                          x_avg_slip_speed_this_frame_for_clusters(frame), y_avg_slip_speed_this_frame_for_clusters(frame)                        
   6704 format(i6,5x,4(f10.6,6x),6(f10.6,8x))
end do

! ________________  Now calculate rolling averages of parameters  ___________________________________
! Often there are not enough velocity vectors in each frame to get the true average, so I average the values over a number of frames
! 
starting_frame_for_averaging = rolling_average_window/2; last_frame_for_averaging = number_of_frames_to_analyze - rolling_average_window/2; 
do frame = starting_frame_for_averaging, last_frame_for_averaging

! reset summing dummy parameters to zero for next frame rolling average
rolling_X_avg_speed_this_frame_for_individual_particle=0; rolling_Y_avg_speed_this_frame_for_individual_particle=0;
rolling_X_avg_speed_this_frame_for_clusters=0;            rolling_Y_avg_speed_this_frame_for_clusters=0;
rolling_X_avg_slip_speed_this_frame_for_clusters=0;       rolling_Y_avg_slip_speed_this_frame_for_clusters=0;
rolling_avg_speed_this_frame_for_individual_particle=0;   rolling_avg_angle_this_frame_for_individual_particle=0;
rolling_avg_speed_this_frame_for_clusters=0;              rolling_avg_angle_this_frame_for_clusters=0;

   ! Now calculate rolling average over a window around this frame
   ! First 
   do temp_frame = (frame - rolling_average_window/2) , (frame + rolling_average_window/2) 
      rolling_X_avg_speed_this_frame_for_individual_particle = rolling_X_avg_speed_this_frame_for_individual_particle + x_avg_speed_this_frame_for_individual_particle(temp_frame) / rolling_average_window
      rolling_Y_avg_speed_this_frame_for_individual_particle = rolling_Y_avg_speed_this_frame_for_individual_particle+ y_avg_speed_this_frame_for_individual_particle(temp_frame) / rolling_average_window
      rolling_X_avg_speed_this_frame_for_clusters = rolling_X_avg_speed_this_frame_for_clusters + x_avg_speed_this_frame_for_clusters(temp_frame) / rolling_average_window
      rolling_Y_avg_speed_this_frame_for_clusters = rolling_Y_avg_speed_this_frame_for_clusters + y_avg_speed_this_frame_for_clusters(temp_frame) / rolling_average_window      
      rolling_X_avg_slip_speed_this_frame_for_clusters = rolling_X_avg_slip_speed_this_frame_for_clusters + x_avg_slip_speed_this_frame_for_clusters(temp_frame) / rolling_average_window
      rolling_Y_avg_slip_speed_this_frame_for_clusters = rolling_Y_avg_slip_speed_this_frame_for_clusters + y_avg_slip_speed_this_frame_for_clusters(temp_frame) / rolling_average_window      
      rolling_avg_speed_this_frame_for_individual_particle = rolling_avg_speed_this_frame_for_individual_particle + avg_speed_this_frame_for_individual_particle(temp_frame) / rolling_average_window
      rolling_avg_angle_this_frame_for_individual_particle = rolling_avg_angle_this_frame_for_individual_particle + avg_angle_this_frame_for_individual_particle(temp_frame) / rolling_average_window
      rolling_avg_speed_this_frame_for_clusters = rolling_avg_speed_this_frame_for_clusters + avg_speed_this_frame_for_clusters(temp_frame) / rolling_average_window
      rolling_avg_angle_this_frame_for_clusters = rolling_avg_angle_this_frame_for_clusters + avg_angle_this_frame_for_clusters(temp_frame) / rolling_average_window
   end do   

write(703,6704) frame, rolling_X_avg_speed_this_frame_for_individual_particle, rolling_Y_avg_speed_this_frame_for_individual_particle, &
                rolling_avg_speed_this_frame_for_individual_particle, rolling_avg_angle_this_frame_for_individual_particle*360/(2.0*3.14159), &
                rolling_X_avg_speed_this_frame_for_clusters, rolling_Y_avg_speed_this_frame_for_clusters, &
                rolling_avg_speed_this_frame_for_clusters, rolling_avg_angle_this_frame_for_clusters*360/(2.0*3.14159), &
                rolling_X_avg_slip_speed_this_frame_for_clusters, rolling_Y_avg_slip_speed_this_frame_for_clusters                   
end do

