! declaration_index.f90

! I put this declaration section into each module, subroutine, and function
! so that all parameters are global.  This way I don't have to worry about using the same declaration statements
! in the main, subroutine, and functions.  But I need to be careful with mixing parameters...
!------------ results ------------------------------
! Status of centroids is defined by the values of status_centroid()
!    10   eligible, free for any use. This is the initial state at the beginning of program.
!   111   ineligible, already a member of a real trajectory
!    -1   ineligible for any search because it is imaginary. Imaginary centroids are only used as c1 in a c0-c1 pair to search for a descendant!     0   temporary status as a progenitor
!    -2   means the search is going back down a branch
!     2   temporary status as a descendant
!   100   temporarily in a candidate trajectory
! 
! GLOSSARY
!Acc_min -- this is NOT the actual acceleration.  It is the size of the descendant search area.  
!Acc_max -- this is NOT the actual acceleration.  It is the size of the descendant search area.  
!Acc_min_reference  -- used to keep track of original Acc_min during adjustment of search angle for conc
!Acc_max_reference  -- used to keep track of original Acc_max during adjustment of search angle for conc
!alpha  -- dummy parameter; exponent of prog_search_Velocity_in_mps equation
!angle_along_traj(real_trajectory_no, location_in_candidate_trajectory)   -- angle (direction of velocity vector) of a particle at the time of a centroid along its trajectory
!angle_candidate    -- angle of candidate centroid; between c0-cc and c0-c2
!angle_jitter   -- caused by error in detection of actual centroid location.  
!                  Angle of search area must always be larger than.
!answer -- parameter used as answer to question "is centroid in decsendant search area"
!answer_distance    -- used only during subrountine for descendant search
!base   -- number for the base in eqn's to adjust search parameters
!candidate_first_descendant -- just what it says
!candidate_progenitor   -- candidate progenitor
!candidate_trajectory_no    --
!candidate_trajectory_centroid(candidate_trajectory_no, location_in_candidate_trajectory)  -- centroid number at a location in a candidate trajectory
!candidate_trajectory_total_length(candidate_trajectory_no)    -- total length of a candidate trajectory in centroids (times/frames)
!centroid_no() -- a number assigned by Trajectory_Identification.f90 to each centroid an the centroid file produced by ImageJ
!color  -- for drawing velocity vectors pseudocolored with velocity magnitude
!c0 -- centroid at time 0 in a set of three centroids forming the descendant search area
!c1 -- centroid at time 1 
!c2 -- centroid at time 2, the time of the descendant search area
!c3 -- centroid used in determining speed and angle values along a real trajectory
!cc -- candidate centroid being tested to see if it is in the descendant search area
!ci -- imaginary centroid added when a centroid is not found in the descendant search area along a cand traj.  
!      Only one can be added per candidate trajectory.
!c0_at_time(location_in_candidate_trajectory)  -- first centroid in a group of three centroids forming the descendant search area during tree growing
!c1_at_time(location_in_candidate_trajectory)  -- second centroid in a group of three centroids forming the descendant search area during tree growing
!cc_at_time(location_in_candidate_trajectory)  -- candidate centroid to be tested for location in descendant search area during tree growing
!conc_fraction_at_which_to_apply_stricter_search_parameters -- just what it says
!decrease_DSA_with_particle_concentration; set to 1 if we want to decrease DSA size with relative_particle_concentration
!direction_along_path   -- during descendant searches
!distance_0_to_1    -- distance between c0 and c1 in descendant search (all distance units in program are in pixels)
!distance_1_to_2    -- distance between c1 and c2 in descendant search
!distance_0_to_cc   -- distance between c0 and cc in descendant search 
!dummy(centroid_no)    -- just a dummy array used to read an unnecessary column in the particle area file produced by ImageJ
!Feret_Diameter(ic) -- input from ImageJ Particle Analyzer
!first_centroid_in_frame(frame_no) -- just what it says it is.  Used for ranging through centroids of a frame.
!frame_no_of_a_centroid(centroid)    -- number of frame that a centroid is in
!frame -- not used as a parameter, I think
!frame_of_centroid_before_this_one
!ic -- usually is a centroid, with the name standing for "integer centroid"
!last_centroid_in_frame(frame_no) -- just what it says it is.  Used for ranging through centroids of a frame.
!location_in_candidate_trajectory
!longest_candidate_trajectory_no    -- when all candidate traj's are found for a p-c1 pair, this is the no of the longest traj
!length_of_longest_trajectory    -- used during search for longest candidate trajectory
!loop_number    -- number of loops through incrementing of prog_search_Velocity_in_mps
!min_prog_search_Velocity_in_mps -- starting value for iteration of prog_search_Velocity_in_mps
!max_prog_search_Velocity_in_mps  -- final value for iteration of prog_search_Velocity_in_mps
!p  -- progenitor centroid
!Particle_Perimeter(ic) -- from ImageJ Particle Analyzer
!position_of_centroid_in_trajectory(location_in_trajectory)    -- used for post-processing real trajectories
!real_trajectory_no    -- Real trajectories are found during the program execution.  This is the number assigned to each real trajectory.
!real_trajectory_total_length(real_trajectory_no)  -- total length of a real trajectory in centroids (times/frames)
!real_trajectory_centroid(candidate_trajectory_no, location_in_real_trajectory)  -- centroid number at a location in a real trajectory
!real_trajectory_centroid_status(centroid_no)    -- status of a centroid in a real_trajectory during search process. Used to eliminate centriods from searching and for imaginary centroid process
!real_trajectory_no_of_centroid(1000000)
!search_area_translational  -- length of descendant search area along line c0-c2. used only for debugging
!search_area_angular    -- angle of search area; half angle; used only for debugging; all angles in radians
!search_angle_reference -- used to keep track of original search angle during adjustment of search angle for conc
!speed_along_traj(real_trajectory_no, location_in_candidate_trajectory)   -- speed (magnitude of velocity vector) of a particle at the time of a centroid along its trajectory
!status_centroid(centroid_no)    -- status of a centroid during search process. Used to eliminate centriods from searching and for imaginary centroid process
!total_number_of_loops  -- for incrementing prog_search_Velocity_in_mps
!t  -- the time of the search area during the tree growing process
!t1 -- time of the progenitor frame during search process
!tc -- usually means "trajectory centroid" i.e. the centroid along a trajectory
!tt -- time during descendant search in reference to t1 (so tt is never longer than max_length_of_a_real_trajectory
!temp_t1    -- dummy parameter
!total_no_real_trajectories -- 
!use_additional_exogenous_criteria_for_real_trajs -- value is either 0 or 1; tells whether or not to use the code for this, mainly Additional_Exogenous_Criteria_for_Real_Trajs.F90
!use_cluster_bimodal_analysis -- value either 0 or 1;  0 means don't use the code
!x(centroid_no)
!x_speed_along_traj -- x-component of velocity for each particle in each frame that has been found in a real trajectory (includes sign +/- to indicate direction)
!y(centroid_no)
!y_speed_along_traj -- y-component of velocity for each particle in each frame that has been found in a real trajectory (includes sign +/- to indicate direction)
!prog_search_Velocity_in_mps    -- Velocity used to calculate progenitor search area.  It is iterated.