module declarations_section

contains
implicit none
!-----------------declarations----------------------

!--------------- ARRAYS-----------------------------
! ************** IMPORTANT: WHEN VALUE OF TOTAL_NUMBER_OF_CENTROIDS IS CHANGED *****************
! IT MUST ALSO BE MANUALLY CHANGED IN THE FILE 'declaration_of_variables_appearing_in_module_subroutines.f90'

integer, parameter :: TOTAL_NUMBER_OF_CENTROIDS = 100000
integer, parameter :: TOTAL_NUMBER_OF_FRAMES = 375
integer, parameter :: TOTAL_NUMBER_OF_REAL_TRAJECTORIES = 500000
integer, parameter :: MAXIMUM_TRAJECTORY_LENGTH = 100
integer, parameter :: MAXIMUM_CANDIDATE_TRAJECTORIES = 500000

! ^^^^^^^^^^^^^^^^^^^ Large Arrays ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
! The following two dimensional arrays take up the most memory.
!integer real_trajectory_centroid( TOTAL_NUMBER_OF_REAL_TRAJECTORIES , MAXIMUM_TRAJECTORY_LENGTH )  !(real_trajectory_no, location_in_candidate_trajectory)
!real            speed_along_traj( TOTAL_NUMBER_OF_REAL_TRAJECTORIES , MAXIMUM_TRAJECTORY_LENGTH )
!real            angle_along_traj( TOTAL_NUMBER_OF_REAL_TRAJECTORIES , MAXIMUM_TRAJECTORY_LENGTH )  !(real_trajectory_no, location_in_candidate_trajectory)

! FS 2-2-10: To put arrays into the "heap" memory above the 2 GB "stack" memory, Intel suggested making allocating the large arrays as follows:
! Then the arrays are allocated after the end of the declaration section, at the beginning of executable statements.
integer, allocatable :: real_trajectory_centroid( :, :)
real, allocatable    :: speed_along_traj( :,: )
real, allocatable    :: angle_along_traj( :,: )

! Need to set location_in_candidate trajectory >= max_length_real_traj !
! And candidate_trajectory_no should reset to zero for each next 1st descendant, so it should be the max no cand_traj that can occur in a frame
integer candidate_trajectory_total_length(-1:MAXIMUM_CANDIDATE_TRAJECTORIES) ! argument=candidate_trajectory_no, which should be reset to 0 after each 1st desc
integer candidate_trajectory_centroid(-1:MAXIMUM_CANDIDATE_TRAJECTORIES, MAXIMUM_TRAJECTORY_LENGTH+10) !arguments= (candidate_trajectory_no, location_in_candidate_trajectory) location_in_candidate_trajectory should always be less than max_length_real_traj
integer candidate_trajectory_tree !(candidate_progenitor, candidate_trajectory_no, MAXIMUM_TRAJECTORY_LENGTH+10 )
real memory_required_by_largest_arrays                                  


! I commented out the following arrays for clusters because the image size was causing a LNK1248 error.  
!real    x_speed_along_trajectory_for_cluster(350000,100), y_speed_along_trajectory_for_cluster(500000,100)
!real    x_slip_speed_cluster(350000,100), y_slip_speed_cluster(350000,100)
!real    x_speed_along_trajectory_for_cluster(500000,100), y_speed_along_trajectory_for_cluster(500000,100)
!real    x_slip_speed_cluster(500000,100), y_slip_speed_cluster(500000,100)
!real    X_collisional_time_constant(500000,100), Y_collisional_time_constant(500000,100)

! ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ ARRAY DECLARATION SECTION ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
real    avg_speed_of_traj(TOTAL_NUMBER_OF_REAL_TRAJECTORIES), avg_angle_of_traj(TOTAL_NUMBER_OF_REAL_TRAJECTORIES) !(real_trajectory_no)
integer real_trajectory_total_length(TOTAL_NUMBER_OF_REAL_TRAJECTORIES) !(real_trajectory_no)
!real    Avg_particle_area_for_trajectory(TOTAL_NUMBER_OF_REAL_TRAJECTORIES), Avg_particle_perimeter_for_trajectory(TOTAL_NUMBER_OF_REAL_TRAJECTORIES), Avg_particle_feret_dia_for_trajectory(TOTAL_NUMBER_OF_REAL_TRAJECTORIES)


! Particle Centroid, Size, and Trajectory Position Arrays
!_____________________________________________________________________________________________________________________________________________
include 'declaration_of_variables_appearing_in_module_subroutines.f90'  ! Set dimensions of arrays x, y, status_centroid, frame_no_of_a_centroid
!_____________________________________________________________________________________________________________________________________________

! The dimensions of the following arrays are the max number of centroids in a centroid list:                  
integer centroid_no(-1:TOTAL_NUMBER_OF_CENTROIDS)
integer real_trajectory_no_of_centroid(-1:TOTAL_NUMBER_OF_CENTROIDS), position_of_centroid_in_trajectory(-1:TOTAL_NUMBER_OF_CENTROIDS) 
!real    Particle_Area(-1:TOTAL_NUMBER_OF_CENTROIDS), Particle_Perimeter(-1:TOTAL_NUMBER_OF_CENTROIDS), Feret_Diameter(-1:TOTAL_NUMBER_OF_CENTROIDS) ! I have used these only for the cluster analysis

! The following arrays have dimension of the max generations in a centroid tree, which is set in the exogenous_input file.  Leave at 1000 since making smaller won't make any difference.
integer c0_at_time(-1:1000), c1_at_time(-1:1000), cc_at_time(-1:1000) 

! The following arrays have dimensions of the max number of frames in a cine file.  Max I have taken so far is around 200,000.
integer no_centroids_in_frame(TOTAL_NUMBER_OF_FRAMES) ! (total number of frames)
integer no_real_trajectories_frame(TOTAL_NUMBER_OF_FRAMES) !, frame_no_of_imaginary_centroid(5100)
integer first_centroid_in_frame(TOTAL_NUMBER_OF_FRAMES), last_centroid_in_frame(TOTAL_NUMBER_OF_FRAMES) ! (total number of frames)
real  area_of_frame_covered_by_particle_images(TOTAL_NUMBER_OF_FRAMES), Relative_Particle_Concentration(TOTAL_NUMBER_OF_FRAMES)
real  solids_area_fraction(TOTAL_NUMBER_OF_FRAMES)
integer no_velocity_vectors_this_frame(TOTAL_NUMBER_OF_FRAMES) 
! some post processing parameters added at Ron Breault's request

! this cannot be allocated during runtime because a range must be specified to handle negative centroid numbers for imaginary centroids
integer lower_bound, upper_bound, LB(1), UB(1)
! ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ End of ARRAY DECLARATION SECTION ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

real    x_speed_along_traj, y_speed_along_traj  ! not storing values in these arrays saves lots of memory!
real area_fraction_at_maximum_packing
integer order_of_polynomial_for_curve_fitting_trajectories, max_no_of_cand_traj_allowed

integer real_trajectory_of_min_speed, frame_no_of_min_speed, real_trajectory_passed
integer real_trajectory_of_max_speed, frame_no_of_max_speed
integer no_cand_traj_this_tree, cand_traj_i
!----------------------------------------------------
real  distance_between_centroids, distance_between_3_centroids, distance_1_to_cc, distance_0_to_c, distance_p_to_c, c, distance_p_to_cc
real distance_to_detect_very_slow_particles, max_distance_between_cent_of_a_traj
integer real_trajectory_no, position_in_real_trajectory, actual_real_trajectories
!------------ define types for functions -----------

!-------exogenous parameters------------------------
integer holder_for_total_number_of_centroids
real  dt !time between frames in microseconds
real  width_fov, height_fov, fov_width_scale, fov_height_scale, fov_scale  ! fov 
real  search_angle, search_angle_start, search_angle_end  ! max angle to define search area for tangential velocity
real  min_prog_search_Velocity_in_mps, prog_search_Velocity_in_mps, v_inc_ms, prog_search_Velocity
real  exponent_search_velocity, max_prog_search_Velocity, max_prog_search_Velocity_in_mps  ! maximum velocity that could occur in flow field
real  Acc_min, Acc_max, Acc_real, Acc_min_start, Acc_min_end, Acc_max_start, Acc_max_end ! min and max acceleration for translational velocity
real  r_min, r_max, vmin, vmax
real vmin_manually, vmax_manually
integer set_velocity_range_for_pseudocoloring_manually
integer  max_no_centroids_per_frame, total_no_centroids, total_no_frames, number_of_frames_to_analyze, number_of_centroids_to_be_analyzed, starting_frame_for_analysis
integer last_frame, total_number_of_imaginary_centroids, new_imaginary_centroid_in_real_traj
integer  min_length_real_traj, max_length_real_traj, max_no_images_across_fov
real length
real max_particle_concentration, particle_diameter, total_pixel_area, total_pixel_area_of_a_camera_frame, scaling_factor_for_area_covered_by_particles
real max_fraction_of_frame_covered_by_particle_area, max_area_of_frame_covered_by_particle_images
real cross_sectional_area_of_a_particle
real pseudocolor_factor, min_average_speed_along_a_trajectory, max_average_speed_along_a_trajectory, v_range
real angle_between_centroid_pair_along_traj, criterion_1, criterion_2
real size_dividing_between_individual_particles_and_clusters ! specific additional criterion to eliminate candidate trajectories from PSRI case
integer debug, no_columns_in_Centroid_input_for_Traj_Ident_file
! Special exogenous input for Mine Zantow
integer start_of_oscillating_region, end_of_oscillating_region ;

! Switches to use different code features;
character(3) use_additional_exogenous_criteria_for_real_trajs, Use_particle_size_and_cluster_size_analysis
character(3) reject_this_candidate_trajectory
character write_additional_MTrackJ_files
integer found_at_least_one_good_candidate_traj, apply_criteria_always
integer decrease_DSA_with_particle_concentration

!-----------centroid and trigonometry parameters-----
real velocity_0_to_1, velocity_1_to_cc, velocity_0_to_cc, cumulative_speed, cumulative_angle
real total_cumulative_speed_this_frame, total_cumulative_angle_this_frame, speed_temp, angle_temp
integer  no_centroids_this_frame
real xp,yp,x0,y0,x1,y1,x2,y2,x3,y3,x4,y4,xc,yc, xi, yi
real x_intersection, y_intersection, DelM, DelMInv; !for find_intersection_two_lines
real x_a,y_a,x_b,y_b,x_c,y_c,side_a,side_b,side_c,temp
integer first_centroid, second_centroid

!-------------- search parameters
character answer  !Default if length is not specified is 1, so yes=y and no=n
character(3) answer1, A_temp
character(6) color

integer longest, length_of_longest_trajectory, longest_candidate_trajectory_no, candidate_passes
integer  p, c0, c1, c2, c3, cc, ci, imaginary_centroid, no_imaginary_centroids_in_real_trajs
integer frame, candidate_progenitor, candidate_first_descendant
integer t, t1, tt, temp_t1, itemp_t, frame1_temp, frame1, last_cc, first_cc, last_tc, previous_cc
integer total_no_real_trajectories, candidate_trajectory_no, location_in_candidate_trajectory, direction_along_path
integer min_length_real_traj_start, min_length_real_traj_end,max_length_real_traj_start, max_length_real_traj_end
integer averaging_length_for_velocity_vector
!integer found_at_least_one_good_candidate_traj
real difference_between_search_angle_and_actual_angle
real angle_candidate, answer_distance, distance_0_to_1, distance_1_to_2, distance_0_to_cc 
real search_area_translational, search_area_angular, factor, scale_factor, reduction_in_search_parameters_at_max_conc
real search_angle_reference, Acc_min_reference, Acc_max_reference;
real alpha, loop_number, total_number_of_loops, base, angle_jitter
real conc_fraction_at_which_to_apply_stricter_search_parameters

real total

!----------misc dummy parameters and counters----------
integer centroid_counter, counter1, centroid_counter1, centroid_counter2, next_centroid, frame_counter, next_frame, frame_number  !counters for do loops etc
integer i, j, k, ic, ic1, ct, jc, kc, lc, tc, rt, time1, temp_ic, tempi, i_test, p_test, itemp0, itemp1, itemp2, itemp3, itemp_c, itemp_cc, itempt, temp_p
integer cc_temp, istart, iend, itemp, ic_next, icc, icc_next
real dummy, dummy1, dummy2, dummy3, dummy4, dummy5,  y1_temp,  y2_temp,  y3_temp
real rtemp, rtemp0, rtemp1, rtemp2, rtemp3, rtemp4, rtemp_c, rtemp_t, delta_dx, delta_dy, delta_dx_entire_traj, delta_dy_entire_traj, inverted_y, x_temp
real spd, temp_max_velocity, first_velocity, last_velocity,velocity_gradient_for_this_trajectory
real delt_x, delt_y, delt_r, degree_traj, skip, x_spd, y_spd, variance_speed, cumulative_variance_speed, distance_between_consecutive_centroids

! some frame counting parameters
integer frame_of_first_centroid_in_this_trajectory, frame_of_centroid_before_this_one, no_particles_in_frame
integer  temp_cc, first_frame_of_this_real_trajectory, no_consecutive_frames_with_no_centroids, frame_with_no_centroids
real     sign_of_trajectory_speed

!--------------- timing parameters --------------------
real start_tree_growing, finished_tree_growing, tree_growing_time, start_prog_search_V_loop, end_prog_search_V_loop, start_progenitor_loop_5, end_progenitor_loop_5, elapsed_time_for_this_prog, end_1st_desc_loop_10, elapsed_time_for_this_1st_desc
real start_1st_desc_loop_10, end_frame_loop_2, elapsed_time_for_this_frame, start_frame_loop_2, elapsed_time_for_this_search_Velocity
character(8) fs_date; character(5) fs_zone; character(10) fs2_time; ! variables to time program with
integer fs_values(8)
real fs_time, time_into_tree_growing, time_out_of_tree_growing, time_in_tree_growing_process
real time_for_progenitor, start_time, finish_time, elapsed_time
real start_frame_time, end_frame_time, elapsed_time_for_frame, start_calc_time, total_elapsed_time
real start_progenitor_time, end_progenitor_time, elapsed_time_for_progenitor
real start_first_descendant_time, end_first_descendant_time, elapsed_time_first_descendant
real start_descendant_time, end_descendant_time, elapsed_descendant_time
real start_candidate_first_descendant_time, elapsed_time_for_first_descendant
real start_cc_time, found_cc_time, elapsed_cc_time, last_cc_time
real start_candidate_trajectory_time, finished_candidate_trajectory_time, total_candidate_trajectory_time
real start_ci_time, end_ci_time, failed_ci_time, total_ci_time, add_ci_time

! Calc mean and fluct comp section

real cumulative_Vx_minus_Vmean_squared, cumulative_Vy_minus_Vmean_squared, cumulative
real cumulative_Vx_minus_Vmean_squared_for_ke_regime, cumulative_Vy_minus_Vmean_squared_for_ke_regime, cumulative_Vx_minus_Vmean_squared_for_GT_regime, cumulative_Vy_minus_Vmean_squared_for_GT_regime
real Vx_minus_Vmean, Vy_minus_Vmean
      
! Balaji changes start here
real xtempo(5000000), ytempo(5000000) , fitted_x(5000000), fitted_y(5000000)  
 
end module