! Read Exogenous parameters for Trajectory_Identification
! All units in pixels, seconds.  ! Use pixels for distance units!!!!!!!

include 'skip_2_lines_during_read.f90'
call cpu_time(start_time); 
write(*,81321) start_time; write(535,81321) start_time; 81321 format(/,' ---------------------------------------------------',/,' This run started at ',f8.3,' seconds') 
! Write out estimated memory size required by largest arrays
memory_required_by_largest_arrays = ( 3 * ( TOTAL_NUMBER_OF_REAL_TRAJECTORIES * MAXIMUM_TRAJECTORY_LENGTH ) + & 
                                    5 * TOTAL_NUMBER_OF_CENTROIDS + &
                                    10 * number_of_frames_to_analyze ) &
                                    * 64/8
memory_required_by_largest_arrays = memory_required_by_largest_arrays / 1e6
write(535,6535) ; 6535 format('******************* Memory Usage *********************');
write(*,880) memory_required_by_largest_arrays ; write(535,880) memory_required_by_largest_arrays ; 880 format(/,'memory_required_by_largest_arrays =',f13.2,' MegaBytes')              
memory_required_by_largest_arrays = memory_required_by_largest_arrays / 1e3
write(*,881) memory_required_by_largest_arrays ; write(535,881) memory_required_by_largest_arrays ; 881 format('memory_required_by_largest_arrays =',f13.2,' GigaBytes',/)

! Enter camera and video parameters
print*,' '; print*,'******************** Camera Setup Parameters ********************** '; 
read(50,*) starting_frame_for_analysis, number_of_frames_to_analyze; print*,'Analyzing ',number_of_frames_to_analyze,' frames starting with frame ',starting_frame_for_analysis
read(50,*) dt; frame_rate=1/dt; print*,'Frame rate is ',frame_rate,' frames per sec and time between frames is',dt*1e6,' microseconds'; print*,' ';
read(50,*) x_pixels, y_pixels ;         write(*,321) x_pixels,y_pixels; 321 format(' Field-of-view resolution: x_pixels=',f5.0': y_pixels=',f5.0)
read(50,*) width_fov, height_fov;       print*,'Field-of-view size: width=',width_fov*1000,' mm: height=',height_fov*1000,' mm'; !print*,' '
read(50,*) particle_diameter ;          print*,'particle_diameter =',particle_diameter*1e6,' microns' ; print*,' '
include 'skip_2_lines_during_read.f90'

! Read array sizes
!read(50,*) holder_for_total_number_of_centroids;
read(50,*) TOTAL_NUMBER_OF_CENTROIDS ; 
read(50,*) TOTAL_NUMBER_OF_REAL_TRAJECTORIES 
read(50,*) MAXIMUM_TRAJECTORY_LENGTH
read(50,*) MAXIMUM_CANDIDATE_TRAJECTORIES
print*,'TOTAL_NUMBER_OF_CENTROIDS=',TOTAL_NUMBER_OF_CENTROIDS
print*, 'number_of_frames_to_analyze=',number_of_frames_to_analyze,'  TOTAL NUMBER REAL TRAJs=',TOTAL_NUMBER_OF_REAL_TRAJECTORIES;
print*,'MAX TRAJ LENGTH=',MAXIMUM_TRAJECTORY_LENGTH,' MAX CAND TRAJ=',MAXIMUM_CANDIDATE_TRAJECTORIES;
pause
include 'skip_2_lines_during_read.f90'

! Read search parameters
print*,' '; print*,'******************** Search Parameters ********************** '; 
read(50,*) min_prog_search_Velocity_in_mps, max_prog_search_Velocity_in_mps; 
read(50,*) total_number_of_loops, exponent_search_velocity;      write(*,322) min_prog_search_Velocity_in_mps, max_prog_search_Velocity_in_mps, total_number_of_loops, exponent_search_velocity; 322 format(' minimum search velocity (m/s)=',f10.6,': maximum search velocity (m/s)=',f7.2,': no increments',f5.0, ' exp_search=',f5.2)
read(50,*) search_angle_start, search_angle_end;                 write(*,156) search_angle_start*57.295779, search_angle_end*57.295779; 156 format(' search_angle_start= ',f7.3,'     search_angle_end= ',f6.3,' degrees')
read(50,*) Acc_min_start,   Acc_min_end;                         write(*,157) Acc_min_start, Acc_min_end;                                      157 format('      Acc_min_start= ',f7.3,'          Acc_min_end= ',f6.3)
read(50,*) Acc_max_start,   Acc_max_end;                         write(*,158) Acc_max_start, Acc_max_end;                                      158 format('      Acc_max_start= ',f7.3,'          Acc_max_end= ',f6.3)
read(50,*) base;                                                 print*,'base for exp decay of search velocity=',base ; print*,' '
read(50,*) min_length_real_traj_start, min_length_real_traj_end; print*,'starting and ending value for min traj length',min_length_real_traj_start, min_length_real_traj_end
read(50,*) max_length_real_traj_start, max_length_real_traj_end; print*,'starting and ending value for max traj length',max_length_real_traj_start, max_length_real_traj_end;
read(50,*) distance_to_detect_very_slow_particles ;              print*, 'distance_to_detect_very_slow_particles =',distance_to_detect_very_slow_particles,'  pixels';
read(50,*) decrease_DSA_with_particle_concentration ;            print*,"decrease_DSA_with_particle_concentration=",decrease_DSA_with_particle_concentration;
read(50,*) reduction_in_search_parameters_at_max_conc;           print*,'reduction_in_search_parameters_at_max_conc=',reduction_in_search_parameters_at_max_conc; print*,' '
read(50,*) max_no_of_cand_traj_allowed;                          print*,"max_no_of_cand_traj_allowed=",max_no_of_cand_traj_allowed;
include 'skip_2_lines_during_read.f90'
read(50,57) use_additional_exogenous_criteria_for_real_trajs ; 57 format(A3);
if(use_additional_exogenous_criteria_for_real_trajs .eq. 'Yes') then
   print*, 'use_additional_exogenous_criteria_for_real_trajs ? = ',use_additional_exogenous_criteria_for_real_trajs;  
end if
! Read parameters for post analysis of trajectories, Curve fitting trajectories
read(50,*) max_distance_between_cent_of_a_traj;                   print*,"max_distance_between_cent_of_a_traj=",max_distance_between_cent_of_a_traj;
print*,'C';
read(50,*) apply_criteria_always; ! Apply additional special criteria only to centroids found within search areas (=0), or even if centroid not found in descendant search area (=1)?
if(apply_criteria_always .gt. 0) then; 
   print*, 'apply_criteria_always = ',apply_criteria_always, ' meaning that additional special criteria are applied even if centroids are not found in a search area.'; 
else;
   print*, 'apply_criteria_always = ',apply_criteria_always, ' meaning that additional special criteria are only applied if centroids are not found in a search area.'; 
end if;
read(50,*) criterion_2
if(use_additional_exogenous_criteria_for_real_trajs .eq. 'Yes') print*,'criterion_1: ',criterion_1
read(50,*) order_of_polynomial_for_curve_fitting_trajectories; print*,'order_of_polynomial_for_curve_fitting_trajectories =',order_of_polynomial_for_curve_fitting_trajectories
include 'skip_2_lines_during_read.f90'

! Read parameters for MTrackJ data file
read(50,*) set_velocity_range_for_pseudocoloring_manually ; 
read(50,*) vmin_manually, vmax_manually !, pseudocolor_factor ; 
read(50,58) write_additional_MTrackJ_files ;  
if(write_additional_MTrackJ_files .eq. 'Y') then
   print*, 'Additional MTrackJ files separated by velocity magnitudes will be written'  
end if

58 format(A3);
include 'skip_2_lines_during_read.f90'

! Create additional output files for debugging ?  (Creates very large files so run for minimum necessary frames!)
print*, ' '
read(50,*) debug; if(debug .eq. 1) then; print*,' '; print*, 'DEBUGGING IS ON'; print*,' '; else;  print*, 'Debugging is off';end if
read(50,*) no_columns_in_Centroid_input_for_Traj_Ident_file; print*,'Reading from Centroid_input_for_Traj_Ident.txt file with ',no_columns_in_Centroid_input_for_Traj_Ident_file,' columns.'

! read(50,*) averaging_length_for_velocity_vector ! I set this to a constant in the Trajectory_Identification code.  This needs to be implemented in the Standalone_Post_Processing step only.
averaging_length_for_velocity_vector = 0;

fov_width_scale = width_fov/x_pixels; fov_height_scale= height_fov/x_pixels  ! fov scale in meters/pixel 
fov_scale = width_fov/x_pixels  ! use this if pixels are square, units are meters/pixel             

136 format (a3); ! this is needed for the "skip_line" code
