! ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
! ^^^^^^^^^^^^^^^^^^^^^ Write all values needed for Standalone_Post_Processing.f90 after run is finished ^^^^^^^^^^^^^^^^^^^^^
! ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
! Write the values along each real trajectory to "raw_data_by_trajectory_for_post_processing.txt"
write(610,*) total_no_real_trajectories
do real_trajectory_no = 1, total_no_real_trajectories 
   write(610,*) real_trajectory_no, real_trajectory_total_length(real_trajectory_no)
   do tc = 1 , ( real_trajectory_total_length(real_trajectory_no) ) ! scan of length of a real trajectory
     ! Returns the value for "frame_containing_real_or_imaginary_centroid(cc)" for any tc of a real trajectory
      cc = real_trajectory_centroid(real_trajectory_no,tc) ! The centroid number of this centroid along the traj     
     ! This used to write to raw_data_by_trajectory_for_post_processing.txt, but the data is exactly the same in 'speed_and_angle_along_traj.txt' so use that instead    
     if( tc .lt. real_trajectory_total_length(real_trajectory_no) ) then
        write(610,4002) real_trajectory_no,  tc,   frame_no_of_a_centroid(cc),  cc, x(cc), y(cc), speed_along_traj(real_trajectory_no,tc),angle_along_traj(real_trajectory_no,tc)*57.295779
     else ! Don't write speed and angle for last centroid in a traj
        write(610,4002) real_trajectory_no,  tc,   frame_no_of_a_centroid(cc),  cc, x(cc), y(cc)
     end if
     4002 format(        i7,',',            2x,i7,','       ,2x,i7,',',                1x,i9,',',  2(2x,f8.1,','),  5x,f13.7,',',5x,f13.7   ) ;   
   end do
end do


