! calc_fluctuating_components_for_frames.f90
! ******************* Now calculate fluctuating components of velocities for this frame *********************
! ************* Note that the fluctuating components of velocity are calculated two ways: *******************
! ************* using the total mean and using a local frame average  ***********

! Loop through frames and calculate fluctuating velocities, fluctuating energies for each frame
! See the MS Word file " " in this folder for a derivation of these parameters
do frame=1, number_of_frames_to_analyze
   include 'reset_counting_parameters_for_next_frame.f90'
   ! Disregard this frame and don't do any calc for it if it doesn't have enough vectors in nearby frames for a good avg
   ! Or, if it doesn't have any velocity vectors, don't do any calc for it
   !if (does_frame_have_enough_vectors_nearby_for_good_avg(frame) .gt. 0.1 .and. no_velocity_vectors_this_frame(frame) .gt. 0) then   

   if (no_velocity_vectors_this_frame(frame) .gt. 0) then   
      ! Loop through centroids (velocity vectors) in the averaging window around thisframe, calculate fluct velocity for each based on total mean and frame averaged mean  
      expanded_window_half_width = (expanded_avg_window_for_local_avg_vel_by_frame(frame) + 1)/2 -1
      ! Count the number of velocity vectors in this averaging window
      first_frame_of_averaging_window = (frame - expanded_window_half_width); last_frame_of_averaging_window = (frame + expanded_window_half_width) 
      if ( first_frame_of_averaging_window .le. 0 ) first_frame_of_averaging_window = 1
      if ( last_frame_of_averaging_window  .ge. number_of_frames_to_analyze ) last_frame_of_averaging_window = number_of_frames_to_analyze
      
      do window_frame = first_frame_of_averaging_window , last_frame_of_averaging_window
         cc = first_centroid_in_frame(window_frame)   ; 
         do while ( cc .le. last_centroid_in_frame(window_frame) )
            if ( is_centroid_in_a_real_trajectory(cc) .gt. 0 ) then  ! only use centroids that are actually in a trajectory          
               real_trajectory_no = real_trajectory_no_of_centroid(cc);  tc = position_of_centroid_in_trajectory(cc)
               if ( tc .ne. real_trajectory_total_length(real_trajectory_no) .and. local_avg_of_Y_velocity(window_frame) .ne. 0) then   ! Balaji change Add if statement for last centroid of trajectory
                  !Balaji Change 18/07 remove data for cases where we do not have enough particles (modified if statement to include non zero mean velocity )                 
                  
                  ! Calc fluctuating components of velocity for velocities in this frame using two different means           
                  individual_part_X_vel_minus_local_avg_X_vel =    x_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc) - local_avg_of_X_velocity(frame) 
                  individual_part_Y_vel_minus_local_avg_Y_vel =    y_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc) - local_avg_of_Y_velocity(frame)
               
                  !!!!!!!!!!! Add an if statement here to remove bad GT!!!!!!!!!!!!!!!!!!!!!!!
                  
                  
                  individual_particle_X_vel_minus_total_mean_vel = x_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc) - total_mean_X_velocity_for_all_frames 
                  individual_particle_Y_vel_minus_total_mean_vel = y_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc) - total_mean_Y_velocity_for_all_frames
               
                  sum_of_squares_of_Vx_minus_local_avg = sum_of_squares_of_Vx_minus_local_avg + individual_part_X_vel_minus_local_avg_X_vel**2
                  sum_of_squares_of_Vy_minus_local_avg = sum_of_squares_of_Vy_minus_local_avg + individual_part_Y_vel_minus_local_avg_Y_vel**2

                  sum_of_squares_of_Vx_minus_total_mean_Vx = sum_of_squares_of_Vx_minus_total_mean_Vx + individual_particle_X_vel_minus_total_mean_vel**2
                  sum_of_squares_of_Vy_minus_total_mean_Vy = sum_of_squares_of_Vy_minus_total_mean_Vy + individual_particle_Y_vel_minus_total_mean_vel**2                                            
               end if                                                            ! Balaji change Add if statement 
            end if
            cc = cc + 1  
         end do ! end of do loop to loop through velocity vectors for this frame
      end do  ! end of do loop to loop through averaging window
      
      ! Write output files for individual particle velocity
      include 'Write_velocity_and_fluctuating_component_for_frames.f90' ! Balaji change include the write file within if statement            
     
      ! Now calculate fluctuating components of velocity for each frame, but using expanded averaging window based on the min no vectors required for a good local average
      ! The reason that an expanded window must be used, is that there are not enough vectors in each frame to get a "good" fluctuating component, and GT, for each frame
      ! E.g., some frames have only one or two vectors.  So that would not give a good, realistic value of the true RMS and GT for that frame      

      ! Calculate fluct components and total fluct energy for all particles
      X_RMS_fluct_comp_vel_using_local_avg_vel(frame) = sqrt( sum_of_squares_of_Vx_minus_local_avg / no_velocity_vectors_in_averaging_window(frame) )
      Y_RMS_fluct_comp_vel_using_local_avg_vel(frame) = sqrt( sum_of_squares_of_Vy_minus_local_avg / no_velocity_vectors_in_averaging_window(frame) )

      X_RMS_fluct_comp_vel_using_total_avg_this_frame(frame) = sqrt( sum_of_squares_of_Vx_minus_total_mean_Vx / no_velocity_vectors_in_averaging_window(frame) )
      Y_RMS_fluct_comp_vel_using_total_avg_this_frame(frame) = sqrt( sum_of_squares_of_Vy_minus_total_mean_Vy / no_velocity_vectors_in_averaging_window(frame) )
      
      X_intensity_of_velocity_fluctuations(frame) = 100 * X_RMS_fluct_comp_vel_using_local_avg_vel(frame) / local_avg_of_X_velocity(frame)
      Y_intensity_of_velocity_fluctuations(frame) = 100 * Y_RMS_fluct_comp_vel_using_local_avg_vel(frame) / local_avg_of_Y_velocity(frame)

      ! Now calculate granular temperature for each frame
      ! For the wall case, use 1/3, for inside a flow field with 3D flow, use 2/3
      ! CHANGE THIS FOR FLOW INSIDE RISER
      Granular_Temp_using_frame_averaged_vel(frame) = 0.333333 * X_RMS_fluct_comp_vel_using_local_avg_vel(frame)**2 + &
                                     0.6667 * Y_RMS_fluct_comp_vel_using_local_avg_vel(frame)**2 

      Granular_Temp_using_total_avg_by_frame(frame) = 0.333333 * X_RMS_fluct_comp_vel_using_total_avg_this_frame(frame)**2 + &
                                     0.66667 * Y_RMS_fluct_comp_vel_using_total_avg_this_frame(frame)**2 

      ! Write to 'Granular_Temp_vs_Relative_Part_Conc_etc_by_frame.txt'
      write(4000,4010) frame, Relative_Particle_Concentration(frame), Granular_Temp_using_frame_averaged_vel(frame), Granular_Temp_using_total_avg_by_frame(frame), &
                    local_avg_of_X_velocity(frame), local_avg_of_Y_velocity(frame), &
                    X_RMS_fluct_comp_vel_using_local_avg_vel(frame), Y_RMS_fluct_comp_vel_using_local_avg_vel(frame),&
                    expanded_avg_window_for_local_avg_vel_by_frame(frame)
      4010 format( i8,8x,f12.7,2(6x,f13.5),4(6x,f13.5),14x,i6) 

      ! Unit 4170 writes to file='..\Standalone_Post_Processing\output\by_frame\Vx_Vy_RPC_time.txt'
      rtemp1 = frame * dt
      write(4170,4171) frame, rtemp1, Relative_Particle_Concentration(frame), local_avg_of_X_velocity(frame), local_avg_of_Y_velocity(frame)
      4171 format(i8,',', 1x,f13.7,',',  1x,f13.5,',',  1x,f13.5 ,',',  1x,f13.5 )
      
      ! Unit 698 writes to "mean_velocity_and_fluctuating_components_by_frame.txt"
      write(698,6700) frame, local_avg_of_X_velocity(frame), local_avg_of_Y_velocity(frame), X_RMS_fluct_comp_vel_using_local_avg_vel(frame), Y_RMS_fluct_comp_vel_using_local_avg_vel(frame)
      6700 format(i6,2x,4(4x,f12.7))
      ! Write to "number_of_velocity_vectors_in_each_frame.txt"
   end if
end do

! Write out with equal time spacing (data for every frame) so FFT's etc can be done
! This forces a write for every frame, even if the frame had no velocity vectors
! If a frame has 0 velocity vectors, then the value of frame avg velocity from the last frame with >0 velocity vectors is used
! !!! THIS NEEDS TO BE EXAMINED TO MAKE SURE IT IS CORRECT !!!
do frame=1, number_of_frames_to_analyze

   ! store the value of the last frame that had more than 1 velocity vectors
   if (no_velocity_vectors_this_frame(frame) .lt. 0.5) then
      rtemp = local_avg_of_X_velocity(frame)
      rtemp1 = local_avg_of_Y_velocity(frame)
      rtemp2 = X_RMS_fluct_comp_vel_using_local_avg_vel(frame) 
      rtemp3 = Y_RMS_fluct_comp_vel_using_local_avg_vel(frame) 
    end if
   
   ! if a frame has no velocity vectors, use the values from the last frame that did:
   if (no_velocity_vectors_this_frame(frame) .lt. 0.5) then   
      local_avg_of_X_velocity(frame) = rtemp
      local_avg_of_Y_velocity(frame) = rtemp1
      X_RMS_fluct_comp_vel_using_local_avg_vel(frame) = rtemp2
      Y_RMS_fluct_comp_vel_using_local_avg_vel(frame) = rtemp3
   end if
   
   write(998,9700) frame, local_avg_of_X_velocity(frame), local_avg_of_Y_velocity(frame), X_RMS_fluct_comp_vel_using_local_avg_vel(frame), Y_RMS_fluct_comp_vel_using_local_avg_vel(frame)
   9700 format(i6,2x,2(4x,f12.7),14x,f12.7,29x,f12.7)

end do

         