! Calc_Mean_and_Fluct_Comp_of_Vel_and_Gran_Temp_Parameters.f90
! &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
! &&&&&&&&&&&&&&&&& Calculate Mean and Fluctuating Components of Velocity by Frame &&&&&&&&&&&&&&&&&&&&&&
! &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
! Calculate number of velocity vectors in each frame for use below in rolling averages section
do frame = 1, number_of_frames_to_analyze
   no_velocity_vectors_this_frame(frame)=0; 
   cc = first_centroid_in_frame(frame)  
   do while ( cc .le. last_centroid_in_frame(frame) )    ! Range through centroids for this frame
      real_trajectory_no = real_trajectory_no_of_centroid(cc)
      tc = position_of_centroid_in_trajectory(cc)
      ! Balaji Change (do not use last part of traj because of zero vel)
         if(real_trajectory_no .gt. 0 .and. tc .gt. 0 .and. tc .lt. real_trajectory_total_length(real_trajectory_no)) then !only calculate if this centroid is in a real trajectory
          ! Recall that x_speed_along_traj includes sign of direction (+/-).  How will the change average if particles are moving in opposite directions?
            no_velocity_vectors_this_frame(frame) = no_velocity_vectors_this_frame(frame) + 1
         end if
         cc = cc + 1
   end do
end do

!----------------------------------------------------
! Now calculate average speed and angle data for each frame
! _________  NOW CALCULATE MEAN PARTICLE VELOCITY FOR EACH FRAME USING EXPANDING AVERAGING WINDOW TECHNIQUE  _________________
! Often there are not enough velocity vectors in each frame to get the true average, so, for each frame, if the frame itself does not have enough velocity vectors fo a good average
! I instead use an average of the velocity vectors in the frame plus a number of surrounding frames.  I keep increasing the number of surrounding frames until I 
! have enough velocity vectors to get a good average.  For now, the number of velocity vectors is an exogenous parameter.
! The rolling averages can be used to calculate fluctuating components and other parameters for which a frame averaged value is needed.
!  Note that the rolling_average_window must be chosen small enough so as to not remove highest frequencies of signal, but long enough to get
! enough values (of velocity vectors for example) to get a true frame average value.
do frame = 1, number_of_frames_to_analyze
   ! reset variables for this frame
   cumulative_X_speed_over_avg_window=0; cumulative_Y_speed_over_avg_window=0; no_velocity_vectors_in_averaging_window = 0
   ! First count the number of velocity vectors in this frame/window.  If not enough, expand size of averaging window until there are enough
   expanded_rolling_average_window = 1
   expanded_window_half_width = (expanded_rolling_average_window + 1)/2 -1
   ! Count the number of velocity vectors in this averaging window size
   first_frame_of_averaging_window = (frame - expanded_window_half_width); last_frame_of_averaging_window = (frame + expanded_window_half_width) 
   do while (no_velocity_vectors_in_averaging_window .lt. enough_velocity_vectors_for_good_average) 
      if ( first_frame_of_averaging_window .lt. 0 ) first_frame_of_averaging_window = 1
      if ( last_frame_of_averaging_window  .ge. number_of_frames_to_analyze ) last_frame_of_averaging_window = number_of_frames_to_analyze
      do temp_frame = first_frame_of_averaging_window , last_frame_of_averaging_window 
         no_velocity_vectors_in_averaging_window = no_velocity_vectors_in_averaging_window + no_velocity_vectors_this_frame(temp_frame)     
      end do
      !Balaji changes start here (the commented portion above has been moved below and modified using the if statement)
      if (no_velocity_vectors_in_averaging_window .lt. enough_velocity_vectors_for_good_average) then
      expanded_rolling_average_window = expanded_rolling_average_window + 2 
      expanded_window_half_width = (expanded_rolling_average_window + 1)/2 -1   
      first_frame_of_averaging_window = (frame - expanded_window_half_width); last_frame_of_averaging_window = (frame + expanded_window_half_width) 
      end if
      !expanded_rolling_average_window = expanded_rolling_average_window + 2 
      !expanded_window_half_width = (expanded_rolling_average_window + 1)/2 -1   
      !first_frame_of_averaging_window = (frame - expanded_window_half_width); last_frame_of_averaging_window = (frame + expanded_window_half_width) 
      !Balaji changes end here
   end do
   ! Now that the size and range of the expanded_averaging_window is determined, calculate the averages for this window of frames
   cumulative_X_speed_over_avg_window=0; cumulative_Y_speed_over_avg_window=0; 
   ! First calculate cumulative values for this averaging window of frames
   do temp_frame = first_frame_of_averaging_window , last_frame_of_averaging_window
      cc = first_centroid_in_frame(frame)
      do while ( cc .le. last_centroid_in_frame(frame) )    ! Range through centroids for this frame
         real_trajectory_no = real_trajectory_no_of_centroid(cc)
         tc = position_of_centroid_in_trajectory(cc)
         if(real_trajectory_no .gt. 0 .and. tc .gt. 0 .and. tc .lt. real_trajectory_total_length(real_trajectory_no)) then !only calculate if this centroid is in a trajectory
            ! Recall that x_speed_along_traj includes sign of direction (+/-).  How will the change average if particles are moving in opposite directions?
         !Balaji changes start here
          cumulative_X_speed_over_avg_window = cumulative_X_speed_over_avg_window + averaged_x_speed_along_traj(real_trajectory_no,tc)
          cumulative_Y_speed_over_avg_window = cumulative_Y_speed_over_avg_window + averaged_y_speed_along_traj(real_trajectory_no,tc)
         ! cumulative_X_speed_over_avg_window = cumulative_X_speed_over_avg_window + x_speed_along_traj(real_trajectory_no,tc)
         ! cumulative_Y_speed_over_avg_window = cumulative_Y_speed_over_avg_window + y_speed_along_traj(real_trajectory_no,tc)
         !Balaji changes end here
         end if
!write(2994,4994) frame, temp_frame, cc,  x_speed_along_traj(real_trajectory_no,tc), y_speed_along_traj(real_trajectory_no,tc), cumulative_X_speed_over_avg_window, cumulative_Y_speed_over_avg_window
!4994 format(i8,5x,i8,5x,i8,4(5x,f10.6))        
         cc = cc + 1
      end do           
   end do 
   ! Now calculate mean values
   mean_velocity_X_component_over_avg_window(frame)= cumulative_X_speed_over_avg_window/no_velocity_vectors_in_averaging_window
   mean_velocity_Y_component_over_avg_window(frame)= cumulative_Y_speed_over_avg_window/no_velocity_vectors_in_averaging_window
   avg_angle_this_frame(frame) = atan(mean_velocity_Y_component_over_avg_window(frame)/mean_velocity_X_component_over_avg_window(frame))
   mean_velocity_this_frame(frame) = sqrt(mean_velocity_X_component_over_avg_window(frame)**2 + mean_velocity_Y_component_over_avg_window(frame)**2)
  ! Balaji changes start here (order corrected)
  ! write(4998,5112) frame, expanded_rolling_average_window, no_velocity_vectors_in_averaging_window, mean_velocity_X_component_over_avg_window(frame), mean_velocity_Y_component_over_avg_window(frame),&
  !                  mean_velocity_this_frame(frame),avg_angle_this_frame(frame)*360/(2.0*3.14159)
   write(4998,5112) frame, expanded_rolling_average_window, no_velocity_vectors_in_averaging_window, mean_velocity_X_component_over_avg_window(frame), mean_velocity_Y_component_over_avg_window(frame),&
                    mean_velocity_this_frame(frame),avg_angle_this_frame(frame)*360/(2.0*3.14159)
  ! Balaji changes end here
   5112 format(i8,9x,i8,20x,i8,3x,4(8x,f10.5) )
   write(4999,3667) frame, expanded_rolling_average_window, no_velocity_vectors_in_averaging_window, cumulative_X_speed_over_avg_window, cumulative_Y_speed_over_avg_window
   3667 format(i7, 10x, i5, 35x, i5, 2(5x,f10.5))
end do

! ************* Now calculate fluctuating components of velocities for this frame *********************
do frame=1, number_of_frames_to_analyze
   cumulative_fluctuating_velocity=0; fluctuating_velocity=0; cumulative_Vx_minus_Vmean_squared=0; cumulative_Vy_minus_Vmean_squared=0
   cumulative_Vx_minus_Vmean_squared_for_ke_regime = 0; cumulative_Vy_minus_Vmean_squared_for_ke_regime =0; cumulative_Vx_minus_Vmean_squared_for_GT_regime = 0; cumulative_Vy_minus_Vmean_squared_for_GT_regime =0;
   no_velocity_vectors_this_frame_ke_regime(frame)=0 ; no_velocity_vectors_this_frame_GT_regime(frame) = 0
   cc = first_centroid_in_frame(frame)   
   write(530,6298) frame; write(531,6298) frame; write(630,6298) frame; write(631,6298) frame; 6298 format(i5,\)
   write(560,6298) frame; write(561,6298) frame; write(660,6298) frame; write(661,6298) frame;
   do while ( cc .le. last_centroid_in_frame(frame) ) 
      real_trajectory_no = real_trajectory_no_of_centroid(cc)
      tc = position_of_centroid_in_trajectory(cc)
         if(real_trajectory_no .gt. 0 .and. tc .gt. 0 .and. tc .lt. real_trajectory_total_length(real_trajectory_no)) then !only calculate if this centroid is in a trajectory
           !Balaji changes start here
         ! Vx_minus_Vmean =   x_speed_along_traj(real_trajectory_no,tc) - mean_velocity_X_component_over_avg_window(frame) 
         ! Vy_minus_Vmean =   y_speed_along_traj(real_trajectory_no,tc) - mean_velocity_Y_component_over_avg_window(frame)
            
            Vx_minus_Vmean =   averaged_x_speed_along_traj(real_trajectory_no,tc) - mean_velocity_X_component_over_avg_window(frame) 
            Vy_minus_Vmean =   averaged_y_speed_along_traj(real_trajectory_no,tc) - mean_velocity_Y_component_over_avg_window(frame)
           !Balaji changes end here  
           
           ! For total fluctuating energy for all particles
            cumulative_Vx_minus_Vmean_squared = cumulative_Vx_minus_Vmean_squared + Vx_minus_Vmean**2
            cumulative_Vy_minus_Vmean_squared = cumulative_Vy_minus_Vmean_squared + Vy_minus_Vmean**2
            
           !Balaji changes start here
         ! rtemp1= x_speed_along_traj(real_trajectory_no,tc)
         ! rtemp2= y_speed_along_traj(real_trajectory_no,tc)            
           
           rtemp1= averaged_x_speed_along_traj(real_trajectory_no,tc)
           rtemp2= averaged_y_speed_along_traj(real_trajectory_no,tc)  
           !Balaji changes end here        

            ! Calculate collisional time constant
            X_collisional_time_constant(real_trajectory_no,tc) = particle_diameter / ( 6 * solids_area_fraction(frame) * Vx_minus_Vmean )
            Y_collisional_time_constant(real_trajectory_no,tc) = particle_diameter / ( 6 * solids_area_fraction(frame) * Vy_minus_Vmean )

            ! To find the time_constant_for_particle_transport, I must calculate a particle velocity gradiant for the next calculation
            ! I will take the first velocity in the trajectory and the last, and divide by the time between the velocities to get the dV/dt
            first_velocity = (averaged_x_speed_along_traj(real_trajectory_no,1)**2.0 + averaged_y_speed_along_traj(real_trajectory_no,1)**2.0 )**0.5                        
            itemp1 = real_trajectory_total_length(real_trajectory_no)-1                                             
            last_velocity = (averaged_x_speed_along_traj(real_trajectory_no,itemp1)**2.0 + averaged_y_speed_along_traj(real_trajectory_no,itemp1)**2.0 )**0.5            
            velocity_gradient_for_this_trajectory = (last_velocity - first_velocity)/ (dt * (itemp1-1))
            c1 = (averaged_x_speed_along_traj(real_trajectory_no,tc)**2+averaged_y_speed_along_traj(real_trajectory_no,tc)**2)**0.5
            time_constant_for_particle_transport = abs (c1 / velocity_gradient_for_this_trajectory)
          !    first_velocity = (x_speed_along_traj(real_trajectory_no,1)**2.0 + y_speed_along_traj(real_trajectory_no,1)**2.0 )**0.5                        
          !  itemp1 = real_trajectory_total_length(real_trajectory_no)-1                                             
          !  last_velocity = (x_speed_along_traj(real_trajectory_no,itemp1)**2.0 + y_speed_along_traj(real_trajectory_no,itemp1)**2.0 )**0.5            
          !  velocity_gradient_for_this_trajectory = (last_velocity - first_velocity)/ (dt * (itemp1-1))
          !  time_constant_for_particle_transport = abs (speed_along_traj(real_trajectory_no,tc) / velocity_gradient_for_this_trajectory)
            ! Balaji changes end here
            
            ! The following statements are to divide the total fluctuating energy into kinetic energy and granular temperature regimes
            ! according to a method provided by Ron Breault
            if ( X_collisional_time_constant(real_trajectory_no,tc) .lt. dt ) then
                cumulative_Vx_minus_Vmean_squared_for_ke_regime = cumulative_Vx_minus_Vmean_squared + Vx_minus_Vmean**2
                cumulative_Vy_minus_Vmean_squared_for_ke_regime = cumulative_Vy_minus_Vmean_squared + Vy_minus_Vmean**2
                no_velocity_vectors_this_frame_ke_regime(frame) = no_velocity_vectors_this_frame_ke_regime(frame)  + 1
            end if 
            
            if ( X_collisional_time_constant(real_trajectory_no,tc) .gt. dt ) then
                cumulative_Vx_minus_Vmean_squared_for_GT_regime = cumulative_Vx_minus_Vmean_squared + Vx_minus_Vmean**2
                cumulative_Vy_minus_Vmean_squared_for_GT_regime = cumulative_Vy_minus_Vmean_squared + Vy_minus_Vmean**2
                no_velocity_vectors_this_frame_GT_regime(frame) = no_velocity_vectors_this_frame_GT_regime(frame)  + 1
            end if 
            
            ! end of section for Ron Breault's method
            
            ! Write the variance of particle velocity from the mean
            write(530,5301) Vx_minus_Vmean;   write(531,5301)  Vy_minus_Vmean;
            write(560,5301) rtemp1 ; write(561,5301) rtemp2 ; 
            write(630,6301) real_trajectory_no, Vx_minus_Vmean;    write(631,6301) real_trajectory_no, Vy_minus_Vmean; 
            write(660,6301) real_trajectory_no, rtemp1;    write(661,6301) real_trajectory_no, rtemp2; 
            !5301 format (',',3x,f9.5,\); 6301 format (',',3x,i7,',',f9.5,\);
             5301 format (' ',3x,f9.5,\); 6301 format (' ',3x,i7,' ',f9.5,\);
            !Balaji changes start here
            !write(730,7301) frame, mean_velocity_X_component_over_avg_window(frame), mean_velocity_Y_component_over_avg_window(frame),&
            !              real_trajectory_no, tc, x_speed_along_traj(real_trajectory_no,tc), y_speed_along_traj(real_trajectory_no,tc), Vx_minus_Vmean, Vy_minus_Vmean
             write(730,7301) frame, mean_velocity_X_component_over_avg_window(frame), mean_velocity_Y_component_over_avg_window(frame),&
                           real_trajectory_no, tc, averaged_x_speed_along_traj(real_trajectory_no,tc), averaged_y_speed_along_traj(real_trajectory_no,tc), Vx_minus_Vmean, Vy_minus_Vmean
            !Balaji changes end here
            7301 format (i8,2x,2(f12.7,3x),i8,3x,i7,3x,4(f12.7,3x))
         end if
      cc = cc + 1
   end do
      write(530,6303); write(531,6303); write(630,6303); write(631,6303); 6303 format (' ')
      write(560,6303); write(561,6303); write(660,6303); write(661,6303); 
      
  ! Calculate fluct components and total fluct energy for all particles
  !if (no_velocity_vectors_this_frame(frame) .le. 0 ) then ! if no vectors detected in this frame < 0, set velocities to that of previous frameo 0 ! Need to check this, may not be correct!!!!
  if (no_velocity_vectors_this_frame(frame) .le. 0 ) then ! if no vectors detected in this frame < 0, set velocities to that of previous frameo 0 ! Need to check this, may not be correct!!!!
      Vx_rms_fluctuating_component_of_velocity_this_frame(frame)= 0; Vy_rms_fluctuating_component_of_velocity_this_frame(frame)= 0
      X_intensity_of_velocity_fluctuations(frame) = 0; Y_intensity_of_velocity_fluctuations(frame) =0;
  else
! The definition of the rms value of the fluctuating component is 
! "the square root of the mean of the squares of the difference between actual and mean velocity"
! So I must add together the squares of v' - Vavg, then take the square root
      Vx_rms_fluctuating_component_of_velocity_this_frame(frame)= sqrt( cumulative_Vx_minus_Vmean_squared / no_velocity_vectors_this_frame(frame) )
      Vy_rms_fluctuating_component_of_velocity_this_frame(frame)= sqrt( cumulative_Vy_minus_Vmean_squared / no_velocity_vectors_this_frame(frame) )
      
      X_intensity_of_velocity_fluctuations(frame) = 100 * Vx_rms_fluctuating_component_of_velocity_this_frame(frame) / mean_velocity_X_component_over_avg_window(frame)
      Y_intensity_of_velocity_fluctuations(frame) = 100 * Vy_rms_fluctuating_component_of_velocity_this_frame(frame) / mean_velocity_Y_component_over_avg_window(frame)
  
      ! Now calculate granular temperature 
      ! For the wall case, use 1/3, for inside a flow field with 3D flow, use 2/3
      ! CHANGE THIS FOR FLOW INSIDE RISER
      total_fluctuating_energy(frame) = 0.333333 * Vx_rms_fluctuating_component_of_velocity_this_frame(frame)**2 + 0.333333 * Vy_rms_fluctuating_component_of_velocity_this_frame(frame)**2
  end if 
  
  ! Calculate fluct components and total fluct energy for particles in the KE regime
  if (no_velocity_vectors_this_frame_ke_regime(frame) .le. 0 ) then ! if no vectors detected in this frame is 0, set velocities to that of previous frameo 0 ! Need to check this, may not be correct!!!!
      Vx_rms_for_ke_regime(frame) = 0; Vy_rms_for_ke_regime(frame) = 0; 
  else
! The definition of the rms value of the fluctuating component is 
! "the square root of the mean of the squares of the difference between actual and mean velocity"
! So I must add together the squares of v' - Vavg, then take the square root
      Vx_rms_for_ke_regime(frame) = sqrt( cumulative_Vx_minus_Vmean_squared_for_ke_regime / no_velocity_vectors_this_frame_ke_regime(frame) )
      Vy_rms_for_ke_regime(frame) = sqrt( cumulative_Vy_minus_Vmean_squared_for_ke_regime / no_velocity_vectors_this_frame_ke_regime(frame) )
      ! Now calculate granular temperature 
      ! For the wall case, use 1/3, for inside a flow field with 3D flow, use 2/3
      ! CHANGE THIS FOR FLOW INSIDE RISER
      total_fluctuating_energy_ke_regime(frame) = 0.333333 * Vx_rms_for_ke_regime(frame)**2 + 0.333333 * Vy_rms_for_ke_regime(frame)**2
  end if 
  
  ! Calculate fluct components and total fluct energy for particles in the GT regime
  if (no_velocity_vectors_this_frame_GT_regime(frame) .le. 0 ) then ! if no vectors detected in this frame < 0, set velocities to that of previous frameo 0 ! Need to check this, may not be correct!!!!
      Vx_rms_for_GT_regime(frame) = 0; Vy_rms_for_GT_regime(frame) = 0; 
  else
! The definition of the rms value of the fluctuating component is 
! "the square root of the mean of the squares of the difference between actual and mean velocity"
! So I must add together the squares of v' - Vavg, then take the square root
      Vx_rms_for_GT_regime(frame) = sqrt( cumulative_Vx_minus_Vmean_squared_for_GT_regime / no_velocity_vectors_this_frame_GT_regime(frame) )
      Vy_rms_for_GT_regime(frame) = sqrt( cumulative_Vy_minus_Vmean_squared_for_GT_regime / no_velocity_vectors_this_frame_GT_regime(frame) )
      ! Now calculate granular temperature 
      ! For the wall case, use 1/3, for inside a flow field with 3D flow, use 2/3
      ! CHANGE THIS FOR FLOW INSIDE RISER
      total_fluctuating_energy_GT_regime(frame) = 0.333333 * Vx_rms_for_GT_regime(frame)**2 + 0.333333 * Vy_rms_for_GT_regime(frame)**2
  end if   
 
   write(671,7161) frame, no_velocity_vectors_this_frame(frame), no_velocity_vectors_this_frame_ke_regime(frame), no_velocity_vectors_this_frame_GT_regime(frame)
   7161 format( i6, 10x, 4(i6,10x))
   
   write(5630,6630) frame, solids_area_fraction(frame), total_fluctuating_energy(frame), &
                    total_fluctuating_energy_ke_regime(frame), total_fluctuating_energy_GT_regime(frame)
   6630 format( i6, 5x, f7.3, 3(15x,f12.9) )
   
   write(698,6700)&
   frame, mean_velocity_X_component_over_avg_window(frame), mean_velocity_Y_component_over_avg_window(frame), &
   Vx_rms_fluctuating_component_of_velocity_this_frame(frame), Vy_rms_fluctuating_component_of_velocity_this_frame(frame), &
   X_intensity_of_velocity_fluctuations(frame), Y_intensity_of_velocity_fluctuations(frame)
   6700 format(i6,8x,2(f8.4,7x),5x,2(f10.6,9x),2(f10.2,9x))
end do
! &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
! &&&&&&&&&&&&&&&&& Calculate Mean and Fluctuating Components of Velocity by Frame &&&&&&&&&&&&&&&&&&&&&&
! &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
! Calc_Mean_and_Fluct_Comp_of_Vel_and_Gran_Temp_Parameters.f90