! Calculate_min_and_max_traj_speed_found.f90
! Calculate the lowest and highest velocity in the real_trajectories
! Recall that all speeds are magnitudes of a velocity vector, so speed is always positive.  The angle determines direction.
min_average_speed_along_a_trajectory=100; max_average_speed_along_a_trajectory=0
!write(8990,8091) total_no_real_trajectories ; 8091 format('total_no_real_trajectories=',i8)
cumulative = 0
do i = 1 , total_no_real_trajectories
   cumulative = cumulative + avg_speed_of_traj(i)
   if(avg_speed_of_traj(i) .gt. max_average_speed_along_a_trajectory) then 
      max_average_speed_along_a_trajectory = avg_speed_of_traj(i) 
      real_trajectory_of_max_speed = i
      temp_cc = real_trajectory_centroid(i, 1)
      frame_no_of_max_speed = frame_no_of_a_centroid(temp_cc)
   end if;
   if(avg_speed_of_traj(i) .lt. min_average_speed_along_a_trajectory) then 
      min_average_speed_along_a_trajectory = avg_speed_of_traj(i) 
      real_trajectory_of_min_speed = i
      temp_cc = real_trajectory_centroid(i, 1)
      frame_no_of_min_speed = frame_no_of_a_centroid(temp_cc)
   end if;  
!write(930,3213) i, avg_speed_of_traj(i), min_average_speed_along_a_trajectory, max_average_speed_along_a_trajectory
!3213 format(i6,3(f10.4))
end do 
rtemp1 = cumulative / total_no_real_trajectories
write(*,3234)   min_average_speed_along_a_trajectory, real_trajectory_of_min_speed, frame_no_of_min_speed
write(905,3234) min_average_speed_along_a_trajectory, real_trajectory_of_min_speed, frame_no_of_min_speed
3234 format(/,'Minimum speed found = ',f10.4,' mps for traj no = ',i7,' in frame = ',i7)

write(*,3235)   max_average_speed_along_a_trajectory, real_trajectory_of_max_speed, frame_no_of_max_speed
write(905,3235) max_average_speed_along_a_trajectory, real_trajectory_of_max_speed, frame_no_of_max_speed
3235 format('Maximum speed found = ',f9.3,' mps for traj no = ',i7,' in frame = ',i7)

write(*,3236)   rtemp1, ( max_average_speed_along_a_trajectory - min_average_speed_along_a_trajectory ) / 2 + min_average_speed_along_a_trajectory
write(905,3236) rtemp1, ( max_average_speed_along_a_trajectory - min_average_speed_along_a_trajectory ) / 2 + min_average_speed_along_a_trajectory
3236 format(/'Mean speed = ',f9.3,' mps : halfway between min and max =', f9.3)

! End of calculating min and max traj speed
