! Particle size and cluster size analysis.
! This file calculates the size distributions of individual particles and clusters assuming a cutoff
! size value that divides individual particles and clusters.  The cutoff value is varied to examine its effect.
!________________________________________________________________________________
! Calculate and write particle and cluster size distributions, probability density curves

! first find maximum feret particle diameter
max_feret_diameter = 0;
do ic = 1, total_no_centroids 
   if(feret_diameter(ic) .gt. max_feret_diameter) max_feret_diameter = feret_diameter(ic) 
end do
print*, 'Max Feret diameter found in particles/clusters = ', max_feret_diameter*fov_scale*1000000, ' microns'

! I measure the size of particle IMAGES.  I cannot distinguish whether a particle image is an individual particle or if it is a cluster.
! I know the size distribution of the individual particles from an independent microtrac measurement.
! I know that the mean dia of individual particles is 70 microns and I know the upper limit of the individual particle size distribution, 
! which for this case from Nov 2008 is about 200 microns. So it is safe to assume that all images larger than 200 microns are clusters.
! But some of the particle images less than 200 microns are likely also clusters.  So I choose a cutoff size and assume that 
! all images below the cutoff size are individual particles and all above the cutoff are clusters.  
! The cutoff size is in the variable "size_dividing_between_individual_particles_and_clusters"

! First count the total number of individual particles and clusters for this cutoff
   do ic=1, total_no_centroids
      feret_diameter_in_microns = feret_diameter(ic) * fov_scale * 1000000 ! convert to microns before compare with cutoff which is read exogenously in microns
      if(feret_diameter_in_microns .gt. size_dividing_between_individual_particles_and_clusters) then
         total_no_clusters = total_no_clusters + 1  
      end if 
   end do
   total_no_individual_particles = total_no_centroids - total_no_clusters
!print*, 'cutoff = ',cutoff_between_ind_particles_and_clusters_for_size_analysis(cutoff_increment),'  total_no_particles_for_this_cutoff = ', total_no_individual_particles
!print*, 'cutoff = ',cutoff_between_ind_particles_and_clusters_for_size_analysis(cutoff_increment),'  total_no_clusters_for_this_cutoff  = ', total_no_clusters
!print*, ' '
   ! Now count the number of particles and clusters in each size bin
   cutoff_increment = 1;
   do bin = 1, no_of_bins
      particle_count_in_bin(bin,cutoff_increment) = 0; cluster_count_in_bin(bin,cutoff_increment)=0

      upper_limit_of_this_bin = upper_limit_of_size_distribution_analysis *     bin / no_of_bins 
      lower_limit_of_this_bin = upper_limit_of_size_distribution_analysis * (bin-1) / no_of_bins 
!print*, upper_limit_of_size_distribution_analysis, bin, no_of_bins     
!print*,'bin=',bin,' of',no_of_bins,'   lower_limit=',lower_limit_of_this_bin,'  upper_limit=',lower_limit_of_this_bin
      do ic=1, total_no_centroids
         feret_diameter_in_microns = feret_diameter(ic) * fov_scale * 1000000 ! convert to microns before test  
         if( feret_diameter_in_microns .gt. lower_limit_of_this_bin .and. feret_diameter_in_microns .lt. upper_limit_of_this_bin ) then
            if(feret_diameter_in_microns .gt. size_dividing_between_individual_particles_and_clusters) then ! this is a cluster
               cluster_count_in_bin(bin,cutoff_increment) = cluster_count_in_bin(bin,cutoff_increment) + 1;
            else ! else this is a particle
               particle_count_in_bin(bin,cutoff_increment) = particle_count_in_bin(bin,cutoff_increment) + 1;
            end if
         end if
         
         if(debug .eq. 1) then
            write(3998,7710) ic, feret_diameter_in_microns, lower_limit_of_this_bin, upper_limit_of_this_bin, particle_count_in_bin(bin,cutoff_increment), cluster_count_in_bin(bin,cutoff_increment)
            7710 format(i8,2x,'dp=',f6.1,' lower_limit_of_this_bin=',f5.1,' upper_limit_of_this_bin=',f5.1,' particles_in_bin=',f6.0,'  clusters_in_bin=',f6.0)
         end if
      
      end do
      if(total_no_individual_particles .eq. 0) then !do this to avoid divide by zero later
         percent_of_particles_in_bin(bin,cutoff_increment) = 0
      else 
         percent_of_particles_in_bin(bin,cutoff_increment) = particle_count_in_bin(bin,cutoff_increment) / total_no_individual_particles * 100
      end if
      if(total_no_clusters .eq. 0)  then
         percent_of_clusters_in_bin(bin,cutoff_increment)  = 0
      else
         percent_of_clusters_in_bin(bin,cutoff_increment)  = cluster_count_in_bin(bin,cutoff_increment)  / total_no_clusters * 100
      end if
      !write(2999,8710) bin, particle_count_in_bin(bin,cutoff_increment), total_no_individual_particles,&
      !                 cluster_count_in_bin(bin,cutoff_increment), total_no_clusters,&
      !                 percent_of_particles_in_bin(bin,cutoff_increment), percent_of_clusters_in_bin(bin,cutoff_increment)
      !8710 format('bin=',f5.1,' ; part_in_bin=',f7.0,' total_particles=',f7.0,2x,' ;clusters_in_bin=',f7.0,' total_clusters=',f7.0,'; %particles=',f7.1,'  %clusters=',f7.1 )
   end do
!print*,' '
!write(*,9202) bin,no_of_bins,lower_limit_of_this_bin,upper_limit_of_this_bin,percent_of_particles_in_bin(bin,cutoff_increment),percent_of_clusters_in_bin(bin,cutoff_increment)
!9202 format('bin ',i3,' out of ',i3,'  lower_limit = ',f6.1,'  upper_limit =',f6.1,' %_particles_in_bin=',f7.1,' %_clusters_in_bin', f7.1)
         
! Now write the particle/cluster size data
! Write the particle size data first
! Write header for this table of individual particle values
write(2737,3699); 3699 format('Size distribution of individual particles for a range of cutoff sizes between particles and clusters' )
write(2737,3702); 3702 format('bin#      midpoint_of_bin     %individual_particles    %clusters')
!write(2737,3701) (cutoff_between_ind_particles_and_clusters_for_size_analysis(j), i=1,no_of_increments_of_cutoff_for_size_analysis) ;
!3701 format('bin#    midpoint_of_bin, cutoff= ',20(4x,f5.0) )
! Now write particle size distributions for individual particles
do bin = 1, no_of_bins;      upper_limit_of_this_bin = upper_limit_of_size_distribution_analysis *     bin / no_of_bins 
   lower_limit_of_this_bin = upper_limit_of_size_distribution_analysis * (bin-1) / no_of_bins 
   midpoint_of_bin = (upper_limit_of_this_bin - lower_limit_of_this_bin)/2 + lower_limit_of_this_bin  
   write(2737,3738) bin, midpoint_of_bin, percent_of_particles_in_bin(bin,cutoff_increment), percent_of_clusters_in_bin(bin,cutoff_increment)  !  , cutoff=1, no_of_increments_of_cutoff_for_size_analysis)
   3738 format(f5.0, 5x, f8.3, 2(15x, f7.3))
end do  