! Read_regular_exogenous_input.f90
! All units in pixels, seconds.  ! Use pixels for distance units!!!!!!!

include 'allocate_large_arrays.f90'

! ******* Read Exogenous data from Trajectory_Identification input file, Unit=50 *******
include 'skip_2_lines_during_read_unit50.f90'
call cpu_time(start_time); 
write(*,81321) start_time; 81321 format(/,' ---------------------------------------------------',/,' Started reading exogenous parameter values at reads at',f8.3,' seconds') 
! Read camera setup parameters
print*,' '; print*,'******************** Camera Setup Parameters ********************** '; 
read(50,*) starting_frame_for_analysis, number_of_frames_to_analyze; ! So no of frames analyzed will be the same as in Trajectory_Identification
print*,'number_of_frames_to_analyze=',number_of_frames_to_analyze; write(599,*) 'number_of_frames_to_analyze=', number_of_frames_to_analyze
read(50,*) dt ;                         print*,'Time between camera frames, dt=',dt*1e6,' microseconds'; !print*,' '
read(50,*) x_pixels, y_pixels ;         write(*,321) x_pixels,y_pixels; 321 format(' Field-of-view resolution: x_pixels=',f5.0': y_pixels=',f5.0)
read(50,*) width_fov, height_fov;       print*,'Field-of-view size: width=',width_fov*1000,' mm: height=',height_fov*1000,' mm'; !print*,' '
read(50,*) particle_diameter ;          print*,'particle_diameter =',particle_diameter*1e6,' microns' ;
include 'skip_5_lines_during_read_unit50.f90'
include 'skip_2_lines_during_read_unit50.f90'
include 'skip_2_lines_during_read_unit50.f90'
read(50,*) max_length_real_traj; print*, 'max_length_real_traj=',max_length_real_traj; print*,' '
136 format (a3);
! ******* Finished reading Exogenous_Input file from Trajectory_Identification *******

! ******* Read Exogenous Input file for Standalone_Post_Processing ********
!read(60,*) number_of_frames_to_analyze; 
read(60,136) A_temp; read(60,136) A_temp;   ! this reads the first letter of the first line, which is a text header from ImageJ
read(60,*) order_of_polynomial_for_curve_fitting_trajectories ; print*, 'order_of_polynomial_for_curve_fitting_trajectories=',order_of_polynomial_for_curve_fitting_trajectories
! Set the rolling_average_window high enough to get enough velocity vectors around a frame to get true frame averaged velocity. 
! But set low enough to not remove highest frequencies in frame averaged velocity signal
read(60,*) enough_velocity_vectors_for_good_average, maximum_allowable_size_of_averaging_window ; permanent_enough_velocity_vectors_for_good_average =  enough_velocity_vectors_for_good_average
print*, 'Min no vectors required for averaging window = ', enough_velocity_vectors_for_good_average,'max size avg window = ', maximum_allowable_size_of_averaging_window
read(60,*) avg_window_for_no_cent_per_frame, max_no_particles_in_any_frame ; ! NOTE THAT max_no_particles_in_any_frame is NOW AN EXOGENOUS INPUT (TEMPORARY)
! This is a window over which particle centroids are summed for all frames, then averaged. This should be set to at least 11 to avoid incremental "jaggedness"
! in the Relative Particle Concentration curve.  For large particles in a small FOV in the custom borescope, a centroid may be detected only once every few frames, so to get a "reasonable" average for RPC
! try setting this to a high value -- as high as possible but not so high that changes in RPC cannot be followed.
! No longer use rolling average window, so set it to 1
print*, ' '; print*, 'Avg window for RPC =',avg_window_for_no_cent_per_frame, 'max no centroids in a frame =',max_no_particles_in_any_frame; print*, ' ';
!read(60,*) rolling_average_window_size_in_frames; print*,'rolling_average_window_size_in_frames=',rolling_average_window_size_in_frames; ! remove freq components in velocity lower than cluster_cutoff_frequency for use in calculating rolling avg and fluct components
rolling_average_window_size_in_frames = 1
read(60,*) use_trajectory_splicing ; if ( use_trajectory_splicing .eq. 'Yes') print*, 'Trajectory splicing is being used.'
read(60,*) overall_residual_for_collision_traj_identification, residual_for_collision_point_identification, shifting_specular_point_identification
read(60,*) min_size_for_trajectory_fitting; print*,'min_size_for_trajectory_fitting=',min_size_for_trajectory_fitting
read(60,*) m, n   ; print*,'Number of subregions in x-direction is',m,'  : number subregions in y-direction is',n
!read(60,*) imposed_limit_on_number_of_particles_in_a_subregion; print*,'imposed_limit_on_number_of_particles_in_a_subregion=',imposed_limit_on_number_of_particles_in_a_subregion
read(60,*) debug; if(debug .eq. 1) then; print*,' '; print*, 'DEBUGGING IS ON'; print*,' '; end if
read(60,*) no_columns_in_Centroid_input_for_Traj_Ident_file ; print*,'Reading from Centroid_input_for_Traj_Ident.txt file with ',no_columns_in_Centroid_input_for_Traj_Ident_file,' columns.'
read(60,*) this_is_a_single_phase_fluid_measurement ; if( this_is_a_single_phase_fluid_measurement .gt. 0.1)  print*, 'This is a single phase PIV analysis!!!'
read(60,*) pseudocolor_factor ; print*,'Pseudocolor_factor set to ', pseudocolor_factor ,' so trajs fcgo from blue at V=0 to red at V = pseudocolor_factor * Vmax'

!read(60,*) area_fraction_at_maximum_packing; print*, 'area_fraction_at_maximum_packing =',area_fraction_at_maximum_packing,' for ', particle_diameter * x_pixels / width_fov,' pixels'
!
!include 'skip_2_lines_during_read_unit50.f90'
!read(60,136) Use_particle_size_and_cluster_size_analysis  ; 136 format (a3);
!read(60,*) size_dividing_between_individual_particles_and_clusters, no_of_increments_size_dividing 
! For particle size analysis
!read(60,*) no_of_bins  ! number of bins for size distributions
!read(60,*) upper_limit_of_size_distribution_analysis
! ------- Read Exogenous Input file for Standalone_Post_Processing -------

fov_width_scale = width_fov/x_pixels; fov_height_scale= height_fov/x_pixels  ! fov scale in meters/pixel 
fov_scale = width_fov/x_pixels  ! use this if pixels are square, units are meters/pixel             
total_pixel_area = x_pixels*y_pixels; 
total_pixel_area_of_a_camera_frame = x_pixels*y_pixels; 

! __________________ Start of section to read Exogenous_Input_Parameters.txt Input File____________________
! _________________________________________________________________________________________________________
! _________________________________________________________________________________________________________
! _______________ Start of section to read area of frame covered by particle images__________________________
! Read particle concentration by frame. ! The input file is named "Particle_Area_input_for_Traj_Ident.txt" and is in the input folder
! First scan through file to find total_no_frames

126 format (a1);  ! this reads only the first letter of the first line, which is a text header from ImageJ

! Now read no_particles_in_frame, which is actually the number of centroids in each frame
read(150,126) A_temp
do i = 1, number_of_frames_to_analyze
   read(150,*) frame, no_particles_in_frame(i), rtemp1, rtemp2, rtemp3
end do

! Calc solids fraction, but only for particle flows
if( this_is_a_single_phase_fluid_measurement .lt. 0.1) then
   print*, 'calc_Relative_Particle_Conc_based_on_no_centroids_in_frames.f90'
   include 'calc_Relative_Particle_Conc_based_on_no_centroids_in_frames.f90'
else
   ! For single phase flow, particle conc is meaningless.  We may want to know seeding density though, but we can get that from the calc of the number of centroids in each frame and subregion
   ! Calc conc parameters anyway and just set them to 1 to avoid any possible divide-dy-zero errors.  Later check the code and remove these parameters from single-phase calc's
   do i=1, number_of_frames_to_analyze
      area_of_frame_covered_by_particle_images(i) = 1; max_area_of_frame_covered_by_particle_images = 1
      Relative_Particle_Concentration(i) = 1
      area_fraction_at_maximum_packing = 1
      solids_area_fraction(i) =  1
   end do
end if

print*, 'read_particle_centroid_data.f90'
include 'read_particle_centroid_data.f90'

print*,' '; print*,'Begin counting the number of centroids in each frame;'
call find_number_of_centroids_in_each_frame(total_no_centroids, frame_no_of_a_centroid, no_centroids_in_frame, first_centroid_in_frame, last_centroid_in_frame)
print*,' '; print*,'Finished counting the number of centroids in each frame;'

! Calculate average number of centroids in a frame: <-- waste of time calc this because it's not used
!average_no_centroids_in_a_frame = int( total_no_centroids / total_no_frames_in_centroid_file )
!print*, 'average_no_centroids_in_a_frame=',average_no_centroids_in_a_frame

if (debug .eq. 1) then
   ! Write some data for checking and verification that reads worked
   do i=1,number_of_frames_to_analyze  ! unit 1113 is file 'NUMBER_centroids_in_each_frame.txt'
     write(1113,*) i, no_centroids_in_frame(i), first_centroid_in_frame(i), last_centroid_in_frame(i)
   end do
end if

! Read void fraction data by subregion and frame
!read(65,136) A_temp;
!do frame = 1, number_of_frames_to_analyze
!   do iy = 1, n
!      do ix = 1, m
!         read(65,*) itemp1, itemp2, rtemp1, rtemp2, solids_area_fraction_subregion_of_frame(frame,ix,iy)
!         if(debug .gt. 0.1) write(66,68) itemp1, itemp2, rtemp1, rtemp2, void_fraction, solids_area_fraction_subregion_of_frame(frame,ix,iy);
!         68 format(i8,i8,1x,f7.3,3x,f7.3,3x,f6.3,3x,f6.3)
!      end do
!   end do
!end do

call beepqq (1000, 500);call beepqq (2000, 500);call beepqq (3000, 500); !call beepqq (3000, 500);call beepqq (4000, 500);call beepqq (5000, 500);
call cpu_time(finish_time); elapsed_time=finish_time-start_time;
write(*,8133) number_of_centroids_to_be_analyzed, elapsed_time
8133 format(/,'Finished reading ',i8,' centroids in',f12.5,' seconds')
print*,' --------------------------------------------------- '
print*, ' '
write(*,1251) number_of_frames_to_analyze ; 1251 format('>>>>>>>>>> ',i5,' FRAMES WILL BE POST-PROCESSED <<<<<<<<<');

