!  Standalone_Post_Processing.f90 
include 'modules_for_Standalone_Post_Processing.f90'
program Standalone_Post_Processing
use modules_for_Standalone_Post_Processing
implicit none
include 'declarations_section_for_standalone_post_processing.f90'
call cpu_time(start_calc_time); write(*,8797) start_calc_time; 8797 format('Standalone_Post_Processing started at ',f8.3,' sec')
include 'open_statements_for_standalone_post_processing.f90'
include 'write_headers_for_output_files.f90'
include 'Read_regular_exogenous_input.f90'
! 'Read_regular_exogenous_input.f90' includes the files 'calc_Relative_Particle_Conc_based_on_no_centroids_in_frames.f90' which includes 'calc_no_centroids_in_a_frame_by_avg_over_window.f90'

call cpu_time(fs_time); print*, ' time = ',fs_time,' sec'
print*, 'Reading traj_data_from_output_files_from_Trajectory_Identification'
include 'Read_traj_data_from_output_files_from_Trajectory_Identification.f90'

include 'trajectory_splicing_for_broken_tracks.f90'
print*, 'Trajectory splicing is not being used'

print*, 'Curve fitting traj coordinates using least squares'
include 'curve_fit_coordinates_using_least_squares_fit.f90'  
call cpu_time(fs_time); print*, ' time = ',fs_time,' sec'

print*, 'calc_subregion_boundaries'
include 'calc_subregion_boundaries.f90'
call cpu_time(fs_time); print*, ' time = ',fs_time,' sec'

print*, 'count_no_centroids_and_vectors_in_each_frame_and_subregion'
include 'count_no_centroids_and_vectors_in_each_frame_and_subregion.f90'
call cpu_time(fs_time); print*, ' time = ',fs_time,' sec'

if( this_is_a_single_phase_fluid_measurement .lt. 0.1) print*, 'calc_solids_fraction_based_on_no_centroids_in_subregions.f90'
include 'calc_solids_fraction_based_on_no_centroids_in_subregions.f90'
! This includes 'calc_area_of_subregion_covered_by_particle_images_over_avg_window.f90'
call cpu_time(fs_time); print*, ' time = ',fs_time,' sec'

print*, 'calc_frame_avg_vel_requiring_min_no_vectors'
include 'calc_frame_avg_vel_requiring_min_no_vectors.f90'
call cpu_time(fs_time); print*, ' time = ',fs_time,' sec'

print*, 'calc_subregion_avg_requiring_min_no_vectors'
include 'calc_subregion_avg_requiring_min_no_vectors.f90'
call cpu_time(fs_time); print*, ' time = ',fs_time,' sec'

print*, 'calc_fluct_comp_and_fluct_energy_for_frames'
include 'calc_fluct_comp_and_fluct_energy_for_frames.f90'
call cpu_time(fs_time); print*, ' time = ',fs_time,' sec'

print*, 'calc_fluct_comp_and_fluct_energy_for_subregions'
include 'calc_fluct_comp_and_fluct_energy_for_subregions.f90'
call cpu_time(fs_time); print*, ' time = ',fs_time,' sec'

print*, 'Writing MTrackJ data files'
include 'Write_MTrackJ_data_auto_color_curve_fitted_trajs.f90' 

if( this_is_a_single_phase_fluid_measurement .lt. 0.1) then 
   if(debug .gt. 0.5) then
      include 'Write_MTrackJ_data_file_with_collision_detection_difference.f90' 
   end if
end if

call cpu_time(end_calc_time); write(*,8798) end_calc_time-start_calc_time; 8798 format('Standalone_Post_Processing took a total of ',f8.3,' sec')

end program Standalone_Post_Processing

