! calc_Relative_Particle_Conc_based_on_no_centroids_in_frames.f90

! This calculates the Relative Particle Concentrion by first calculating the no_particles_in_frame_by_avg_window(i)
! The no_particles_in_frame_by_avg_window(i) is simply the no_particles_in_frame(i), which is read as input, 
! averaged over a window of frames.  The number of frames in the averaging window is an exogenous input "avg_window_for_no_cent_per_frame"

! Calculating RPC as the number of centroids in a frame divided by the max number of centroids in any frame
! avoids using the particle image size.  Relative Particle Concentration is used instead of solids fraction, because the thickness of the measurement volume (depth-of-focus)
! is not known to a reasonable certainty

! The commented lines below are old and just saved in case needed later
! First convert the particle diameter, which is read in meters, to pixels:
! cross_sectional_area_of_a_particle =  (3.1415 * particle_diameter**2.0 / 4.0)  / (fov_scale**2)! in pixels squared
!                                      0.75 * (0.0075 meters)**2 / (0.004 meters / 512 pixels)**2
! particle_diameter_in_pixels = particle_diameter / fov_scale ! recall that fov_scale = width_fov/x_pixels

! Now clip the max number of particles in a frame based on an exogenous input
do i = 1, number_of_frames_to_analyze
   ! Added by FS on April 18, 2010
   !if(debug .gt. 0.1) then
      ! unit 8885 is file='..\Standalone_Post_Processing\output\debugging\no_part_in_frame_by_avg_over_window.txt'
      write(8885,5887) i, no_particles_in_frame(i), max_no_particles_in_any_frame  !, total_pixel_area_of_a_camera_frame, area_of_frame_covered_by_particle_images(i)/total_pixel_area_of_a_camera_frame*100*0.6
      5887 format('frame=',i8,' : no part in frame=',i5,' : max_no_particles_in_any_frame = ',f12.2)  !format(i8,3x,i3,3x,4(4x,f12.5))  
   !end if
   if ( no_particles_in_frame(i) .gt. max_no_particles_in_any_frame ) no_particles_in_frame(i) = max_no_particles_in_any_frame
end do

! Now average the no_particles_in_frame(i) over a window of frames ( exogenously input number of window frames ) to calculate no_particles_in_frame_by_avg_window(i)
! This is for several reasons:  for large particles in a small FOV, the centroid count my be limited to, say, 10.  
! The produces a curve for relative particle conc that is noticeably graduated. Averaging over a window gives a better measurement of concentration, and smooths the concentration curve
include 'calc_no_centroids_in_a_frame_by_avg_over_window.f90'

! Calculate max no of particles in any frame, so RPC can be calc based on number of particles only, rather than max CSA of assumed avg particle dia
! NOTE: max_no_particles_in_any_frame IS NOW AN EXOGENOUS INPUT !
!max_no_particles_in_any_frame = 0
!do i=1, number_of_frames_to_analyze
!   if(no_particles_in_frame_by_avg_window(i) .gt. max_no_particles_in_any_frame) then 
!      max_no_particles_in_any_frame = no_particles_in_frame_by_avg_window(i) 
!      frame_with_max_area_covered_by_particle_images = i
!   end if;
!end do
! Now I limit the no of centroids from getting unreasonably large
!if (max_no_particles_in_any_frame .gt. max_no_particles_in_any_frame)  max_no_particles_in_any_frame = max_no_particles_in_any_frame


!if (debug .gt. 0.1) then
!   write(1009,5533) particle_diameter*1e6, cross_sectional_area_of_a_particle, max_area_of_frame_covered_by_particle_images, &
!                     frame_with_max_area_covered_by_particle_images,  frame_with_max_area_covered_by_particle_images
!   5533 format('The cross_sectional_area_of_a_particle with a diameter of ',f7.0,' microns is ',f10.3,' pixels^2',/, &
!                'The max_area_of_frame_covered_by_particle_images is ',f10.1,' and occurs in frame ',i9,' with ',i8,' particles')
!   write(1009,1811); 1811 format(/,'frame  max_area_frame_covered_by_part   area_of_frame_covered    Relative_Particle_Concentration   solids_area_fraction ')   
!end if

write(1009,1317) avg_window_for_no_cent_per_frame ; 
1317 format('frame  no_part_in_frame  no_part_in_frame_avgd  max_no_part_in_any_frame   RPC   solids_fraction   size of averaging window =',f8.0,' frames')
! Calculate Particle_Relative_Concentration and write it to output file for checking input data
do i=1, number_of_frames_to_analyze
   ! Now calc a relative conc that goes from 0 to 1
   Relative_Particle_Concentration(i) = no_particles_in_frame_by_avg_window(i) / max_no_particles_in_any_frame
   ! Now cause solids_area_fraction(i) to go from 0 to area_fraction_at_maximum_packing, which is 0.6 for HDPE
   area_fraction_at_maximum_packing = 0.74 ! No longer an exogenous input. Based on packing of spheres, max solids fraction is 0.54 for face-to-face packing and 0.74 for theoretical max
                                       ! So we use the theoretical max for monosize spheres because we have a size distribution, which may lead to tighter packing (need to study this!)
   solids_area_fraction(i) =  Relative_Particle_Concentration(i) * area_fraction_at_maximum_packing 
   
   ! Unit 1009 writes to file='..\Standalone_Post_Processing\output\by_frame\Particle_Relative_Concentration.txt'
   write(1009,1316) i, no_particles_in_frame(i), no_particles_in_frame_by_avg_window(i) , max_no_particles_in_any_frame, Relative_Particle_Concentration(i), solids_area_fraction(i); 
   1016 format(i5,4x,f8.0,3x,f10.5); 
   1316 format(i6, 10x,i5, 10x,f8.2, 20x,f8.1, 2(18x,f10.5) ); 
end do
