! calc_frame_avg_vel_requiring_min_no_vectors.f90

! _________  CALCULATE FRAME AVEGARED PARTICLE VELOCITY FOR EACH FRAME USING EXPANDING AVERAGING WINDOW TECHNIQUE  _________________
! Often there are not enough velocity vectors in each frame or subregion to get the true average velocity, so, for each frame and subregion,
! if the frame/subregion itself does not have enough velocity vectors for a good average, we use an average of the velocity vectors in a window of frames around the frame under consideration.
! I keep increasing the number of surrounding frames/subregions until I have enough velocity vectors to get a good average.  
! For now, the minumum number of velocity vectors to get a good average is an exogenous parameter called "enough_velocity_vectors_for_good_average"
! This is a kind of "frame averaged velocity" with a variable averaging window.
! These frame/subregion averages can be used to calculate fluctuating components and other parameters for which a local frame averaged value is needed.

print*,'Now calculating regular frame averaged velocities'
PRINT*,'enough_velocity_vectors_for_good_average=',enough_velocity_vectors_for_good_average

! Now calculate frame avg'd velocities using exogenously input minimum vectors
do frame = 1, number_of_frames_to_analyze
   ! reset variables for this frame
   cumulative_X_speed_over_avg_window = 0; cumulative_Y_speed_over_avg_window = 0;    no_velocity_vectors_in_averaging_window(frame) = 0   
   ! Setup averaging window
   expanded_avg_window_for_local_avg_vel_by_frame(frame) = 1  ! Test single frame as averaging window first
   expanded_window_half_width = (expanded_avg_window_for_local_avg_vel_by_frame(frame) + 1)/2 -1
   ! Count the number of velocity vectors in this averaging window
   first_frame_of_averaging_window = (frame - expanded_window_half_width); last_frame_of_averaging_window = (frame + expanded_window_half_width) 

   do while (no_velocity_vectors_in_averaging_window(frame) .lt. enough_velocity_vectors_for_good_average) 
      if ( first_frame_of_averaging_window .le. 0 ) first_frame_of_averaging_window = 1
      if ( last_frame_of_averaging_window  .ge. number_of_frames_to_analyze ) last_frame_of_averaging_window = number_of_frames_to_analyze
      no_velocity_vectors_in_averaging_window(frame) = 0 
      do window_frame = first_frame_of_averaging_window , last_frame_of_averaging_window 
         no_velocity_vectors_in_averaging_window(frame) = no_velocity_vectors_in_averaging_window(frame) + no_velocity_vectors_this_frame(window_frame)     
      end do
      if (no_velocity_vectors_in_averaging_window(frame) .lt. enough_velocity_vectors_for_good_average) then
         expanded_avg_window_for_local_avg_vel_by_frame(frame) = expanded_avg_window_for_local_avg_vel_by_frame(frame) + 2 
         expanded_window_half_width = (expanded_avg_window_for_local_avg_vel_by_frame(frame) + 1)/2 -1   
         first_frame_of_averaging_window = (frame - expanded_window_half_width); last_frame_of_averaging_window = (frame + expanded_window_half_width)        
      end if
   end do
   

   
   
   ! Now that the size and range of the expanded_averaging_window is determined, calculate the averages for this window of frames
   cumulative_X_speed_over_avg_window=0; cumulative_Y_speed_over_avg_window=0; 
   ! First calculate cumulative values for this averaging window of frames
   do window_frame = first_frame_of_averaging_window , last_frame_of_averaging_window
      cc = first_centroid_in_frame(window_frame)
      do while ( cc .le. last_centroid_in_frame(window_frame) )    ! Range through centroids for this frame
         if ( is_centroid_in_a_real_trajectory(cc) .gt. 0 ) then  ! only use centroids that are actually in a trajectory  
            real_trajectory_no = real_trajectory_no_of_centroid(cc);  tc = position_of_centroid_in_trajectory(cc)
            if ( tc .ne. real_trajectory_total_length(real_trajectory_no) ) then ! Balaji change Add if statement for last centroid of trajectory
                ! Recall that x_speed_along_traj includes sign of direction (+/-).  How will the change average if particles are moving in opposite directions?
                cumulative_X_speed_over_avg_window = cumulative_X_speed_over_avg_window + x_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc)
                cumulative_Y_speed_over_avg_window = cumulative_Y_speed_over_avg_window + y_speed_along_traj_from_ls_curve_fit(real_trajectory_no,tc)
            end if                                                               ! Balaji change Add if statement for last centroid of trajectory
         end if
         !write(2994,4994) frame, window_frame, cc,  x_speed_along_traj(real_trajectory_no,tc), y_speed_along_traj(real_trajectory_no,tc), cumulative_X_speed_over_avg_window, cumulative_Y_speed_over_avg_window
         !4994 format(i8,5x,i8,5x,i8,4(5x,f10.6))        
         cc = cc + 1
      end do        
   end do 
   
   !Balaji Change 18/07 remove data for frames where we do not have enough particles
   !The idea is to set the mean and the number of velocity vectors for those frames to zero and use it to filter out when calculating GT
   if(last_frame_of_averaging_window-first_frame_of_averaging_window  .gt. maximum_allowable_size_of_averaging_window) then
   no_velocity_vectors_in_averaging_window(frame) = 0;
   local_avg_of_X_velocity(frame) = 0;
   local_avg_of_Y_velocity(frame) = 0;
   end if
   !Balaji Change 18/07
   
   ! Now calculate mean values
   if(no_velocity_vectors_in_averaging_window(frame) .ne. 0) then     !Balaji Change 18/07 remove data for cases where we do not have enough particles (added if statement)
    local_avg_of_X_velocity(frame)= cumulative_X_speed_over_avg_window / no_velocity_vectors_in_averaging_window(frame)
    local_avg_of_Y_velocity(frame)= cumulative_Y_speed_over_avg_window / no_velocity_vectors_in_averaging_window(frame)
    avg_angle_this_frame(frame) = atan2(local_avg_of_Y_velocity(frame) , local_avg_of_X_velocity(frame))
    frame_avg_velocity(frame) = sqrt(local_avg_of_X_velocity(frame)**2 + local_avg_of_Y_velocity(frame)**2)
   end if

  ! write(4998,5112) frame, expanded_avg_window_for_local_avg_vel_by_frame(frame), no_velocity_vectors_in_averaging_window(frame), mean_velocity_X_component_over_avg_window(frame), mean_velocity_Y_component_over_avg_window(frame),&
  !                  frame_avg_velocity(frame),avg_angle_this_frame(frame)*360/(2.0*3.14159)
   write(4998,5112) frame, expanded_avg_window_for_local_avg_vel_by_frame(frame), no_velocity_vectors_in_averaging_window(frame), &
                    local_avg_of_X_velocity(frame), local_avg_of_Y_velocity(frame), &
                    frame_avg_velocity(frame), avg_angle_this_frame(frame)*360/(2.0*3.14159)
   !5112 format(i8,9x,i8,20x,i8,3x,4(8x,f10.5) )
end do

! Now calculate the total mean velocity and the frame average for use in calculating fluctuating components
! First calculate the total mean velocity based on all frames
total_mean_X_velocity_for_all_frames = 0; total_mean_Y_velocity_for_all_frames = 0
do frame = 1, number_of_frames_to_analyze
   total_mean_X_velocity_for_all_frames = total_mean_X_velocity_for_all_frames + local_avg_of_X_velocity(frame) / number_of_frames_to_analyze
   total_mean_Y_velocity_for_all_frames = total_mean_Y_velocity_for_all_frames + local_avg_of_Y_velocity(frame) / number_of_frames_to_analyze
end do 

! I have to put this format statement which occurred in "calc_mean_vel_of_frames_w_single_min_vector_number.f90"
! outsite of the include statement because this file is included twice.  With the format statement inside, an error is generated
! that 5112 was defined twice
   5112 format(i8,9x,i8,20x,i8,3x,4(8x,f10.5) )
   5213 format(i8,19x,i4,10x, i8,20x,i8,3x,4(8x,f10.5) )