! calc_no_cent_subregion_using_avg_window.f90

! Now I -smooth the area_fraction curve because it incremental with particle number and there may be, e.g., 1 to 10 particles in each region.
! This makes the plots against solids fraction look strange.
! Also, the minimum solids concentration occurs when only one particle is seen in a consecutive sequence of frames
! So to capture this min solids concentration I calculate an avg over 11 frames

if( this_is_a_single_phase_fluid_measurement .lt. 0.1) then  ! If this is not a single phase flow, do this first section, if not, jump to the "else" section
print*, 'This is a particle flow analysis!' !, so running calc_area_of_subregion_covered_by_particle_images_over_avg_window.f90 for particle flow!!'
   avg_window_for_no_cent_per_frame = 11  ! This must be odd
   half_avg_window_for_no_cent_per_frame = ( avg_window_for_no_cent_per_frame - 1 )/ 2
   cumulative = 0
   ! no_centroids_this_subregion_of_frame(i,ix,iy)
   do ix = 1 , m
      do iy = 1 , n
         do frame = 1, number_of_frames_to_analyze
            ! If this frame is one of the first frames and is within half the averaging window to the first frame
            ! Calculate the area_of_subregion_covered_by_particle_images using first 11 frames
            if ( frame .le. (half_avg_window_for_no_cent_per_frame + 1) ) then
               do k = 1 , avg_window_for_no_cent_per_frame
                  cumulative = cumulative + no_centroids_this_subregion_of_frame(k,ix,iy)
               end do 
               no_centroids_this_subregion_of_frame(frame,ix,iy) = cumulative / avg_window_for_no_cent_per_frame
               cumulative = 0
            end if
   
            if ( frame .ge. number_of_frames_to_analyze - half_avg_window_for_no_cent_per_frame ) then
               do k = number_of_frames_to_analyze - avg_window_for_no_cent_per_frame, number_of_frames_to_analyze
                  cumulative = cumulative + no_centroids_this_subregion_of_frame(k,ix,iy)
               end do 
               no_centroids_this_subregion_of_frame(frame,ix,iy) = cumulative / avg_window_for_no_cent_per_frame
               cumulative = 0    
            end if
    
            if( frame .ge. (half_avg_window_for_no_cent_per_frame + 1) .and. frame .le. (number_of_frames_to_analyze - half_avg_window_for_no_cent_per_frame - 1) ) then
               do k = frame - half_avg_window_for_no_cent_per_frame , frame + half_avg_window_for_no_cent_per_frame
                  cumulative = cumulative + no_centroids_this_subregion_of_frame(k,ix,iy)
               end do 
               no_centroids_this_subregion_of_frame(frame,ix,iy) = cumulative / avg_window_for_no_cent_per_frame
               cumulative = 0         
            end if
         end do 
     end do
  end do

else 
print*, 'This is a single phase PIV analysis, so running calc_area_of_subregion_covered_by_particle_images_over_avg_window.f90 for single phase!!'
   ! For single-phase flow, just set no_centroids_this_subregion_of_frame(i,ix,iy) equal to 1 because it is meaningless for single phase flows
   do ix = 1 , m
      do iy = 1 , n
         do frame = 1, number_of_frames_to_analyze
            no_centroids_this_subregion_of_frame(frame,ix,iy) = 1
         end do 
     end do
  end do
 
 end if
