! calc_rolling_and_total_avg_of_velocity_for_frames.f90

! I no longer calculate a rolling average because it is unnecessary and smooths out good data.
! The only averaging done is to make sure there are enough velocity vectors in an averaging window to get a good average velocity from which to calculate 
! random particle velocity
! by setting rolling_average_window_size_in_frames=1, the rolling average is the same as the mean average

rolling_average_window_size_in_frames = 1

do frame = 1, number_of_frames_to_analyze
   rolling_average_X_velocity_at_frame(frame) = 0; rolling_average_Y_velocity_at_frame(frame) = 0;
end do

!write(2000,2049) total_mean_X_velocity_for_all_frames, total_mean_Y_velocity_for_all_frames;
!2049 format('rolling_avg_of_vel_by_frame_and_total_average_vel.txt',/,&
!            'Total_mean_X_velocity_for_all_frames = ',f9.4,': Total_mean_Y_velocity_for_all_frames = ',f9.4,/ )

write(2000,2324) ; 2324 format('frame           mean_X_vel    rolling_avg_X_vel             mean_Y_vel    rolling_avg_X_vel')

do frame = 1, number_of_frames_to_analyze     
   start_window_frame = (frame - (rolling_average_window_size_in_frames-1)/2)
   end_window_frame   = (frame + (rolling_average_window_size_in_frames-1)/2)
   if ( start_window_frame .le. 0) start_window_frame = 1
   if ( end_window_frame .ge. number_of_frames_to_analyze) end_window_frame = number_of_frames_to_analyze

   do i = start_window_frame, end_window_frame
      rolling_average_X_velocity_at_frame(frame) = rolling_average_X_velocity_at_frame(frame) + frame_avg_X_velocity(i)/rolling_average_window_size_in_frames
      rolling_average_Y_velocity_at_frame(frame) = rolling_average_Y_velocity_at_frame(frame) + frame_avg_Y_velocity(i)/rolling_average_window_size_in_frames
   end do 
   ! Unit 2000 writes to "file='..\Standalone_Post_Processing\output\by_frame\rolling_avg_of_vel_by_frame_and_total_average_vel.txt"
   write(2000,2050) frame, &
                    frame_avg_X_velocity(frame), rolling_average_X_velocity_at_frame(frame), &
                    frame_avg_Y_velocity(frame), rolling_average_Y_velocity_at_frame(frame)
   2050 format(i8,5X,4(f12.6,10x))  
end do

