! calc_rolling_avg_of_velocity_based_on_cutoff_frequency.f90

! Now calculate the rolling averages of velocity based on the cluster_cutoff_frequency, if large clusters occur with low relative particle motion inside
period_of_cluster_filter = 1.0 / cluster_cutoff_frequency
rolling_average_window_size_in_frames = int(period_of_cluster_filter / dt)
! rolling average window needs to be odd, so make it odd
rtemp1 = int(rolling_average_window_size_in_frames/2) ! This gives the integer part of a real number, i.e, int(8.3) = 8
if ( (rolling_average_window_size_in_frames/2 - rtemp1) .lt. 0.1 )  rolling_average_window_size_in_frames = rolling_average_window_size_in_frames + 1
do frame = 1, number_of_frames_to_analyze   
   rolling_average_window_size_in_frames = int(period_of_cluster_filter / dt)
   ! rolling average window needs to be odd, so make it odd
   rtemp1 = int(rolling_average_window_size_in_frames/2) ! This gives the integer part of a real number, i.e, int(8.3) = 8
   if ( (rolling_average_window_size_in_frames/2 - rtemp1) .lt. 0.1 )  rolling_average_window_size_in_frames = rolling_average_window_size_in_frames + 1
   
   start_window_frame = (frame - (rolling_average_window_size_in_frames-1)/2)
   end_window_frame = (frame + (rolling_average_window_size_in_frames-1)/2)
   if ( start_window_frame .le. 0) start_window_frame = 1
   if ( end_window_frame .ge. number_of_frames_to_analyze) end_window_frame = number_of_frames_to_analyze
   rolling_average_window_size_in_frames = end_window_frame - start_window_frame + 1  ! add 1 to make it odd again
   do i = start_window_frame, end_window_frame
      rolling_average_X_velocity_at_frame(frame) = rolling_average_X_velocity_at_frame(frame) + mean_X_velocity_at_frame(i)/rolling_average_window_size_in_frames
      rolling_average_Y_velocity_at_frame(frame) = rolling_average_Y_velocity_at_frame(frame) + mean_Y_velocity_at_frame(i)/rolling_average_window_size_in_frames
   end do    
   write(2000,2050) frame, rolling_average_window_size_in_frames, mean_X_velocity_at_frame(frame), rolling_average_X_velocity_at_frame(frame), &
                           mean_Y_velocity_at_frame(frame), rolling_average_Y_velocity_at_frame(frame)
   2050 format(i8,4X,f12.2,4(10x,f12.6))
end do

! Now calculate rolling averages of velocity for each region based on the cluster cutoff frequency
period_of_cluster_filter = 1.0 / cluster_cutoff_frequency
rolling_average_window_size_in_frames = int(period_of_cluster_filter / dt)
! rolling average window needs to be odd, so make it odd
rtemp1 = int(rolling_average_window_size_in_frames/2) ! This gives the integer part of a real number, i.e, int(8.3) = 8
if ( (rolling_average_window_size_in_frames/2 - rtemp1) .lt. 0.1 )  rolling_average_window_size_in_frames = rolling_average_window_size_in_frames + 1
do ix = 1, m
   do iy = 1, n
      do frame = 1, number_of_frames_to_analyze   
         rolling_average_window_size_in_frames = int(period_of_cluster_filter / dt)
         ! rolling average window needs to be odd, so make it odd
         rtemp1 = int(rolling_average_window_size_in_frames/2) ! This gives the integer part of a real number, i.e, int(8.3) = 8
         if ( (rolling_average_window_size_in_frames/2 - rtemp1) .lt. 0.1 )  rolling_average_window_size_in_frames = rolling_average_window_size_in_frames + 1
   
         start_window_frame = (frame - (rolling_average_window_size_in_frames-1)/2)
         end_window_frame = (frame + (rolling_average_window_size_in_frames-1)/2)
         if ( start_window_frame .le. 0) start_window_frame = 1
         if ( end_window_frame .ge. number_of_frames_to_analyze) end_window_frame = number_of_frames_to_analyze
         
         rolling_average_window_size_in_frames = end_window_frame - start_window_frame + 1  ! add 1 to make it odd again
         do i = start_window_frame, end_window_frame
            rolling_average_X_velocity_at_subregion_of_frame(frame,ix,iy) = rolling_average_X_velocity_at_subregion_of_frame(frame,ix,iy) + &
                                                                              mean_X_velocity_at_subregion_of_frame(frame, ix, iy)/rolling_average_window_size_in_frames
            rolling_average_Y_velocity_at_subregion_of_frame(frame,ix,iy) = rolling_average_Y_velocity_at_subregion_of_frame(frame,ix,iy) + &
                                                                              mean_Y_velocity_at_subregion_of_frame(frame, ix, iy)/rolling_average_window_size_in_frames
         end do    
         write(2100,2150) frame, ix, iy, rolling_average_window_size_in_frames, mean_X_velocity_at_subregion_of_frame(frame, ix, iy), rolling_average_X_velocity_at_subregion_of_frame(frame,ix,iy), &
                             mean_Y_velocity_at_subregion_of_frame(frame, ix, iy), rolling_average_Y_velocity_at_subregion_of_frame(frame,ix,iy)
         2050 format(i8,4X,f12.2,4(10x,f12.6))
      end do
   end do
end do
