! calc_rolling_avg_of_velocity_for_subregions.f90
! NOTE: rolling average is no longer used!  So until the code is changed, the rolling average window is set equal to 1

! Setting rolling_average_window_size_in_frames=1 makes rolling average the same as the mean average!
rolling_average_window_size_in_frames = 1

do ix = 1, m
   do iy = 1, n
      do frame = 1, number_of_frames_to_analyze   
         start_window_frame = (frame - (rolling_average_window_size_in_frames-1)/2)
         end_window_frame = (frame + (rolling_average_window_size_in_frames-1)/2)
         if ( start_window_frame .le. 0) start_window_frame = 1
         if ( end_window_frame .ge. number_of_frames_to_analyze) end_window_frame = number_of_frames_to_analyze
         !rolling_average_window_size_in_frames_temp = end_window_frame - start_window_frame + 1  ! add 1 to make it odd again
         
         do i = start_window_frame, end_window_frame            
            subregion_avg_X_velocity(frame,ix,iy) = subregion_avg_X_velocity(frame,ix,iy) &
                                                              + frame_avg_X_velocity_at_subregion(i,ix,iy)/rolling_average_window_size_in_frames
            
            subregion_avg_Y_velocity(frame,ix,iy) = subregion_avg_Y_velocity(frame,ix,iy) &
                                                              + frame_avg_Y_velocity_at_subregion(i,ix,iy)/rolling_average_window_size_in_frames
         end do    
         write(2100,2150) frame, ix, iy, rolling_average_window_size_in_frames, start_window_frame, end_window_frame, &
                          frame_avg_X_velocity_at_subregion(frame,ix,iy), subregion_avg_X_velocity(frame,ix,iy), &
                          frame_avg_Y_velocity_at_subregion(frame,ix,iy), subregion_avg_Y_velocity(frame,ix,iy)
         2150 format( i8,7X,i2,4x,i2,7x,3(5x,f7.0),4(10x,f12.6) )
       end do
   end do 
end do 

! Now write rolling avg's by region
do frame = 1, number_of_frames_to_analyze   
   write(211,2110) frame, rolling_average_window_size_in_frames, frame_avg_X_velocity_at_subregion(frame,1,1), subregion_avg_X_velocity(frame,1,1), frame_avg_Y_velocity_at_subregion(frame,1,1), subregion_avg_Y_velocity(frame,1,1)
   write(212,2110) frame, rolling_average_window_size_in_frames, frame_avg_X_velocity_at_subregion(frame,1,2), subregion_avg_X_velocity(frame,1,2), frame_avg_Y_velocity_at_subregion(frame,1,2), subregion_avg_Y_velocity(frame,1,2)
   write(213,2110) frame, rolling_average_window_size_in_frames, frame_avg_X_velocity_at_subregion(frame,1,3), subregion_avg_X_velocity(frame,1,3), frame_avg_Y_velocity_at_subregion(frame,1,3), subregion_avg_Y_velocity(frame,1,3)
   write(221,2110) frame, rolling_average_window_size_in_frames, frame_avg_X_velocity_at_subregion(frame,2,1), subregion_avg_X_velocity(frame,2,1), frame_avg_Y_velocity_at_subregion(frame,2,1), subregion_avg_Y_velocity(frame,2,1)
   write(222,2110) frame, rolling_average_window_size_in_frames, frame_avg_X_velocity_at_subregion(frame,2,2), subregion_avg_X_velocity(frame,2,2), frame_avg_Y_velocity_at_subregion(frame,2,2), subregion_avg_Y_velocity(frame,2,2)
   write(223,2110) frame, rolling_average_window_size_in_frames, frame_avg_X_velocity_at_subregion(frame,2,3), subregion_avg_X_velocity(frame,2,2), frame_avg_Y_velocity_at_subregion(frame,2,3), subregion_avg_Y_velocity(frame,2,3)
   write(231,2110) frame, rolling_average_window_size_in_frames, frame_avg_X_velocity_at_subregion(frame,3,1), subregion_avg_X_velocity(frame,3,1), frame_avg_Y_velocity_at_subregion(frame,3,1), subregion_avg_Y_velocity(frame,3,1)
   write(232,2110) frame, rolling_average_window_size_in_frames, frame_avg_X_velocity_at_subregion(frame,3,2), subregion_avg_X_velocity(frame,3,2), frame_avg_Y_velocity_at_subregion(frame,3,2), subregion_avg_Y_velocity(frame,3,2)
   write(233,2110) frame, rolling_average_window_size_in_frames, frame_avg_X_velocity_at_subregion(frame,3,3), subregion_avg_X_velocity(frame,3,3), frame_avg_Y_velocity_at_subregion(frame,3,3), subregion_avg_Y_velocity(frame,3,3)
end do
2110 format( i8,7x,5x,f7.0,4(10x,f12.6) )

