! calc_solids_fraction_based_on_no_centroids_in_subregions.f90

!!!! NOTE THAT FOR GUENTHER CASES WHERE FOV IS SUPPOSED TO BE 4MM X 4MM, THE PARTICLE DIAMETERS I SEE IN THE VIDEO FRAMES
! IS ABOUT 50 PIXELS, BUT A 750 MICRON PARTICLE SHOULD BE 96 PIXELS IN A 4MM X 4MM FOV !!!
! SO I USE A PARTICLE DIAMETER OF 375 MICRONS IN THE EXOGENOUS INPUT FILE INSTEAD OF 750 MICRONS
! cross_sectional_area_of_a_particle is calculated earlier as
! cross_sectional_area_of_a_particle =  (3.1415 * particle_diameter**2.0 / 4.0)  / (fov_scale**2)! in pixels squared

if( this_is_a_single_phase_fluid_measurement .lt. 0.1) then  ! If this is not a single phase flow, do this first section, if not, jump to the "else" section
   
   print*, ' '
   print*, 'This is a particle flow analysis, '
   print*, 'so running "calc_solids_fraction_based_on_no_centroids_in_subregions.f90" for particle flow!!'   
   print*, ' '

   ! The following section commented out because I now use no_centroids_this_subregion_of_frame(frame,ix,iy) to calculate RPC
   ! Now calc area_of_subregion_covered_by_particle_images for each subregion
   !area_of_a_subregion = x_pixels/m * y_pixels/n
   !do frame = 1, number_of_frames_to_analyze
   !   do ix = 1, m
   !      do iy = 1, n       
   !         ! Now calculate the area covered by particles (in pixels) using the number of particles detected in each frame by ImageJ's Particle Analyzer
   !         no_centroids_this_subregion_of_frame(frame,ix,iy) = cross_sectional_area_of_a_particle *  no_centroids_this_subregion_of_frame(frame,ix,iy)   ! in pixels
   !         write(915,5888) frame, ix, iy, &
   !                         cross_sectional_area_of_a_particle, no_centroids_this_subregion_of_frame(frame,ix,iy), no_centroids_this_subregion_of_frame(frame,ix,iy), &
   !                         solids_area_fraction_subregion_of_frame(frame,ix,iy)
   !         5888 format( i8,2x,i2,2x,i2,3x,f8.2,4x,i7,f12.4,10x,f12.7 )  
   !     end do
   !   end do
   !end do

   ! Now I calculate the area of frames covered by particles using an 11 window average.
   ! Because there are so few particles in single frames/regions the data for solids conc is incremental and looks strange
   ! Using an averaging window smooths the dat and makes it mero relaticsmooth the area_of_subregion_covered_by_particle_images over 11 frames because the number of centroids in a subregion is incremental with a max around 10. 
   ! Incremental valuas makes the plots against solids fraction look strange.
   ! so calculate a rolling avg over 5 frames
   include 'calc_no_cent_subregion_using_avg_window.f90'        
         
   ! Now find max_no_cent_in_subregion_using_avg_window 
   max_no_cent_in_subregion_using_avg_window = 0
   do ix = 1 , m
      do iy = 1 , n
         do i=1, number_of_frames_to_analyze
            if(no_centroids_this_subregion_of_frame(i,ix,iy) .gt. max_no_cent_in_subregion_using_avg_window) then 
                max_no_cent_in_subregion_using_avg_window = no_centroids_this_subregion_of_frame(i,ix,iy)
            end if;
         end do
      end do 
   end do

   write(710,7644) max_no_cent_in_subregion_using_avg_window; 7644 format('max_no_cent_in_subregion_using_avg_window=',f12.4)
   write(710,1013); 1013 format(/,'   Frame      region_x      region_y        solids_fraction    Relative_Particle_Concentration')
   ! Calculate Particle_Relative_Concentration and write it to output file for checking input data
   do ix = 1 , m
      do iy = 1 , n
         do i=1, number_of_frames_to_analyze
            ! Now calculate a use Relative_Particle_Concentration that varies from 0 to 1, where 1 is the max conc
            Relative_Particle_Concentration_by_subregion(i,ix,iy) = no_centroids_this_subregion_of_frame(i,ix,iy) / max_no_cent_in_subregion_using_avg_window 
            ! Now cause solids fraction to vary from 0 to 0.6 for these 0.75mm HDPE particles
            ! area_fraction_at_maximum_packing = 0.6 !!!!! Now an exogenous input
            solids_area_fraction_subregion_of_frame(i,ix,iy) = Relative_Particle_Concentration_by_subregion(i,ix,iy) * area_fraction_at_maximum_packing
            ! Writes to file='..\Standalone_Post_Processing\output\by_subregion\Particle_Relative_Conc_by_subregion.txt'
            write(710,1716) i, ix, iy, solids_area_fraction_subregion_of_frame(i,ix,iy),&
                                       Relative_Particle_Concentration_by_subregion(i,ix,iy); 
            1716 format(i8,12x,i2,12x,i2,2(10x,f12.6)); 
         end do
      end do
   end do

else  ! for single phase flow just set these parameters to 1   

   print*, ' '
   print*, 'This is a single phase flow analysis, '
   print*, 'so running "calc_solids_fraction_based_on_no_centroids_in_subregions.f90" for single phase flow!!'   
   print*, ' '

   do ix = 1 , m
      do iy = 1 , n
         do i=1, number_of_frames_to_analyze
            Relative_Particle_Concentration_by_subregion(i,ix,iy) = no_centroids_this_subregion_of_frame(i,ix,iy) / max_no_cent_in_subregion_using_avg_window 
            solids_area_fraction_subregion_of_frame(i,ix,iy) = Relative_Particle_Concentration_by_subregion(i,ix,iy) * area_fraction_at_maximum_packing
         end do
      end do
   end do

end if