! declarations_section_for_standalone_post_processing.f90

!--------------- ARRAYS-----------------------------

! The 2D trajectory arrays present a memory challenge because they are so big.  
! The first subscript is the max number of real trajectoryies and the second subscript is the max length of a trajectory
! These two dimensional arrays take up the most memory and can cause memory overload errors.
! These 2D Arrays cause the program image size to be greater the 2 GB, which causes LNK1248 error
! Intel recommended using Allocateable arrays to avoid this problem, so I shall.  Allocating arrays works because allocated arrays
! have access to all of the available RAM (minus the first 2GB of RAM that Windows uses and is called a "stack").  
! If arrays are static (not allocated) they all are put into the stack which has a 2GB limit.

integer, parameter :: TOTAL_NUMBER_OF_CENTROIDS = 10800000
integer, parameter :: TOTAL_NUMBER_OF_FRAMES = 110000
integer, parameter :: TOTAL_NUMBER_OF_REAL_TRAJECTORIES = 1000000
integer, parameter :: MAXIMUM_TRAJECTORY_LENGTH = 12
integer, parameter :: TOTAL_NUMBER_OF_SPLICED_TRAJECTORIES = 700000
integer, parameter :: X_GRID_SPACING = 1
integer, parameter :: Y_GRID_SPACING = 1
integer m, n

! ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ ARRAY DECLARATION SECTION ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

! -----------------------  Allocate Large Arrays -------------------
real,allocatable,dimension (:,:) :: x_speed_along_traj_from_ls_curve_fit, y_speed_along_traj_from_ls_curve_fit
integer,allocatable,dimension (:,:) :: spliced_trajectory_centroid
integer,allocatable,dimension (:,:) :: real_trajectory_centroid

! Large subregion 3D arrays
! **************** Subregion parameters *************************
! Allocate these large 3D arrays so they go into the heap above the 2GB limit
integer, allocatable ::  no_vel_vectors_in_mean_avg_window_around_this_subregion( :, :, : )
real, allocatable    ::  Granular_Temperature_using_total_avg_by_subregion( :, :, : )
integer, allocatable ::  expanded_average_window_for_mean_vel_by_subregion( :, :, : )
real, allocatable    ::  Relative_Particle_Concentration_by_subregion( :, :, : )
integer, allocatable ::  no_velocity_vectors_this_subregion_of_frame( :, :, : ), no_centroids_this_subregion_of_frame( :, :, : )
real, allocatable    ::  frame_avg_X_velocity_at_subregion( :, :, : ), frame_avg_Y_velocity_at_subregion( :, :, : )
real, allocatable    ::  avg_angle_at_subregion_of_frame( :, :, : ), mean_velocity_this_subregion_of_frame( :, :, : )

!real, allocatable    ::  subregion_avg_X_velocity( :, :, : )
!real, allocatable    ::  subregion_avg_Y_velocity( :, :, : )
real, allocatable    ::  Granular_Temp_using_subregion_avg_vel( :, :, : ), solids_area_fraction_subregion_of_frame( :, :, : )
real, allocatable    ::  X_RMS_fluct_comp_vel_using_subregion_avg( :, :, : ), Y_RMS_fluct_comp_vel_using_subregion_avg( :, :, : )
real, allocatable    ::  X_RMS_fluct_comp_vel_using_total_avg_this_subregion( :, :, : ), Y_RMS_fluct_comp_vel_using_total_avg_this_subregion( :, :, : )
real, allocatable    ::  X_intensity_of_velocity_fluctuations_by_subregion( :, :, : ), Y_intensity_of_velocity_fluctuations_by_subregion( :, :, : )
real , allocatable   ::  does_subregion_have_enough_vectors_nearby_for_good_avg( :, :, : )
! 2D subregion arrays
real, allocatable    :: total_mean_X_velocity_all_frames_for_subregion(:, :)
real, allocatable    :: total_mean_Y_velocity_all_frames_for_subregion(:, :)
real, allocatable    :: total_vel_vectors_this_subregion_for_all_frames(:, :)
real, allocatable    :: X_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(:, :)
real, allocatable    :: Y_RMS_fluct_comp_vel_in_region_all_frames_by_total_avg_vel(:, :)
real, allocatable    :: avg_angle_of_RMS_fluct_comp_of_region_for_ALL_frames(:, : )
integer, allocatable :: start_of_trajectory_section(:, :), end_of_trajectory_section(:, :)
integer, allocatable :: total_trajectory_spliced_info(: ,:)

! -------------- End of Section to Allocate Large Arrays ---------------
                        
! Balaji change 12/17 start
real fitting_detection_residual,avg_sectional_angle_of_traj(6000), avg_sectional_speed_of_traj(6000)
real velocity_before_collision(TOTAL_NUMBER_OF_REAL_TRAJECTORIES), velocity_after_collision(TOTAL_NUMBER_OF_REAL_TRAJECTORIES) 
real x_avg_sectional_speed_of_traj(6000),y_avg_sectional_speed_of_traj(6000)
integer is_there_collision(TOTAL_NUMBER_OF_REAL_TRAJECTORIES)
integer collision_time_of_traj(TOTAL_NUMBER_OF_REAL_TRAJECTORIES), traj_number_of_collision_trajectory(TOTAL_NUMBER_OF_REAL_TRAJECTORIES)
integer collision_pair(TOTAL_NUMBER_OF_REAL_TRAJECTORIES,2),centroid_number_of_collision_traj(TOTAL_NUMBER_OF_REAL_TRAJECTORIES)
! Balaji change 12/17end

! Balaji change 12/21
integer track_to_be_joined(TOTAL_NUMBER_OF_REAL_TRAJECTORIES)
!real mean_Y_velocity_at_frame_afo_min_no_vectors_in_window(TOTAL_NUMBER_OF_FRAMES,1000)
!integer  exp_avg_window_by_frame_and_min_vectors_required(TOTAL_NUMBER_OF_FRAMES,1000)

! Other smaller arrays that can be static
real    avg_speed_of_traj(TOTAL_NUMBER_OF_REAL_TRAJECTORIES), avg_angle_of_traj(TOTAL_NUMBER_OF_REAL_TRAJECTORIES) !(real_trajectory_no)
!real    rolling_average_X_velocity_at_frame(TOTAL_NUMBER_OF_FRAMES), rolling_average_Y_velocity_at_frame(TOTAL_NUMBER_OF_FRAMES)
integer real_trajectory_total_length(-1:TOTAL_NUMBER_OF_REAL_TRAJECTORIES) !(real_trajectory_no)

real    x(-100000:TOTAL_NUMBER_OF_CENTROIDS), y(-100000:TOTAL_NUMBER_OF_CENTROIDS)  !!!<--- These values need to be changed in modules_for_Trajectory_Identification.f90 also!!!
integer status_centroid(-100000:TOTAL_NUMBER_OF_CENTROIDS) !!!<--- This values need to be changed in modules_for_Trajectory_Identification.f90 also!!!
integer frame_no_of_a_centroid(-100000:TOTAL_NUMBER_OF_CENTROIDS)
integer is_centroid_in_a_real_trajectory(-100000:TOTAL_NUMBER_OF_CENTROIDS)

! The dimensions of the following arrays are the max number of centroids in a centroid list:
integer centroid_no(TOTAL_NUMBER_OF_CENTROIDS)
integer real_trajectory_no_of_centroid(TOTAL_NUMBER_OF_CENTROIDS), position_of_centroid_in_trajectory(-1:TOTAL_NUMBER_OF_CENTROIDS) 
!real    Particle_Area(TOTAL_NUMBER_OF_CENTROIDS), Particle_Perimeter(TOTAL_NUMBER_OF_CENTROIDS), Feret_Diameter(TOTAL_NUMBER_OF_CENTROIDS) ! I have used these only for the cluster analysis

! The following arrays have dimensions of the max number of frames in a cine file.  Max I have taken so far is around 200,000.
integer no_velocity_vectors_in_averaging_window(TOTAL_NUMBER_OF_FRAMES)
integer no_centroids_in_frame(TOTAL_NUMBER_OF_FRAMES) ! (total number of frames)
integer no_particles_in_frame(TOTAL_NUMBER_OF_FRAMES)
real no_particles_in_frame_by_avg_window(TOTAL_NUMBER_OF_FRAMES)
integer no_real_trajectories_frame(TOTAL_NUMBER_OF_FRAMES) !, frame_no_of_imaginary_centroid(10000)
integer first_centroid_in_frame(TOTAL_NUMBER_OF_FRAMES), last_centroid_in_frame(TOTAL_NUMBER_OF_FRAMES) ! (total number of frames)
real  frame_avg_velocity(TOTAL_NUMBER_OF_FRAMES), area_of_frame_covered_by_particle_images(TOTAL_NUMBER_OF_FRAMES), Relative_Particle_Concentration(TOTAL_NUMBER_OF_FRAMES)
real  local_avg_of_X_velocity(TOTAL_NUMBER_OF_FRAMES), local_avg_of_Y_velocity(TOTAL_NUMBER_OF_FRAMES), avg_angle_this_frame(TOTAL_NUMBER_OF_FRAMES)
real  X_RMS_fluct_comp_vel_using_local_avg_vel(TOTAL_NUMBER_OF_FRAMES), Y_RMS_fluct_comp_vel_using_local_avg_vel(TOTAL_NUMBER_OF_FRAMES)
real  X_RMS_fluct_comp_vel_using_total_avg_this_frame(TOTAL_NUMBER_OF_FRAMES), Y_RMS_fluct_comp_vel_using_total_avg_this_frame(TOTAL_NUMBER_OF_FRAMES)
!real  X_RMS_fluct_comp_vel_using_total_avg_this_subregion
real  x_avg_speed_this_frame_for_clusters(TOTAL_NUMBER_OF_FRAMES), y_avg_speed_this_frame_for_clusters(TOTAL_NUMBER_OF_FRAMES)
real  avg_angle_this_frame_for_clusters(TOTAL_NUMBER_OF_FRAMES), avg_speed_this_frame_for_clusters(TOTAL_NUMBER_OF_FRAMES)
real  x_avg_slip_speed_this_frame_for_clusters(TOTAL_NUMBER_OF_FRAMES),  y_avg_slip_speed_this_frame_for_clusters(TOTAL_NUMBER_OF_FRAMES)
real  avg_slip_angle_this_frame_for_clusters(TOTAL_NUMBER_OF_FRAMES), avg_slip_speed_this_frame_for_clusters(TOTAL_NUMBER_OF_FRAMES)
real  avg_speed_this_frame_for_individual_particles(TOTAL_NUMBER_OF_FRAMES), avg_angle_this_frame_for_individual_particles(TOTAL_NUMBER_OF_FRAMES)
real  x_speed_this_frame_for_individual_particles(TOTAL_NUMBER_OF_FRAMES), y_speed_this_frame_for_individual_particles(TOTAL_NUMBER_OF_FRAMES)
real  x_avg_speed_this_frame_for_individual_particle(TOTAL_NUMBER_OF_FRAMES), y_avg_speed_this_frame_for_individual_particle(TOTAL_NUMBER_OF_FRAMES)
real  avg_angle_this_frame_for_individual_particle(TOTAL_NUMBER_OF_FRAMES), avg_speed_this_frame_for_individual_particle(TOTAL_NUMBER_OF_FRAMES)
real  solids_area_fraction(TOTAL_NUMBER_OF_FRAMES)
integer no_velocity_vectors_this_frame(0:300000) 
real rolling_X_mean_vel_around_this_frame(TOTAL_NUMBER_OF_FRAMES), rolling_Y_mean_vel_around_this_frame(TOTAL_NUMBER_OF_FRAMES) 
real rolling_avg_speed_this_frame(TOTAL_NUMBER_OF_FRAMES), rolling_avg_angle_this_frame(TOTAL_NUMBER_OF_FRAMES), rolling_frame_avg_velocity(TOTAL_NUMBER_OF_FRAMES)
real X_intensity_of_velocity_fluctuations(TOTAL_NUMBER_OF_FRAMES), Y_intensity_of_velocity_fluctuations(TOTAL_NUMBER_OF_FRAMES)
! some post processing parameters added at Ron Breault's request
real  X_RMS_for_ke_regime, Y_RMS_for_ke_regime,X_RMS_for_GT_regime, Y_RMS_for_GT_regime
real  total_fluctuating_energy_ke_regime(TOTAL_NUMBER_OF_FRAMES), total_fluctuating_energy_GT_regime(TOTAL_NUMBER_OF_FRAMES)
real  Granular_Temp_using_frame_averaged_vel(TOTAL_NUMBER_OF_FRAMES), Granular_Temp_using_total_avg_by_frame(TOTAL_NUMBER_OF_FRAMES)
integer no_velocity_vectors_this_frame_ke_regime, no_velocity_vectors_this_frame_GT_regime 
real percent_area_of_frame_covered_by_particle_images(TOTAL_NUMBER_OF_FRAMES)
integer expanded_avg_window_for_local_avg_vel_by_frame(TOTAL_NUMBER_OF_FRAMES)
! this cannot be allocated during runtime because a range must be specified to handle negative centroid numbers for imaginary centroids
integer lower_bound, upper_bound, LB(1), UB(1)

real this_is_a_single_phase_fluid_measurement 


!Trajectory Splicing Arrays --------------------------------------
integer next_trajectory_to_join(TOTAL_NUMBER_OF_REAL_TRAJECTORIES ,2) ! next trajectory to join
integer new_total_traj
integer spliced_trajectory_total_length(TOTAL_NUMBER_OF_SPLICED_TRAJECTORIES), spliced_trajectory_no_of_centroid(TOTAL_NUMBER_OF_CENTROIDS),spliced_position_of_centroid_in_trajectory(TOTAL_NUMBER_OF_CENTROIDS)
!---------------------------------------------------------------------

! Curve Fitting Arrays---------------------------------------------
real xtempo(MAXIMUM_TRAJECTORY_LENGTH), ytempo(MAXIMUM_TRAJECTORY_LENGTH) , fitted_x(MAXIMUM_TRAJECTORY_LENGTH)
real fitted_y(MAXIMUM_TRAJECTORY_LENGTH)
real residual_between_raw_and_fitted_tracks(TOTAL_NUMBER_OF_REAL_TRAJECTORIES )
real track_residual_x(TOTAL_NUMBER_OF_REAL_TRAJECTORIES ),track_residual_y(TOTAL_NUMBER_OF_REAL_TRAJECTORIES ) !currently Not used
integer crossing_points_between_data_and_fitting(20), identified_collision_locations(TOTAL_NUMBER_OF_REAL_TRAJECTORIES ,20)
integer bad_centroid(TOTAL_NUMBER_OF_CENTROIDS);
real x_fitted_along_traj(TOTAL_NUMBER_OF_CENTROIDS), y_fitted_along_traj(TOTAL_NUMBER_OF_CENTROIDS)
!----------------------------------------------------------------------

! ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ End of ARRAY DECLARATION SECTION ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
real X_collisional_time_constant, Y_collisional_time_constant
real individual_part_X_vel_minus_local_avg_X_vel, individual_part_Y_vel_minus_local_avg_Y_vel
real individual_particle_X_vel_minus_total_mean_vel, individual_particle_Y_vel_minus_total_mean_vel
integer no_frames_with_zero_velocity_vectors, no_subregions_with_zero_velocity_vectors_this_subregion

! cluster cutoff freq calc-------------------------------------------
real period_of_cluster_filter, cluster_cutoff_frequency
real rolling_average_window_size_in_frames
!--------------------------------------------------------------------

real does_frame_have_enough_vectors_nearby_for_good_avg(TOTAL_NUMBER_OF_FRAMES)
real avg_window_for_no_cent_per_frame, half_avg_window_for_no_cent_per_frame
real cumulative
real max_no_particles_in_any_frame, limit_on_max_no_cent_in_frame

! Subregion parameters
integer ix, iy, subregion_x, subregion_y
real  X_boundary_subregion_min(100), X_boundary_subregion_max(100)
real  Y_boundary_subregion_min(100), Y_boundary_subregion_max(100)
real  max_area_of_subregion_covered_by_particles, max_no_cent_in_subregion_using_avg_window
integer subregion_x_cc(-100000:TOTAL_NUMBER_OF_CENTROIDS), subregion_y_cc(-100000:TOTAL_NUMBER_OF_CENTROIDS)
real width_of_a_subregion, particle_diameter_in_pixels ! this many particles will fit side-by-side across width
real imposed_limit_on_number_of_particles_in_a_subregion
real total_fluct_energy_all_subregions(TOTAL_NUMBER_OF_FRAMES)
! ******************************************************************
real total_mean_X_velocity_for_all_frames, total_mean_Y_velocity_for_all_frames
integer itraj_no, step_along_traj
real void_fraction
integer no_columns_in_Centroid_input_for_Traj_Ident_file

! Fluctuating component parameters
real X_actual_minus_rolling_mean_velocity, Y_actual_minus_rolling_mean_velocity
integer window_half_width
real cumulative_fluctuating_velocity, fluctuating_velocity

real sum_of_squares_of_Vx_minus_local_avg, sum_of_squares_of_Vy_minus_local_avg
real sum_of_squares_of_Vx_minus_total_mean_Vx, sum_of_squares_of_Vy_minus_total_mean_Vy

!real sum_of_squares_X_vel_minus_roll_X_mean_total_KE_regime, sum_of_squares_Y_vel_minus_roll_Y_mean_total_KE_regime  
!real sum_of_squares_X_vel_minus_roll_X_mean_total_GT_regime, sum_of_squares_Y_vel_minus_roll_Y_mean_total_GT_regime
real sum_of_squares_of_Vx_over_avg_window_minus_local_avg_Vx, sum_of_squares_of_Vy_over_avg_window_minus_local_avg_Vy
real sum_of_squares_of_X_vel_minus_total_X_mean_vel, sum_of_squares_of_Y_vel_minus_total_Y_mean_vel, sum_of_squares_of_Y_vel_total_rolling_Y_mean_vel
real time_constant_for_particle_transport
real area_fraction_at_maximum_packing, area_of_a_subregion
!-------------------------------------

! Variance component parameters (may be used only in bimodal cluster calc, needs to be changed to fluctuating instead)
real x_variance_speed, y_variance_speed, cumulative_X_speed_this_frame, cumulative_Y_speed_this_frame
real cumulative_X_speed_over_avg_window, cumulative_Y_speed_over_avg_window
real cumulative_X_variance_speed, cumulative_Y_variance_speed
real scaling_factor_for_area_covered_by_particles

! Fluct comp and Turbulence Intensity
real turbulence_intensity

! for clusters 
real cumulative_X_slip_speed_this_frame, cumulative_Y_slip_speed_this_frame
real rolling_X_avg_speed_this_frame_for_individual_particle, rolling_Y_avg_speed_this_frame_for_individual_particle, &
rolling_X_avg_speed_this_frame_for_clusters, rolling_Y_avg_speed_this_frame_for_clusters, &
rolling_X_avg_slip_speed_this_frame_for_clusters, rolling_Y_avg_slip_speed_this_frame_for_clusters, &
rolling_avg_speed_this_frame_for_individual_particle, rolling_avg_angle_this_frame_for_individual_particle, &
rolling_avg_speed_this_frame_for_clusters, rolling_avg_angle_this_frame_for_clusters
integer first_frame_of_averaging_window, last_frame_of_averaging_window
integer rolling_average_window, starting_frame_for_averaging, last_frame_for_averaging, temp_frame, window_frame
integer expanded_window_half_width, maximum_allowable_size_of_averaging_window
integer total_number_of_velocity_vectors_in_averaging_window, enough_velocity_vectors_for_good_average, permanent_enough_velocity_vectors_for_good_average, stored_enough_velocity_vectors_for_good_average
integer no_velocity_vectors_this_subregion_total_for_all_frames
integer real_trajectory_of_min_speed, frame_no_of_min_speed
integer real_trajectory_of_max_speed, frame_no_of_max_speed
!----------------------------------------------------
real  distance_between_centroids, distance_between_3_centroids, distance_1_to_cc, distance_0_to_c, distance_p_to_c, c, distance_p_to_cc
integer real_trajectory_no, position_in_real_trajectory, actual_real_trajectories
!------------ define types for functions -----------

real start_window_frame, end_window_frame

!-------exogenous parameters------------------------
real  dt !time between frames in microseconds
real  x_pixels, y_pixels, width_fov, height_fov, fov_width_scale, fov_height_scale, fov_scale  ! fov 
real  vmin, vmax
integer set_velocity_range_for_pseudocoloring_manually
integer  max_no_centroids_per_frame, total_no_centroids, total_no_frames
integer  starting_frame_for_analysis, number_of_frames_to_analyze, number_of_centroids_to_be_analyzed, total_no_frames_in_centroid_file
integer frame_increment, frame_with_max_area_covered_by_particle_images
real max_particle_concentration, particle_diameter, total_pixel_area, total_pixel_area_of_a_camera_frame, max_fraction_of_frame_covered_by_particle_area
real max_area_of_frame_covered_by_particle_images
real pseudocolor_factor, min_average_speed_along_a_trajectory, max_average_speed_along_a_trajectory, v_range
real minimum_angle_from_horiz_for_upward_traj, size_dividing_between_individual_particles_and_clusters ! specific additional criterion to eliminate candidate trajectories from PSRI case
integer debug
integer overall_residual_for_collision_traj_identification, residual_for_collision_point_identification
integer shifting_specular_point_identification, min_size_for_trajectory_fitting
integer order_of_polynomial_for_curve_fitting_trajectories
!------------------------------------------------------


! Switches to use different code features
character(3) Use_particle_size_and_cluster_size_analysis, use_trajectory_splicing
integer decrease_DSA_with_particle_concentration
!------------------------------------------------------

real  cumulative_speed, cumulative_angle
integer  no_centroids_this_frame

!-------------- search parameters
character answer  !Default if length is not specified is 1, so yes=y and no=n
character(3) answer1
character(6) color
character(1) A_temp
integer longest, length_of_longest_trajectory, longest_candidate_trajectory_no
integer  p, c0, c1, c2, c3, cc, ci, imaginary_centroid, no_imaginary_centroids_in_real_trajs
integer frame, candidate_progenitor, candidate_first_descendant
integer t, t1, tt, temp_t1, itemp_t, frame1_temp, frame1, last_cc, first_cc, last_tc
integer total_no_real_trajectories, direction_along_path
real angle_candidate, answer_distance, distance_0_to_1, distance_1_to_2, distance_0_to_cc 
real search_area_translational, search_area_angular, factor, scale_factor, reduction_in_search_parameters_at_max_conc
real search_angle_reference, Acc_min_reference, Acc_max_reference;
real alpha, loop_number, total_number_of_loops, base, angle_jitter, loop
real conc_fraction_at_which_to_apply_stricter_search_parameters
real no_of_bins, bin, count_in_bin(500)
real max_feret_diameter, lower_limit, upper_limit, feret_diameter_in_microns, midpoint_of_bin, upper_limit_of_range_of_cutoff_for_size_analysis
real no_of_increments_size_dividing !no of increments through size_dividing_between_individual_particles_and_clusters for repeating size and velocity analyses
real upper_limit_of_this_bin, lower_limit_of_this_bin, upper_max_limit, cutoff, upper_limit_of_size_distribution_analysis
real total, cutoff_increment
integer total_no_clusters, total_no_individual_particles
integer max_length_real_traj

!----------misc dummy parameters and counters----------
integer centroid_counter, counter1, centroid_counter1, centroid_counter2, next_centroid, frame_counter, next_frame, frame_number  !counters for do loops etc
integer i, j, k, ic, ic1, ct, jc, kc, lc, tc, rt, time1, temp_ic, tempi, i_test, p_test, itemp0, itemp1, itemp2, itemp3, itemp4, itemp_c, itemp_cc, itempt, temp_p
integer cc_temp, istart, iend, itemp, ic_next, icc, icc_next, itemp_frame
real dummy, dummy1, dummy2, dummy3, dummy4, dummy5,  y1_temp,  y2_temp,  y3_temp
real temp,rtemp, rtemp0, rtemp1, rtemp2, rtemp3, rtemp4, rtemp_c, rtemp_t, delta_dx, delta_dy, delta_dx_entire_traj, delta_dy_entire_traj, inverted_y
real spd, temp_max_velocity, first_velocity, last_velocity,velocity_gradient_for_this_trajectory
real delt_x, delt_y, delt_r, degree_traj, skip, x_spd, y_spd, variance_speed, cumulative_variance_speed
!-------------------------------------------------------

! some frame counting parameters------------------------
integer frame_of_first_centroid_in_this_trajectory, frame_of_centroid_before_this_one
integer  temp_cc, first_frame_of_this_real_trajectory, no_consecutive_frames_with_no_centroids, frame_with_no_centroids, average_no_centroids_in_a_frame
real     sign_of_trajectory_speed
!------------------------------------------------------

!--------------- timing parameters --------------------
character(8) fs_date; character(5) fs_zone; character(10) fs2_time; ! variables to time program with
integer fs_values(8)
real fs_time
real time_for_progenitor, start_time, finish_time, elapsed_time
real start_frame_time, end_frame_time, elapsed_time_for_frame, start_calc_time, end_calc_time, total_elapsed_time
!------------------------------------------------------

real cross_sectional_area_of_a_particle

