module modules_for_Standalone_Post_Processing
contains

!-------------find_number_of_centroids_in_each_frame----------------
   subroutine find_number_of_centroids_in_each_frame(total_no_centroids,frame_no_of_a_centroid,no_centroids_in_frame,first_centroid_in_frame,last_centroid_in_frame)
      implicit none
      include 'declarations_section_for_standalone_post_processing.f90'

      frame_number = 1; centroid_counter = 1; no_centroids_in_frame(frame_number)=0; first_centroid_in_frame(1)=1
      frame_no_of_a_centroid(0)=1; ! This avoids the problem of frame_no_of_a_centroid(centroid_counter-1) being out-of-range

      do while (centroid_counter .le. total_no_centroids)
         if ( centroid_counter .eq. 1 .or. frame_no_of_a_centroid(centroid_counter) .eq. frame_no_of_a_centroid(centroid_counter-1) ) then !still in same frame
            no_centroids_in_frame(frame_number) = no_centroids_in_frame(frame_number) + 1
         end if
         
      ! Now that we have counted all of the centroids in this frame, there are three cases for the next frame:
         
      ! CASE_1: next frame has no centroids
         ! Now that the operation is past the last centroid of a frame and to the next centroid, but not necessarily the next frame:
         ! First find out if the next frame has 0 centroids
         no_consecutive_frames_with_no_centroids = ( frame_no_of_a_centroid(centroid_counter) - frame_no_of_a_centroid(centroid_counter-1) )  -  1                  
         if ( no_consecutive_frames_with_no_centroids .gt. 0 ) then ! Encountered a series of frames with no centroids !!!             
            ! Now take care of the last frame before the frame(s) with no centroids
            last_centroid_in_frame(frame_number) = centroid_counter-1
            
            ! Write parameters for the consecutive frame(s) that have no centroids
            do k = 1 , no_consecutive_frames_with_no_centroids        
               frame_with_no_centroids = frame_no_of_a_centroid(centroid_counter-1) + k
               frame_number = frame_with_no_centroids              
               no_centroids_in_frame(frame_number)  = 0     
               first_centroid_in_frame(frame_number) = 0
               last_centroid_in_frame(frame_number) = 0            
            end do  
            
            ! Now that all consecutive frames with no centroids have been taken care of, prepare for the next frame that has centroids
            frame_number = frame_number + 1 ;            
            first_centroid_in_frame(frame_number) = centroid_counter
            no_centroids_in_frame(frame_number)=1 
            go to 2582
         end if
         
      ! CASE_2: next frame has centroids
         if ( centroid_counter .ne. 1 .and. frame_no_of_a_centroid(centroid_counter) .gt. frame_no_of_a_centroid(centroid_counter-1) ) then !at the first centroid of next frame         
            ! Now (remember that 'frame_number' is usually the frame no of the last frame, but if this is after a frame with no centroids, then frame_number
            if(no_consecutive_frames_with_no_centroids .gt. 0) then  ! if frame_number had no centroids, then
               last_centroid_in_frame(frame_number)= centroid_counter
            else
               last_centroid_in_frame(frame_number)= centroid_counter - 1       
            end if
         
            ! Since we're at the first centroid of the next frame, setup for next frame
            frame_number = frame_number + 1 ; 
            first_centroid_in_frame(frame_number) = centroid_counter
            no_centroids_in_frame(frame_number)=1          
         endif
         
     ! CASE_3: At last centroid is centroid list
         if ( centroid_counter .eq. total_no_centroids ) then !at last centroid
            last_centroid_in_frame(frame_number)=centroid_counter
         endif
         
         2582 continue   
         centroid_counter=centroid_counter+1 
      end do
   return; end subroutine find_number_of_centroids_in_each_frame
!-------------------------------------------------------------------


!!!!!!!! Balaji changes start here 11/16
subroutine Curve_fit_traj_with_Cholesky_method(y,fitted_y,n,order_of_polynomial_for_curve_fitting_trajectories,MAXIMUM_TRAJECTORY_LENGTH) 
implicit none
! Balaji Dec_07 

integer MAXIMUM_TRAJECTORY_LENGTH
real  x(MAXIMUM_TRAJECTORY_LENGTH), y(MAXIMUM_TRAJECTORY_LENGTH), fitted_y(MAXIMUM_TRAJECTORY_LENGTH), F(MAXIMUM_TRAJECTORY_LENGTH,10), &


FT(10,MAXIMUM_TRAJECTORY_LENGTH), A1(10,10), B1(10), C1(10)
! Balaji Dec_07 
integer  i, j, k, n, ii, l, m, mp1,no_data, itemp1, itemp2, order_of_polynomial_for_curve_fitting_trajectories
!m = 3;  !FS: Frank changed this
m = order_of_polynomial_for_curve_fitting_trajectories
! This part has been modified from Franks fitting code to be used with any polynomial expansion
do i=1,n ! Generate the time domain matrix
x(i) = i
end do

! F is an nxm matrix, where n is the number of data points, m is the number of coefficients
do i=1,n 
   do j=0,m-1
   if(j .lt. 1) then
   F(i,j+1) = j+1
   else
   F(i,j+1)= x(i)**j  
   end if
   end do 
end do

do i=1,n 
   do j=0,m-1
   if(j .lt. 1) then
   FT(j+1,i) = j+1
   else
   FT(j+1,i)= x(i)**j  
   end if
   end do 
end do


! Determine coefficient matrix A of simultaneous equation system
call matmpy(ft,f,a1,m,n,m,MAXIMUM_TRAJECTORY_LENGTH)
! Determine the column of constants for simultaneous equation system
call matmpy1(ft,y,b1,m,n,1,MAXIMUM_TRAJECTORY_LENGTH)
do i=1,m; 
     a1(i,m+1)=b1(i)
end do;

! Determine c values by solving simultaneous eqn's using Cholesky method
mp1 = m + 1
call chlsky(a1,m,mp1,c1)
do i=1,n;
   do j = 1,m;
   fitted_y(i) = fitted_y(i) + c1(j)*x(i)**(j-1)
   end do;
end do;

return ; end subroutine Curve_fit_traj_with_Cholesky_method

!_______________________________________________________
subroutine matmpy(a,b,c,m,n,l,MAXIMUM_TRAJECTORY_LENGTH)
! determines matrix c as product of a and b
! Balaji Dec_07 
dimension  A(10,MAXIMUM_TRAJECTORY_LENGTH), B(MAXIMUM_TRAJECTORY_LENGTH,10), C(10,10)
! Balaji Dec_07 
! Now multiply FT x F , a mxn X nxm gives an mxm
do i=1,m; 
   do j=1,l;
      C(i,j)=0.0 ;
      do k=1,n; 
         c(i,j)= c(i,j) + a(i,k) * b(k,j);
      end do; 
   end do; 
end do;
return
end subroutine matmpy

subroutine matmpy1(a,b,c,m,n,l,MAXIMUM_TRAJECTORY_LENGTH)
! determines matrix c as product of a and b
! Balaji Dec_07 
dimension  A(10,MAXIMUM_TRAJECTORY_LENGTH), B(MAXIMUM_TRAJECTORY_LENGTH), C(10)
! Balaji Dec_07 
! Now multiply FT x F , a mxn X nxm gives an mxm
do i=1,m; 
   do j=1,l;
      C(i)=0.0 ;
      do k=1,n; 
         c(i)= c(i) + a(i,k) * b(k);
      end do; 
   end do; 
end do;
return
end subroutine matmpy1
!_______________________________________________________

! ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
subroutine chlsky(a,n,m,x)
dimension  A(10,10), x(10)
! calc first row of upper unit triangular matrix
do j=2,m ; a(1,J) = a(1,J) / a(1,1) ; end do
! calc other elements of U and L matrices
do i = 2,n !8
   j=i
   do ii = j,n !5
      sum=0
      jm1=j-1
      do k=1,jm1; sum = sum + a(ii,k) * a(k,j); end do !4
      a(ii,j) = a(ii,j) - sum
   end do !5
   ip1 = i + 1
   do jj=ip1,m !7
      sum=0.
      im1=i-1
      do k=1, im1; sum = sum + a(i,k) * a(k,jj); end do !6
   a(i,jj) = ( a(i,jj) - sum ) / a(i,i)
   end do !7
end do !8
! solve for x(i) by back substitition
x(n) = a(n,n+1)
l = n - 1
do nn = 1 , l !10
   sum=0.
   i=n-nn
   ip1=i+1
   do j=ip1,n ; sum = sum + a(i,j) * x(j); end do !9
   x(i) = a(i,m) - sum
end do
return
end subroutine chlsky
! ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
! Balaji changes end here 11/16

end module modules_for_Standalone_Post_Processing


