! Trajectory Identification by F.Shaffer
!include 'modules_for_Trajectory_Identification.f90'
!include 'module_declarations_section.f90'
!include 'module_subroutines.f90'

include 'module_subroutines'

program Trajectory_Identification
use module_subroutines

include 'declarations_section'
include 'open_statements_for_Trajectory_Identification.f90'
include 'read_general_exogenous_parameters.f90' 
include 'allocate_large_arrays.f90'
include 'read_particle_recognition_data.f90'
include 'write_headers_for_output_files.f90'
call cpu_time(start_calc_time); 

candidate_trajectory_no = 0; no_cand_traj_this_tree = 0; longest_candidate_trajectory_no = 0; do j=1,10000; candidate_trajectory_total_length(j) = 0; end do
real_trajectory_no = 0;  total_no_real_trajectories = 0; ci = 0; no_imaginary_centroids_in_real_trajs = 0; no_cand_traj_this_tree = 0; t=0 ; imaginary_centroid = 0;
loop_number = 1;  alpha = (loop_number - 1) / (total_number_of_loops - 1);
prog_search_Velocity_in_mps = min_prog_search_Velocity_in_mps ! + (max_prog_search_Velocity_in_mps - min_prog_search_Velocity_in_mps)* alpha**exponent_search_velocity; alpha = loop_number / total_number_of_loops;
!!!!!!!!!!!!!!!!!!!!!!! Loop through Search Velocity !!!!!!!!!!!!!!!!!!!!!!!!!!!!
do 1 while (prog_search_Velocity_in_mps .le. max_prog_search_Velocity_in_mps); ! call cpu_time(start_prog_search_V_loop)
   prog_search_Velocity = prog_search_Velocity_in_mps/fov_scale; max_prog_search_Velocity = max_prog_search_Velocity_in_mps / fov_scale 
      !!!!!!!!!!!!!!!!!!!!!!! Loop through Frames !!!!!!!!!!!!!!!!!!!!!!!!!!!!
      do 2 t1 = starting_frame_for_analysis, starting_frame_for_analysis + number_of_frames_to_analyze;  !call cpu_time(start_frame_loop_2) 
         if(no_centroids_in_frame(t1) .eq. 0) go to 1002 ! If this frame at time t has no centroids, skip it         
         include 'set_Descendant_Search_Area_dimensions_afo_search_velocity.f90' 
         if(debug .gt. 0.1) WRITE(945,2141) t1, prog_search_Velocity_in_mps, first_centroid_in_frame(t1), last_centroid_in_frame(t1) 
         2141 format(/,'***************************************************************',/,'Going into search process for frame ',i7,' with next Search Velocity =',f8.3,' mps',/,&
         'first_centroid_in_frame =',i7,' and last_centroid_in_frame=',i7,/);
         include 'write_screen_output.f90'
         direction_along_path=1 ;   candidate_progenitor = first_centroid_in_frame(t1) 

         !!!!!!!!!!!!!!!!!!!!!!! Loop through Candidate_Progenitors !!!!!!!!!!!!!!!!!!!!!!!!!!!!
         do 5 while ( candidate_progenitor .le. last_centroid_in_frame(t1) ); ! call cpu_time(start_progenitor_loop_5)
            candidate_trajectory_no = 0; no_cand_traj_this_tree = 0; candidate_trajectory_tree = candidate_progenitor; longest_candidate_trajectory_no = 0
            do j=1,10000; candidate_trajectory_total_length(j) = 0; end do            
            t = t1 + 1 ; 
            candidate_first_descendant = first_centroid_in_frame(t) ; 
            if(status_centroid(candidate_progenitor) .eq. 111) then;
               !if(debug .gt. 0) !write(945,8818) candidate_progenitor,status_centroid(candidate_progenitor); 8818 format('Status of candidate_progenitor',i8,' is ',i5,' so go to 59 and test next candidate_progenitor')
               go to 59               
            end if

            !!!!!!!!!!!!!!!!!!!!!!! Loop through First_Descendants !!!!!!!!!!!!!!!!!!!!!!!!!!!!
            do 10 while ( candidate_first_descendant .le. last_centroid_in_frame(t) )  ; !  call cpu_time(start_1st_desc_loop_10);
               if(status_centroid(candidate_first_descendant) .eq. 111) go to 109
               if(debug .gt. 0.1) write(945,2192) t1, candidate_progenitor, candidate_first_descendant, t; 
               2192 format('Going into desc search at frame=',i9,'  for p = ',i9,'  to test if 1st_desc =',i9,' in frame',i6,' is in PSA')
               !if(debug .gt. 0.1) write(945,2192) t1, candidate_progenitor, candidate_first_descendant; 2192 format('frame=',i9,'     p = ',i9,'     test if 1st_desc =',i9,' is in PSA')
               call is_cand_1st_descendant_in_progenitor_search_area(dt,prog_search_Velocity,x,y,candidate_progenitor,candidate_first_descendant,status_centroid,distance_to_detect_very_slow_particles,answer,debug,use_additional_exogenous_criteria_for_real_trajs, max_distance_between_cent_of_a_traj) 
               if (answer .eq. 'n') then; candidate_first_descendant = candidate_first_descendant + 1; go to 10; end if       
               if(debug .gt. 0.1) write(945,21921) candidate_progenitor, candidate_first_descendant, t1 ; 
               21921 format('p = ',i9,'     YES 1st_desc =',i9,' is in PSA!',/,' Go to Tree Growing Process and search frame ',i8,' for a 2nd_Generation_Desc' )   
               !if(debug .gt. 0.1) write(945,21921) candidate_progenitor, candidate_first_descendant, t1 ; 21921 format('p = ',i9,'     YES 1st_desc =',i9,' is in PSA!',/,' Go to Tree Growing Process and search frame ',i8,' for a 2nd_Generation_Desc' )
               include 'setup_for_new_tree_growing_with_this_prog-1st_desc_pair.f90'             
               include 'tree_growing_process.f90'            
109            continue
               include 'reset_parameters_for_next_1st_descendant_.f90'
               !if(debug .gt. 0.1) !write(945,1126) candidate_first_descendant, candidate_progenitor, t1 ; 1126 format('Continue PSA search with next 1st_Desc=',i8,' for p=',i6,': in frame',i6,/)
10          end do !!!!!!!!!!!!!!!!!!!!!!! End of Loop through Candidate_Progenitors !!!!!!!!!!!!!!!!!!!!!!!!!!!!

            include 'find_real_trajectory_from_candidate_trajectory_tree.f90' 
59          continue

            include 'reset_parameters_for_next_progenitor.f90'
5        end do  !!!!!!!!!!!!!!!!!!!!!!! End Loop through Candidate_Progenitors !!!!!!!!!!!!!!!!!!!!!!!!!!!!
         include 'reset_parameters_for_next_frame.f90'
         !call cpu_time(end_frame_loop_2); elapsed_time_for_this_frame = end_frame_loop_2 - start_frame_loop_2; 
         !write(555,5557) t1, elapsed_time_for_this_frame; 5557 format('t=',i8,'  total time for this frame = ',e12.6)        
         1002 continue
2     end do  !!!!!!!!!!!!!!!!!!!!!!! End Loop through Frames !!!!!!!!!!!!!!!!!!!!!!!!!!!!
   total_no_real_trajectories = real_trajectory_no; 
   loop_number = loop_number + 1; 
   alpha = (loop_number - 1) / (total_number_of_loops - 1)
   prog_search_Velocity_in_mps = min_prog_search_Velocity_in_mps +(max_prog_search_Velocity_in_mps - min_prog_search_Velocity_in_mps)* alpha**exponent_search_velocity
1 end do ; !!!!!!!!!!!!!!!!!!!!!!! End Search Velocity Loop !!!!!!!!!!!!!!!!!!!!!!!!!!!
!include 'write_raw_data_for_Standalone_Post_Processing.f90'
include 'Calculate_min_and_max_traj_speed_found.f90'
include 'write_real_trajs_to_MTrackJ_file_MANUAL_coloring_into_sep_files.f90'
include 'Final_writes_to_screen.f90'
end program Trajectory_Identification

