! calc_speed_and_angle_along_a_fitted_traj.f90 
! Written by Balaji Nov 2009, adopted from Frank's code  "calc speed and traj"
cumulative_speed = 0; cumulative_angle = 0
do tc = 1,200 ! Avoiding a longer trajectory affecting a smaller one
   xtempo(tc) = 0
   ytempo(tc) = 0
   fitted_x(tc) = 0
   fitted_y(tc) = 0
end do
   
do  tc = 1 ,real_trajectory_total_length(real_trajectory_no)  ! Read a Trajectory
  c1 = real_trajectory_centroid(real_trajectory_no,tc);  
  xtempo(tc) = x(c1);
  ytempo(tc) = y(c1);
end do

! Fit x(t) using modified version of Franks code
call Curve_fit_traj_with_Cholesky_method(xtempo,fitted_x,real_trajectory_total_length(real_trajectory_no),order_of_polynomial_for_curve_fitting_trajectories);  
! Fit y(t) using modified version of Franks code
call Curve_fit_traj_with_Cholesky_method(ytempo,fitted_y,real_trajectory_total_length(real_trajectory_no),order_of_polynomial_for_curve_fitting_trajectories);  
  
! This portion is identical to calc_speed_and_angle_along_a_real_traj.f90   
do  tc = 1 ,real_trajectory_total_length(real_trajectory_no)! scan of length of a real trajectory         
   if ( tc .lt. real_trajectory_total_length(real_trajectory_no)) then
      c1 = real_trajectory_centroid(real_trajectory_no,tc);  c2 = real_trajectory_centroid(real_trajectory_no,tc+1)
      delta_dx = fitted_x(tc+1)-fitted_x(tc); delta_dy = fitted_y(tc+1)-fitted_y(tc)
      distance_between_centroids = sqrt( delta_dx**2.0 + delta_dy**2.0 ) 
      if( abs(delta_dx) .lt. 0.01 ) delta_dx = 0.01;          
      
      angle_along_traj = atan( delta_dy / delta_dx )  
      speed_along_traj = ( distance_between_centroids / dt ) * fov_scale

      !angle_along_traj(real_trajectory_no, tc) = atan( delta_dy / delta_dx )  
      !speed_along_traj(real_trajectory_no, tc) = ( distance_between_centroids / dt ) * fov_scale

      !x_speed_along_traj = cos(angle_along_traj(real_trajectory_no, tc)) * speed_along_traj(real_trajectory_no, tc)
      !y_speed_along_traj = sin(angle_along_traj(real_trajectory_no, tc)) * speed_along_traj(real_trajectory_no, tc)

      x_speed_along_traj = cos(angle_along_traj) * speed_along_traj
      y_speed_along_traj = sin(angle_along_traj) * speed_along_traj

      ! x_speed_along_traj(real_trajectory_no, tc) = ( delta_dx / dt ) * fov_scale ! This has sign +/- to indicate direction!
      ! y_speed_along_traj(real_trajectory_no, tc) = ( delta_dy / dt ) * fov_scale ! This has sign +/- to indicate direction!         

      !  writes to 'speed_and_angle_along_traj.txt'
      write(505, 5606) t1+tc-1, real_trajectory_no, tc, c1, &
                        fitted_x(tc), fitted_y(tc), & 
                        speed_along_traj, angle_along_traj*57.295779, &                          
                        x_speed_along_traj, y_speed_along_traj
      5606 format( i6,2x,i8,3x,i3,4x,i7,   2(3x,f7.2),   2(3x,f9.5),   2(3x,f9.5)  )
      cumulative_speed = cumulative_speed + abs(speed_along_traj)
      
      ! Writes to raw_data_by_trajectory_for_post_processing.txt
      write(610,4002) real_trajectory_no,  tc,   frame_no_of_a_centroid(cc),  cc, x(cc), y(cc), speed_along_traj,angle_along_traj*57.295779
   else
      ! Don't write velocity for last centroid, because there is not a next centroid from which to calculate velocity
      write(505, 5616) t1+tc-1, real_trajectory_no, tc, c2, fitted_x(tc), fitted_y(tc)
      5616 format( i6,2x, i8,3x, i3,4x, i7,   2(3x,f7.2)  )    
      write(610,4002) real_trajectory_no,  tc,   frame_no_of_a_centroid(cc),  cc, x(cc), y(cc)
   end if    
end do  ! this is the end of the 66 do loop.    
4002 format(        i7,',',            2x,i7,','       ,2x,i7,',',                1x,i9,',',  2(2x,f8.1,','),  5x,f13.7,',',5x,f13.7   ) ;   

! Now calculate the avarege speed and angle along the trajectory
no_real_trajectories_frame(t-1) = no_real_trajectories_frame(t-1) + 1 !This is the number of trajectories that start in this frame
first_cc = real_trajectory_centroid(real_trajectory_no,1);
itemp  = real_trajectory_total_length(real_trajectory_no); last_cc  = real_trajectory_centroid(real_trajectory_no, itemp)
delta_dx_entire_traj = ( fitted_x(real_trajectory_total_length(real_trajectory_no)) - fitted_x(1) ); if( abs(delta_dx_entire_traj) .lt. 0.01) delta_dx_entire_traj =  0.01;        
delta_dy_entire_traj = ( fitted_y(real_trajectory_total_length(real_trajectory_no)) - fitted_y(1) ); if( abs(delta_dy_entire_traj) .lt. 0.01) delta_dy_entire_traj =  0.01;        
avg_angle_of_traj(real_trajectory_no) = atan( delta_dy_entire_traj / delta_dx_entire_traj ) 
avg_speed_of_traj(real_trajectory_no) = cumulative_speed / ( itemp - 1)  

! This writes to 'average_fitted_speed_and_angle_by_trajectory.txt'
write(515, 6656) real_trajectory_no, frame_no_of_a_centroid(first_cc), avg_speed_of_traj(real_trajectory_no), avg_angle_of_traj(real_trajectory_no)* 57.295779 
             ! , first_cc, last_cc, itemp, x(first_cc), y(first_cc), x(last_cc), y(last_cc), sign_of_trajectory_speed
6656 format(i7,6x,i7,10x,f12.5,12x,f12.5)
