! calc_speed_and_angle_along_a_real_traj.f90
cumulative_speed = 0; cumulative_angle = 0
   do 66 tc = 1 , (   real_trajectory_total_length(real_trajectory_no) -1 ) ! scan of length of a real trajectory
      if ( tc .lt. real_trajectory_total_length(real_trajectory_no)) then
         c1 = real_trajectory_centroid(real_trajectory_no,tc);  c2 = real_trajectory_centroid(real_trajectory_no,tc+1)
         delta_dx = x(c2) - x(c1);  delta_dy = y(c2) - y(c1) 
         distance_between_centroids = sqrt( delta_dx**2.0 + delta_dy**2.0 ) 
         
         !If delta_dx is 0 or too close to zero, it will cause Nan in the atan calculation, so make it slightly larger than 0.
         if( abs(delta_dx) .lt. 0.0001 ) delta_dx = 0.0001;          
         
         angle_along_traj = atan( delta_dy / delta_dx ) 
         speed_along_traj = ( distance_between_centroids / dt ) * fov_scale
         x_speed_along_traj = cos(angle_along_traj) * speed_along_traj
         y_speed_along_traj = sin(angle_along_traj) * speed_along_traj
         ! x_speed_along_traj = ( delta_dx / dt ) * fov_scale ! This has sign +/- to indicate direction!
         ! y_speed_along_traj(real_trajectory_no, tc) = ( delta_dy / dt ) * fov_scale ! This has sign +/- to indicate direction!         
         
        ! No longer write to 'speed_and_angle_along_traj.txt' because the same data is in 'raw_data_by_trajectory_for_post_processing.txt'
        ! write(500, 560) t1+tc-1, real_trajectory_no, tc, c1, x(c1), y(c1), & 
         !                 speed_along_traj(real_trajectory_no,tc), angle_along_traj(real_trajectory_no, tc)*57.295779 !, x_speed_along_traj, y_speed_along_traj
         ! Now write 'speed_and_angle_along_traj.txt' to input folder of Standalone_Post_Processing
         !write(2199, 560) t1+tc-1, real_trajectory_no, tc, c1, x(c1), y(c1), & 
         !                 speed_along_traj(real_trajectory_no,tc), angle_along_traj(real_trajectory_no, tc)*57.295779, x_speed_along_traj, y_speed_along_traj
         cumulative_speed = cumulative_speed + abs(speed_along_traj)
      end if     
      !560 format( i7, 2x,i8, 4x,i7,  4x,i9,   2(2x,f8.1),   2(3x,f13.8))  !,   2(3x,f13.8)  )
      !561 format( i7, 2x,i8, 4x,i7,  4x,i9,   2(2x,f8.1))  
       
   66 end do  ! this is the end of the 66 do loop.      
   
   no_real_trajectories_frame(t-1) = no_real_trajectories_frame(t-1) + 1 !This is the number of trajectories that start in this frame
   first_cc = real_trajectory_centroid(real_trajectory_no,1);
   itemp  = real_trajectory_total_length(real_trajectory_no) ; last_cc  = real_trajectory_centroid(real_trajectory_no, itemp)

   delta_dx_entire_traj = ( x(last_cc) - x(first_cc) ); if( abs(delta_dx_entire_traj) .lt. 0.01) delta_dx_entire_traj =  0.01;        
   delta_dy_entire_traj = ( y(last_cc) - y(first_cc) ); if( abs(delta_dy_entire_traj) .lt. 0.01) delta_dy_entire_traj =  0.01;        
   avg_angle_of_traj(real_trajectory_no) = atan( delta_dy_entire_traj / delta_dx_entire_traj ) 

   avg_speed_of_traj(real_trajectory_no) = cumulative_speed / ( itemp - 1)  

   ! This writes to 'average_speed_and_angle_by_trajectory.txt'
   write(510, 665) real_trajectory_no, frame_no_of_a_centroid(first_cc), avg_speed_of_traj(real_trajectory_no), avg_angle_of_traj(real_trajectory_no)* 57.295779 
                ! , first_cc, last_cc, itemp, x(first_cc), y(first_cc), x(last_cc), y(last_cc), sign_of_trajectory_speed
   665 format(i7,6x,i7,10x,f12.5,12x,f12.5)
   ! This writes 'average_speed_and_angle_by_trajectory.txt' to the Standalone Post Processing input folder
   !write(7990, 665) real_trajectory_no, frame_no_of_a_centroid(first_cc), avg_speed_of_traj(real_trajectory_no), avg_angle_of_traj(real_trajectory_no)* 57.295779

   !_______________________________________________________________________
   !if(Use_particle_size_and_cluster_size_analysis .eq. 'Yes') then
   !   write(1010,10101) real_trajectory_no,  &
   !                  Avg_particle_area_for_trajectory(real_trajectory_no)* fov_scale * 1e6, &
   !                  Avg_particle_perimeter_for_trajectory(real_trajectory_no)* fov_scale * 1e6, & 
   !                  Avg_particle_feret_dia_for_trajectory(real_trajectory_no)* fov_scale * 1e6, &
   !                  avg_speed_of_traj(real_trajectory_no), avg_angle_of_traj(real_trajectory_no)*360/(2.0*3.14159), frame_no_of_a_centroid(first_cc),&
   !                  x(real_trajectory_centroid(real_trajectory_no,1)),y(real_trajectory_centroid(real_trajectory_no,1))
   !   10101 format( i8, 3x, 3(f8.1,6x), 5x, f8.4, 10x, f8.3, 2x, i8, 2(3x,f6.1))
   !end if
   !_______________________________________________________________________