! post_processing_during_run.f90
! _____________________________________________________________________________________________________________________________
! _________________Write the MTrackJ data file "MTrackJ_Input_Real_Trajectory_File_automatic_coloring.mdf"_____________________
!include 'Calculate_min_and_max_traj_speed_found.f90'
!do i = 1 , total_no_real_trajectories
  ! Here I set the pseudocoloring automatically. In 'write_real_trajectory_to_MTrackJ_input_file.f90' I calculate the pseudocoloring manually as set in Exogenous Input
!  vmin = min_average_speed_along_a_trajectory; vmax = max_average_speed_along_a_trajectory;   if(vmin .lt. 0) vmin = 0.0 ;  v_range = vmax - vmin 

  !NOV9  
  !include 'Pseudocolor_trajectories_for_MTrackJ.f90'

! Now write to input file for ImageJ MTrackJ, MTrackJ_real_trajectories_colored.mdf    
!      write(199,5990) i, color ; 5990 format('Track ',i8,3x,A6); 
!      do tc = 1 , ( real_trajectory_total_length(i) ) ! scan of length of a real trajectory   
!         ic = real_trajectory_centroid(i,tc)      
         ! Note that y is inverted, since I now am using the regular origin in lower left, lower right of the FOV, not ImageJ's goofy origin in upper left.
!         inverted_y = y_pixels - y(ic)
!         write(199,5897) tc, x(ic), inverted_y , frame_no_of_a_centroid(ic) !, ic, x(ic), y(ic) ;  ! Write real traj point to MTrackJ file        
!      end do
!      5897 format('Point ',i8,1x,f6.1,1x,f6.1,1x,'1.0',1x,i5,1x,'1.0') !,10x,' centroid#=',i8,' x(ic)=',f10.2,'  y(ic)=',f10.2); 
!end do
!write(199,3893); 3893 format('End of MTrackJ Data File')
! _________________ End of writing MTrackJ data file __________________________________________________________________________
! _____________________________________________________________________________________________________________________________

! NOV9
!include 'Calc_Mean_and_Fluct_Comp_of_Vel_and_Gran_Temp_Parameters.f90'

! Do particle size and cluster analyses ????
!if(Use_particle_size_and_cluster_size_analysis .eq. 'Yes') then 
   !include 'calc_trajs_of_individual_part_and_clusters_separately.f90'
   !NOV9
   !include 'Particle_size_and_cluster_size_analysis.f90'
!end if

! ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
! ^^^^^^^^^^^^^^^^^^^^^ Write all values needed for Standalone_Post_Processing.f90 after run is finished ^^^^^^^^^^^^^^^^^^^^^
! ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
! Write the values along each real trajectory to "raw_data_by_trajectory_for_post_processing.txt"
write(9000,*) total_no_real_trajectories
do real_trajectory_no = 1, total_no_real_trajectories 
   write(9000,*) real_trajectory_no, real_trajectory_total_length(real_trajectory_no)
   do tc = 1 , ( real_trajectory_total_length(real_trajectory_no) ) ! scan of length of a real trajectory
     ! Returns the value for "frame_containing_real_or_imaginary_centroid(cc)" for any tc of a real trajectory
      cc = real_trajectory_centroid(real_trajectory_no,tc) ! The centroid number of this centroid along the traj     
     ! This used to write to raw_data_by_trajectory_for_post_processing.txt, but the data is exactly the same in 'speed_and_angle_along_traj.txt' so use that instead    
     if( tc .lt. real_trajectory_total_length(real_trajectory_no) ) then
        write(9000,4002) real_trajectory_no,  tc,   frame_no_of_a_centroid(cc),  cc, x(cc), y(cc), speed_along_traj(real_trajectory_no,tc),angle_along_traj(real_trajectory_no,tc)*360/(2.0*3.14159)
     else ! Don't write speed and angle for last centroid in a traj
        write(9000,4002) real_trajectory_no,  tc,   frame_no_of_a_centroid(cc),  cc, x(cc), y(cc)
     end if
     4002 format(        i7,2x,            i7,2x,       i7,                1x,i9, 2(2x,f8.1),6x, 2(10x,f13.7) ) ;   
   end do
end do

!do ic = -total_number_of_imaginary_centroids, total_no_centroids
!   write(7100,7101) ic, x(ic), y(ic), frame_no_of_a_centroid(ic) 
!   7101 format(i9,3x,f9.1,2x,f9.1,2x,i8)
!end do


! ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
! ^^^^^^^^^^^^^^^^^^ End writing all values needed for Standalone_Post_Processing.f90 after run is finished ^^^^^^^^^^^^^^^^^^
! ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

