! read_particle_analysis_data.f90
! __________________ Start of section to read centroid data ____________________
! _________________________________________________________________________________________________________
! _________________________________________________________________________________________________________
! _______________ Start of section to read area of frame covered by particle images__________________________
! Read particle concentration by frame. 
! The input file is named "Particle_Area_input_for_Traj_Ident.txt" and is in the input folder
! First scan through file to find total_no_frames

126 format (a1);  ! this reads only the first letter of the first line, which is a text header from ImageJ

total_pixel_area_of_a_camera_frame = x_pixels*y_pixels; 

include 'read_area_of_frame_covered_by_particles_calc_conc.f90'
include 'read_particle_centroid_data.f90'

print*,' '; print*,'Begin counting the number of centroids in each frame;'
call find_number_of_centroids_in_each_frame(total_no_centroids,frame_no_of_a_centroid,no_centroids_in_frame,first_centroid_in_frame,last_centroid_in_frame,debug)
print*,'Finished counting the number of centroids in each frame;'

if (debug .gt. 0.1) then
   ! Write some data for checking and verification that reads worked
   Print*, 'Writing debug data for centroid and area files'
   do i=1,number_of_frames_to_analyze  ! unit 1113 is file 'NUMBER_centroids_in_each_frame.txt'
     write(940,*) i, no_centroids_in_frame(i), first_centroid_in_frame(i), last_centroid_in_frame(i)
   end do
end if

call beepqq (1000, 500);call beepqq (2000, 500);call beepqq (3000, 500); !call beepqq (3000, 500);call beepqq (4000, 500);call beepqq (5000, 500);
call cpu_time(finish_time); elapsed_time=finish_time-start_time;
write(*,8133) total_no_centroids, elapsed_time
8133 format(/,'Finished reading',i8,' centroids in',f12.5,' seconds')
print*,' --------------------------------------------------- '
print*, ' '
write(*,1251) number_of_frames_to_analyze ; 1251 format('>>>>>>>>>> ',i7,' FRAMES WILL BE ANALYZED <<<<<<<<<');

if(debug .gt. 0.1) then
   print*, ' '
   print*, '---- Debugging is turned on! ---------------------------------------------'
   print*, '---- Creates very large output files. Run for min no frames necessary! ---'
   print*, ' '
end if

! Clear some parameters for later use
do ic=1, total_no_centroids; real_trajectory_no_of_centroid(ic)=0; position_of_centroid_in_trajectory(ic)=0; end do


