! set_Descendant_Search_Area_dimensions_afo_search_velocity.f90

! The following decreases search parameters with increasing search velocity
! The parameter "factor" goes from 0 to 1
factor = (prog_search_Velocity_in_mps - min_prog_search_Velocity_in_mps) /( max_prog_search_Velocity_in_mps - min_prog_search_Velocity_in_mps)
min_length_real_traj = min_length_real_traj_start + (min_length_real_traj_end - min_length_real_traj_start)*factor
max_length_real_traj = max_length_real_traj_start + (max_length_real_traj_end - max_length_real_traj_start)*factor

! FS change starts here Dec 31, 09.  max_length_real_traj was causing problems in terminating trajectories in tree_growing_process
! so comment this out now but return it later
!max_no_images_across_fov = 0.5*3.1416 * width_fov / (prog_search_Velocity_in_mps * dt) ! 0.5*3.1416*0.0056/(3.25*0.000333)
!if(max_length_real_traj .gt. max_no_images_across_fov) max_length_real_traj = max_no_images_across_fov
! FS change end here Dec 31, 09.

search_angle = search_angle_end + (search_angle_start - search_angle_end) * base ** ( min_prog_search_Velocity_in_mps - prog_search_Velocity_in_mps )
Acc_min   =         Acc_min_end + (     Acc_min_start -   Acc_min_end)    * base ** ( min_prog_search_Velocity_in_mps - prog_search_Velocity_in_mps )
Acc_max   =         Acc_max_end + (     Acc_max_start -   Acc_max_end)    * base ** ( min_prog_search_Velocity_in_mps - prog_search_Velocity_in_mps )

write(975,9751) prog_search_Velocity_in_mps, base, search_angle, Acc_min, Acc_max
9751 format(f10.5,13x,f10.5,3x,f10.5,7x,f10.5,3x,f10.5,3x)

search_angle_reference = search_angle; Acc_min_reference = Acc_min; Acc_max_reference = Acc_max; ! Save original values for changing in tree_growing_process.f90

! Jitter Angle:  note that I have negated this operation because the Jitter Angle was very large.  Need to check it.
angle_jitter = acos ( particle_diameter / prog_search_Velocity_in_mps * dt )
if (angle_jitter .gt. search_angle) search_angle = search_angle * 1.25
if (Acc_min .lt.  particle_diameter /(2 * prog_search_Velocity_in_mps * dt) ) Acc_min = 1.25*Acc_min !particle_diameter /(2 * prog_search_Velocity_in_mps * dt); 
if (Acc_max .lt.  particle_diameter /(2 * prog_search_Velocity_in_mps * dt) ) Acc_max = 1.25*Acc_max !particle_diameter /(2 * prog_search_Velocity_in_mps * dt);
!

