! write_fitted_trajs_to_MTrackJ_file_MANUAL_coloring.f90

! _________________ PSEUDOCOLOR TRAJECTORIES FOR MTRACKJ FILE ___________________________________
! Since this writes a real trajectory during the trajectory finding process, we don't know the actual range of velocities that will be found
! So set velocity range manually for coloring trajectories.  This will pseudocolor according to magnitude only, not direction 
  !   vmin = vmin_manually ; vmax = vmax_manually; v_range = vmax - vmin
  !   Since vmin and v_range are no longer calculated in the Trajectory_Identification code, I'll just guess some values for coloring fitted traj's
  
  vmin = 0 ; v_range = 4
  
  
  ! The next line uses abs so that negative velocities are pseudocolored according to magnitude only, not direction
  spd= abs( avg_speed_of_traj(real_trajectory_no));   
      if( spd .ge. vmin+0.00*v_range .and. spd .lt. vmin+0.05*v_range ) color='1B1A5F'
      if( spd .ge. vmin+0.05*v_range .and. spd .lt. vmin+0.10*v_range ) color='113279'
      if( spd .ge. vmin+0.10*v_range .and. spd .lt. vmin+0.15*v_range ) color='0A5397'
      if( spd .ge. vmin+0.15*v_range .and. spd .lt. vmin+0.20*v_range ) color='106CAC'
      if( spd .ge. vmin+0.20*v_range .and. spd .lt. vmin+0.25*v_range ) color='147CB5'
      if( spd .ge. vmin+0.25*v_range .and. spd .lt. vmin+0.30*v_range ) color='159BD4'
      if( spd .ge. vmin+0.30*v_range .and. spd .lt. vmin+0.35*v_range ) color='0994A6'
      if( spd .ge. vmin+0.35*v_range .and. spd .lt. vmin+0.40*v_range ) color='0E8C62'
      if( spd .ge. vmin+0.40*v_range .and. spd .lt. vmin+0.45*v_range ) color='039331'
      if( spd .ge. vmin+0.45*v_range .and. spd .lt. vmin+0.50*v_range ) color='339C1E'
      if( spd .ge. vmin+0.50*v_range .and. spd .lt. vmin+0.55*v_range ) color='69B011'
      if( spd .ge. vmin+0.55*v_range .and. spd .lt. vmin+0.60*v_range ) color='92C00E'
      if( spd .ge. vmin+0.60*v_range .and. spd .lt. vmin+0.65*v_range ) color='B5CC0A'
      if( spd .ge. vmin+0.65*v_range .and. spd .lt. vmin+0.70*v_range ) color='E6E209'
      if( spd .ge. vmin+0.70*v_range .and. spd .lt. vmin+0.75*v_range ) color='FCCF03'
      if( spd .ge. vmin+0.75*v_range .and. spd .lt. vmin+0.80*v_range ) color='ED9E0A'
      if( spd .ge. vmin+0.80*v_range .and. spd .lt. vmin+0.85*v_range ) color='DD680B'
      if( spd .ge. vmin+0.85*v_range .and. spd .lt. vmin+0.90*v_range ) color='D44B0D'
      if( spd .ge. vmin+0.90*v_range                                  ) color='FF0000'

! Now write this real trajectory to input file for ImageJ MTrackJ, MTrackJ_Input_Real_Trajectory_File_automatic_MANUALLY.mdf    
      write(810,59701) real_trajectory_no, color; 59701 format('Track ',i8,3x,A6); 
      do tc = 1 , ( real_trajectory_total_length(real_trajectory_no) ) ! scan of length of a real trajectory   
         ic = real_trajectory_centroid(real_trajectory_no,tc)      
         ! Note that y is inverted, since I now am using the regular origin in lower left, lower right of the FOV, not ImageJ's goofy origin in upper left.
         inverted_y = y_pixels - y(ic)
         write(810,5810) tc, x(ic), inverted_y, frame_no_of_a_centroid(ic) !, ic, x(ic), y(ic);  ! Write real traj point to MTrackJ file        
      end do
      5810 format('Point ',i8,1x,f6.1,1x,f6.1,1x,'1.0',1x,i7,1x,'1.0')   !,10x,' cent=',i8,' x(cent)=',f10.2,'  y(cent)=',f10.2); 
! _________________ END OF PSEUDOCOLOR REAL TRAJECTORY MANUALLY FOR MTRACKJ FILE ___________________________________