! write_real_trajs_to_MTrackJ_file_MANUAL_coloring.f90

! _________________ PSEUDOCOLOR TRAJECTORIES FOR MTRACKJ FILE ___________________________________
! Since this writes a real trajectory during the trajectory finding process, we don't know the actual range of velocities that will be found
! So set velocity range manually for coloring trajectories.  This will pseudocolor according to magnitude only, not direction 
  vmin = vmin_manually ; vmax = vmax_manually; v_range = vmax - vmin

  ! The next line uses abs so that negative velocities are pseudocolored according to magnitude only, not direction
  spd= abs( avg_speed_of_traj(real_trajectory_no) );   
      if( spd .lt. vmin ) color='1721B0'     
      if( spd .ge. vmin + 0.000 * v_range .and. spd .lt. vmin + 0.025 * v_range ) color='1721B0'
      if( spd .ge. vmin + 0.025 * v_range .and. spd .lt. vmin + 0.050 * v_range ) color='1722BA'
      if( spd .ge. vmin + 0.050 * v_range .and. spd .lt. vmin + 0.075 * v_range ) color='2148D7'
      if( spd .ge. vmin + 0.075 * v_range .and. spd .lt. vmin + 0.100 * v_range ) color='366BE9'
      if( spd .ge. vmin + 0.100 * v_range .and. spd .lt. vmin + 0.125 * v_range ) color='3C86EE'
      if( spd .ge. vmin + 0.125 * v_range .and. spd .lt. vmin + 0.150 * v_range ) color='3EA7FF'
      if( spd .ge. vmin + 0.150 * v_range .and. spd .lt. vmin + 0.175 * v_range ) color='31AEFF'
      if( spd .ge. vmin + 0.175 * v_range .and. spd .lt. vmin + 0.200 * v_range ) color='23B5FF'
      if( spd .ge. vmin + 0.200 * v_range .and. spd .lt. vmin + 0.225 * v_range ) color='10BFFF'
      if( spd .ge. vmin + 0.225 * v_range .and. spd .lt. vmin + 0.250 * v_range ) color='08C9E8'
      if( spd .ge. vmin + 0.250 * v_range .and. spd .lt. vmin + 0.275 * v_range ) color='08C9E8'
      if( spd .ge. vmin + 0.275 * v_range .and. spd .lt. vmin + 0.300 * v_range ) color='07CED7'
      if( spd .ge. vmin + 0.300 * v_range .and. spd .lt. vmin + 0.325 * v_range ) color='06D7B9'
      if( spd .ge. vmin + 0.325 * v_range .and. spd .lt. vmin + 0.350 * v_range ) color='05DF9F'
      if( spd .ge. vmin + 0.350 * v_range .and. spd .lt. vmin + 0.375 * v_range ) color='04E785'
      if( spd .ge. vmin + 0.375 * v_range .and. spd .lt. vmin + 0.400 * v_range ) color='03ED71'
      if( spd .ge. vmin + 0.400 * v_range .and. spd .lt. vmin + 0.425 * v_range ) color='02F261'
      if( spd .ge. vmin + 0.425 * v_range .and. spd .lt. vmin + 0.450 * v_range ) color='02F751'
      if( spd .ge. vmin + 0.450 * v_range .and. spd .lt. vmin + 0.475 * v_range ) color='02FA47'
      if( spd .ge. vmin + 0.475 * v_range .and. spd .lt. vmin + 0.500 * v_range ) color='02FF35'
      if( spd .ge. vmin + 0.500 * v_range .and. spd .lt. vmin + 0.525 * v_range ) color='02FF35'
      if( spd .ge. vmin + 0.525 * v_range .and. spd .lt. vmin + 0.550 * v_range ) color='1FFD2F'
      if( spd .ge. vmin + 0.550 * v_range .and. spd .lt. vmin + 0.575 * v_range ) color='1FFD2F'
      if( spd .ge. vmin + 0.575 * v_range .and. spd .lt. vmin + 0.600 * v_range ) color='3CFB29'
      if( spd .ge. vmin + 0.600 * v_range .and. spd .lt. vmin + 0.625 * v_range ) color='55F924'
      if( spd .ge. vmin + 0.625 * v_range .and. spd .lt. vmin + 0.650 * v_range ) color='82F61B'
      if( spd .ge. vmin + 0.650 * v_range .and. spd .lt. vmin + 0.675 * v_range ) color='A7F314'
      if( spd .ge. vmin + 0.675 * v_range .and. spd .lt. vmin + 0.700 * v_range ) color='CBF00D'
      if( spd .ge. vmin + 0.700 * v_range .and. spd .lt. vmin + 0.725 * v_range ) color='E7EE08'
      if( spd .ge. vmin + 0.725 * v_range .and. spd .lt. vmin + 0.750 * v_range ) color='FFEE04'
      if( spd .ge. vmin + 0.750 * v_range .and. spd .lt. vmin + 0.775 * v_range ) color='FED90B'
      if( spd .ge. vmin + 0.775 * v_range .and. spd .lt. vmin + 0.800 * v_range ) color='FDC113'
      if( spd .ge. vmin + 0.800 * v_range .and. spd .lt. vmin + 0.825 * v_range ) color='FCAC1A'
      if( spd .ge. vmin + 0.825 * v_range .and. spd .lt. vmin + 0.850 * v_range ) color='FC9721'
      if( spd .ge. vmin + 0.850 * v_range .and. spd .lt. vmin + 0.875 * v_range ) color='FC8726'
      if( spd .ge. vmin + 0.875 * v_range .and. spd .lt. vmin + 0.900 * v_range ) color='FC752C'
      if( spd .ge. vmin + 0.900 * v_range .and. spd .lt. vmin + 0.925 * v_range ) color='FC6B30'
      if( spd .ge. vmin + 0.925 * v_range .and. spd .lt. vmin + 0.950 * v_range ) color='FC6134'
      if( spd .ge. vmin + 0.950 * v_range .and. spd .lt. vmin + 0.975 * v_range ) color='FC5438'
      if( spd .ge. vmin + 0.975 * v_range                                       ) color='FC0000'

! Now write this real trajectory to input file for ImageJ MTrackJ, MTrackJ_Input_Real_Trajectory_File_automatic_MANUALLY.mdf    
      write(800,5970) real_trajectory_no, color; 5970 format('Track ',i8,3x,A6); 
      do tc = 1 , ( real_trajectory_total_length(real_trajectory_no) ) ! scan of length of a real trajectory   
         ic = real_trajectory_centroid(real_trajectory_no,tc)      
         ! Note that y is inverted, since I now am using the regular origin in lower left, lower right of the FOV, not ImageJ's goofy origin in upper left.
         inverted_y = y_pixels - y(ic)
         write(800,5800) tc, x(ic), inverted_y, frame_no_of_a_centroid(ic) !, ic, x(ic), y(ic);  ! Write real traj point to MTrackJ file        
      end do
      5800 format('Point ',i8,1x,f6.1,1x,f6.1,1x,'1.0',1x,i7,1x,'1.0')   !,10x,' cent=',i8,' x(cent)=',f10.2,'  y(cent)=',f10.2); 



! _________________ END OF PSEUDOCOLOR REAL TRAJECTORY MANUALLY FOR MTRACKJ FILE ___________________________________
